/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.eternal;

import com.mojang.datafixers.util.Either;
import iskallia.vault.config.EternalAuraConfig;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ActiveEternalMessage;
import iskallia.vault.util.SkinProfile;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class ActiveEternalData {
    private static final Integer ETERNAL_TIMEOUT = 160;
    private static final ActiveEternalData INSTANCE = new ActiveEternalData();
    private final Map<UUID, Set<ActiveEternal>> eternals = new HashMap<UUID, Set<ActiveEternal>>();

    private ActiveEternalData() {
    }

    public static ActiveEternalData getInstance() {
        return INSTANCE;
    }

    public void updateEternal(EternalEntity eternal) {
        Either<UUID, ServerPlayer> owner = eternal.getOwner();
        if (owner.left().isPresent()) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)owner.right().get();
        if (!sPlayer.m_20193_().m_46472_().equals((Object)eternal.m_20193_().m_46472_())) {
            return;
        }
        UUID ownerId = sPlayer.m_142081_();
        boolean update = false;
        ActiveEternal active = this.getActive(ownerId, eternal);
        if (active == null) {
            active = ActiveEternal.create(eternal);
            this.eternals.computeIfAbsent(ownerId, id -> new LinkedHashSet()).add(active);
            update = true;
        }
        active.timeout = ETERNAL_TIMEOUT;
        float current = active.health;
        float healthToSet = eternal.m_21223_();
        if (healthToSet <= 0.0f || Math.abs(current - healthToSet) >= 0.3f) {
            active.health = healthToSet;
            update = true;
        }
        if (!Objects.equals(active.abilityName, eternal.getProvidedAura())) {
            active.abilityName = eternal.getProvidedAura();
            update = true;
        }
        if (!Objects.equals(active.eternalName, eternal.getSkinName())) {
            active.eternalName = eternal.getSkinName();
            update = true;
        }
        if (update) {
            this.syncActives(ownerId, this.eternals.getOrDefault(ownerId, Collections.emptySet()));
        }
    }

    @Nullable
    private ActiveEternal getActive(UUID ownerId, EternalEntity eternal) {
        UUID eternalId = eternal.getEternalId();
        Set activeEternals = this.eternals.computeIfAbsent(ownerId, id -> new LinkedHashSet());
        for (ActiveEternal activeEternal : activeEternals) {
            if (!activeEternal.eternalId.equals(eternalId)) continue;
            return activeEternal;
        }
        return null;
    }

    public boolean isEternalActive(UUID eternalId) {
        for (Set<ActiveEternal> activeEternals : this.eternals.values()) {
            for (ActiveEternal activeEternal : activeEternals) {
                if (!activeEternal.eternalId.equals(eternalId)) continue;
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        ActiveEternalData.INSTANCE.eternals.forEach((playerId, activeEternals) -> {
            boolean removedAny = activeEternals.removeIf(activeEternal -> {
                --activeEternal.timeout;
                return activeEternal.timeout <= 0;
            });
            if (removedAny) {
                INSTANCE.syncActives((UUID)playerId, (Set<ActiveEternal>)activeEternals);
            }
        });
    }

    @SubscribeEvent
    public static void onChangeDim(EntityTravelToDimensionEvent event) {
        Set<ActiveEternal> eternals;
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        UUID playerId = event.getEntity().m_142081_();
        if (ActiveEternalData.INSTANCE.eternals.containsKey(playerId) && (eternals = ActiveEternalData.INSTANCE.eternals.remove(playerId)) != null && !eternals.isEmpty()) {
            INSTANCE.syncActives((ServerPlayer)event.getEntity(), Collections.emptySet());
        }
    }

    private void syncActives(UUID playerId, Set<ActiveEternal> eternals) {
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        if (srv == null) {
            return;
        }
        ServerPlayer sPlayer = srv.m_6846_().m_11259_(playerId);
        if (sPlayer == null) {
            return;
        }
        this.syncActives(sPlayer, eternals);
    }

    private void syncActives(ServerPlayer sPlayer, Set<ActiveEternal> eternals) {
        ModNetwork.CHANNEL.sendTo((Object)new ActiveEternalMessage(eternals), sPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static class ActiveEternal {
        private final UUID eternalId;
        private final boolean ancient;
        private String eternalName;
        private String abilityName;
        private float health;
        private int timeout = ETERNAL_TIMEOUT;
        private SkinProfile skinUtil = null;

        private ActiveEternal(UUID eternalId, String eternalName, String abilityName, boolean ancient, float health) {
            this.eternalId = eternalId;
            this.eternalName = eternalName;
            this.abilityName = abilityName;
            this.ancient = ancient;
            this.health = health;
        }

        public static ActiveEternal create(EternalEntity eternal) {
            return new ActiveEternal(eternal.getEternalId(), eternal.getSkinName(), eternal.getProvidedAura(), eternal.isAncient(), eternal.m_21223_());
        }

        public static ActiveEternal read(FriendlyByteBuf buffer) {
            return new ActiveEternal(buffer.m_130259_(), buffer.m_130136_(Short.MAX_VALUE), buffer.readBoolean() ? buffer.m_130136_(Short.MAX_VALUE) : null, buffer.readBoolean(), buffer.readFloat());
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.m_130077_(this.eternalId);
            buffer.m_130072_(this.eternalName, Short.MAX_VALUE);
            buffer.writeBoolean(this.abilityName != null);
            if (this.abilityName != null) {
                buffer.m_130072_(this.abilityName, Short.MAX_VALUE);
            }
            buffer.writeBoolean(this.ancient);
            buffer.writeFloat(this.health);
        }

        public String getAbilityName() {
            return this.abilityName;
        }

        public Optional<EternalAuraConfig.AuraConfig> getAbilityConfig() {
            if (this.getAbilityName() == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(ModConfigs.ETERNAL_AURAS.getByName(this.getAbilityName()));
        }

        public boolean isAncient() {
            return this.ancient;
        }

        public float getHealth() {
            return this.health;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void updateFrom(ActiveEternal activeEternal) {
            this.health = activeEternal.health;
            this.abilityName = activeEternal.abilityName;
            if (!this.eternalName.equals(activeEternal.eternalName)) {
                this.eternalName = activeEternal.eternalName;
                if (this.skinUtil != null) {
                    this.skinUtil.updateSkin(this.eternalName);
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public SkinProfile getSkin() {
            if (this.skinUtil == null) {
                this.skinUtil = new SkinProfile();
                this.skinUtil.updateSkin(this.eternalName);
            }
            return this.skinUtil;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActiveEternal that = (ActiveEternal)o;
            return Objects.equals(this.eternalId, that.eternalId);
        }

        public int hashCode() {
            return Objects.hash(this.eternalId);
        }
    }
}

