/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.eternal;

import iskallia.vault.entity.eternal.EternalAttributes;
import iskallia.vault.entity.eternal.EternalAura;
import iskallia.vault.entity.eternal.EternalDataAccess;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.world.data.EternalsData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.server.ServerLifecycleHooks;

public class EternalData
implements INBTSerializable<CompoundTag>,
EternalDataAccess {
    private UUID uuid = UUID.randomUUID();
    private String name;
    private String originalName;
    private long eternalSeed = 3274487651937260739L;
    private final Map<EquipmentSlot, ItemStack> equipment = new HashMap<EquipmentSlot, ItemStack>();
    private EternalAttributes attributes = new EternalAttributes();
    private EternalAura ability = null;
    private int level = 0;
    private int usedLevels = 0;
    private int levelExp = 0;
    private boolean alive = true;
    private boolean ancient = false;
    private final EternalsData dataDelegate;
    private AttributeSnapshot snapshot = AttributeSnapshot.EMPTY;
    private EternalsData.EternalVariant variant = EternalsData.EternalVariant.CAVE;
    private boolean isUsingPlayerSkin = false;

    private EternalData(EternalsData dataDelegate, String name, boolean isAncient, EternalsData.EternalVariant variant, boolean isUsingPlayerSkin) {
        this.dataDelegate = dataDelegate;
        this.name = name;
        this.originalName = name;
        this.ancient = isAncient;
        this.attributes.initializeAttributes();
        this.variant = variant;
        this.isUsingPlayerSkin = isUsingPlayerSkin;
        this.refreshSnapshot();
    }

    private EternalData(EternalsData dataDelegate, CompoundTag nbt) {
        this.dataDelegate = dataDelegate;
        this.deserializeNBT(nbt);
        this.refreshSnapshot();
    }

    public static EternalData createEternal(EternalsData data, String name, boolean isAncient, EternalsData.EternalVariant variant, boolean isUsingPlayerSkin) {
        return new EternalData(data, name, isAncient, variant, isUsingPlayerSkin);
    }

    public static EternalData fromNBT(EternalsData data, CompoundTag nbt) {
        return new EternalData(data, nbt);
    }

    private void refreshSnapshot() {
        this.snapshot = AttributeSnapshotHelper.getInstance().makeGearSnapshot(this::getStack);
    }

    @Override
    public UUID getId() {
        return this.uuid;
    }

    @Override
    public long getSeed() {
        return this.eternalSeed;
    }

    public void shuffleSeed() {
        this.eternalSeed = new Random().nextLong();
        this.dataDelegate.m_77762_();
    }

    public void setName(String name) {
        this.name = name;
        this.dataDelegate.m_77762_();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public EternalAttributes getAttributes() {
        return this.attributes;
    }

    public AttributeSnapshot getAttributeSnapshot() {
        return this.snapshot;
    }

    public void addAttributeValue(Attribute attribute, float value) {
        if (this.usedLevels >= this.level) {
            return;
        }
        ++this.usedLevels;
        this.attributes.addAttributeValue(attribute, value);
        this.dataDelegate.m_77762_();
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getUsedLevels() {
        return this.usedLevels;
    }

    @Override
    public int getMaxLevel() {
        AtomicInteger integer = new AtomicInteger(0);
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        UUID playerId = this.dataDelegate.getOwnerOf(this.getId());
        integer.set(PlayerVaultStatsData.get(srv).getVaultStats(playerId).getVaultLevel());
        return integer.get();
    }

    public int getMaxLevel(ServerLevel level) {
        UUID playerId = this.dataDelegate.getOwnerOf(this.getId());
        return PlayerVaultStatsData.get(level).getVaultStats(playerId).getVaultLevel();
    }

    public float getLevelPercent() {
        int expNeeded = ModConfigs.LEVELS_META.getLevelMeta((int)this.getLevel()).tnl;
        return (float)this.levelExp / (float)expNeeded;
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
        this.dataDelegate.m_77762_();
    }

    @Override
    public boolean isAncient() {
        return this.ancient;
    }

    @Override
    public EternalsData.EternalVariant getVariant() {
        return this.variant;
    }

    @Override
    public boolean isUsingPlayerSkin() {
        return this.isUsingPlayerSkin;
    }

    public void setUsingPlayerSkin(boolean usingPlayerSkin) {
        this.isUsingPlayerSkin = usingPlayerSkin;
    }

    public void setAncient(boolean ancient) {
        this.ancient = ancient;
        this.dataDelegate.m_77762_();
    }

    public boolean addExp(int xp) {
        if (this.level >= this.getMaxLevel()) {
            return false;
        }
        this.levelExp += xp;
        int expNeeded = ModConfigs.LEVELS_META.getLevelMeta((int)this.getLevel()).tnl;
        if (this.levelExp >= expNeeded) {
            ++this.level;
            this.levelExp -= expNeeded;
        }
        this.dataDelegate.m_77762_();
        return true;
    }

    @Nullable
    public EternalAura getAura() {
        return this.ability;
    }

    public void setAura(@Nullable String auraName) {
        this.ability = auraName == null ? null : new EternalAura(auraName);
        this.dataDelegate.m_77762_();
    }

    @Override
    @Nullable
    public String getAbilityName() {
        return this.ability == null ? null : this.ability.getAuraName();
    }

    @Override
    public Map<EquipmentSlot, ItemStack> getEquipment() {
        return Collections.unmodifiableMap(this.equipment);
    }

    public ItemStack getStack(EquipmentSlot slot) {
        return this.equipment.getOrDefault(slot, ItemStack.f_41583_);
    }

    public void setStack(EquipmentSlot slot, ItemStack stack) {
        this.equipment.put(slot, stack);
        this.dataDelegate.m_77762_();
        this.refreshSnapshot();
    }

    @Override
    public Map<Attribute, Float> getEntityAttributes() {
        return Collections.unmodifiableMap(this.attributes.getAttributes());
    }

    public EquipmentInventory getEquipmentInventory(Runnable onChange) {
        return new EquipmentInventory(this, onChange);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("Id", this.getId());
        nbt.m_128359_("Name", this.getName());
        nbt.m_128359_("originalName", this.getOriginalName());
        nbt.m_128356_("eternalSeed", this.getSeed());
        CompoundTag tag = new CompoundTag();
        this.equipment.forEach((slot, stack) -> tag.m_128365_(slot.m_20751_(), (Tag)stack.serializeNBT()));
        nbt.m_128365_("equipment", (Tag)tag);
        if (this.getAura() != null) {
            nbt.m_128365_("ability", (Tag)this.getAura().serializeNBT());
        }
        nbt.m_128405_("level", this.level);
        nbt.m_128405_("usedLevels", this.usedLevels);
        nbt.m_128405_("levelExp", this.levelExp);
        nbt.m_128379_("alive", this.alive);
        nbt.m_128379_("ancient", this.ancient);
        nbt.m_128365_("attributes", (Tag)this.attributes.serializeNBT());
        nbt.m_128405_("variant", this.variant.getId());
        nbt.m_128379_("isUsingPlayerSkin", this.isUsingPlayerSkin);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.uuid = nbt.m_128342_("Id");
        this.name = nbt.m_128461_("Name");
        this.originalName = nbt.m_128425_("originalName", 8) ? nbt.m_128461_("originalName") : this.name;
        this.eternalSeed = nbt.m_128425_("eternalSeed", 4) ? nbt.m_128454_("eternalSeed") : 3274487651937260739L;
        this.equipment.clear();
        CompoundTag equipment = nbt.m_128469_("equipment");
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (!equipment.m_128425_(slot.m_20751_(), 10)) continue;
            ItemStack stack = ItemStack.m_41712_((CompoundTag)equipment.m_128469_(slot.m_20751_()));
            this.equipment.put(slot, stack);
        }
        this.ability = nbt.m_128425_("ability", 10) ? new EternalAura(nbt.m_128469_("ability")) : null;
        this.level = nbt.m_128425_("level", 3) ? nbt.m_128451_("level") : 0;
        this.usedLevels = nbt.m_128425_("usedLevels", 3) ? nbt.m_128451_("usedLevels") : 0;
        this.levelExp = nbt.m_128451_("levelExp");
        this.alive = !nbt.m_128425_("alive", 1) || nbt.m_128471_("alive");
        boolean bl = this.ancient = nbt.m_128425_("ancient", 1) && nbt.m_128471_("ancient");
        if (!nbt.m_128425_("attributes", 10)) {
            this.attributes = new EternalAttributes();
            this.attributes.initializeAttributes();
        } else {
            this.attributes = EternalAttributes.fromNBT(nbt.m_128469_("attributes"));
        }
        this.variant = EternalsData.EternalVariant.byId(nbt.m_128451_("variant"));
        this.isUsingPlayerSkin = nbt.m_128471_("isUsingPlayerSkin");
        if (nbt.m_128441_("MainSlots")) {
            ListTag mainSlotsList = nbt.m_128437_("MainSlots", 10);
            for (int i = 0; i < Math.min(mainSlotsList.size(), EquipmentSlot.values().length); ++i) {
                EquipmentSlot slot = EquipmentSlot.values()[i];
                if (slot == EquipmentSlot.OFFHAND) continue;
                this.equipment.put(slot, ItemStack.m_41712_((CompoundTag)mainSlotsList.m_128728_(i)));
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EternalData)) {
            return false;
        }
        EternalData other = (EternalData)o;
        return this.uuid.equals(other.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public static class EquipmentInventory
    implements Container {
        private final EternalData eternal;
        private final Runnable onChange;

        public EquipmentInventory(EternalData eternal, Runnable onChange) {
            this.eternal = eternal;
            this.onChange = onChange;
        }

        public int m_6643_() {
            return 5;
        }

        public boolean m_7983_() {
            return this.eternal.getEquipment().entrySet().stream().anyMatch(entry -> !((ItemStack)entry.getValue()).m_41619_());
        }

        public ItemStack m_8020_(int index) {
            return this.eternal.getStack(this.getSlotFromIndex(index));
        }

        public ItemStack m_7407_(int index, int count) {
            ItemStack stack = this.m_8020_(index);
            if (!stack.m_41619_() && count > 0) {
                ItemStack split = stack.m_41620_(count);
                this.m_6836_(index, stack);
                if (!split.m_41619_()) {
                    this.m_6596_();
                }
                return split;
            }
            return ItemStack.f_41583_;
        }

        public ItemStack m_8016_(int index) {
            EquipmentSlot slotType = this.getSlotFromIndex(index);
            ItemStack equipment = this.eternal.getStack(slotType);
            this.eternal.setStack(slotType, ItemStack.f_41583_);
            this.m_6596_();
            return equipment;
        }

        public void m_6836_(int index, ItemStack stack) {
            this.eternal.setStack(this.getSlotFromIndex(index), stack.m_41777_());
            this.m_6596_();
        }

        public void m_6596_() {
            this.onChange.run();
            this.eternal.dataDelegate.m_77762_();
        }

        public boolean m_6542_(Player player) {
            return true;
        }

        public void m_6211_() {
            for (EquipmentSlot slotType : EquipmentSlot.values()) {
                this.eternal.setStack(slotType, ItemStack.f_41583_);
            }
            this.m_6596_();
        }

        private EquipmentSlot getSlotFromIndex(int index) {
            if (index == 0) {
                return EquipmentSlot.MAINHAND;
            }
            return EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)(index - 1));
        }
    }
}

