/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.eternal;

import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.eternal.EternalDataAccess;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModEntities;
import iskallia.vault.world.data.EternalsData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EternalHelper {
    private static final UUID ETERNAL_SIZE_INCREASE = UUID.fromString("de6b75be-deb2-4711-8fac-08465031b2c3");

    public static EternalEntity spawnEternal(Level world, EternalDataAccess dataAccess) {
        return EternalHelper.spawnEternal(world, dataAccess.getLevel(), dataAccess.isAncient(), dataAccess.getName(), dataAccess.getEquipment(), dataAccess.getEntityAttributes(), dataAccess.getVariant(), dataAccess.isUsingPlayerSkin());
    }

    private static EternalEntity spawnEternal(Level world, int level, boolean isAncient, String name, Map<EquipmentSlot, ItemStack> equipment, Map<Attribute, Float> attributes, EternalsData.EternalVariant variant, boolean isUsingPlayerSkin) {
        EternalEntity eternal = (EternalEntity)ModEntities.ETERNAL.m_20615_(world);
        eternal.m_6593_((Component)new TextComponent("[").m_130940_(ChatFormatting.GREEN).m_7220_((Component)new TextComponent(String.valueOf(level)).m_130940_(ChatFormatting.RED)).m_7220_((Component)new TextComponent("] " + name).m_130940_(ChatFormatting.GREEN)));
        eternal.setSkinName(name);
        equipment.forEach((slot, stack) -> {
            eternal.m_8061_((EquipmentSlot)slot, stack.m_41777_());
            eternal.m_21409_((EquipmentSlot)slot, 0.0f);
        });
        attributes.forEach((attribute, value) -> eternal.m_21051_((Attribute)attribute).m_22100_((double)value.floatValue()));
        eternal.m_5634_(2.1474836E9f);
        if (isAncient) {
            eternal.m_21051_(ModAttributes.SIZE_SCALE).m_22100_((double)1.2f);
        }
        eternal.setVariant(variant);
        eternal.setUsingPlayerSkin(isUsingPlayerSkin);
        return eternal;
    }

    public static float getEternalGearModifierAdjustments(EternalDataAccess dataAccess, Attribute attribute, float value) {
        HashMap modifiers = new HashMap();
        for (EquipmentSlot slotType : EquipmentSlot.values()) {
            ItemStack stack = dataAccess.getEquipment().getOrDefault(slotType, ItemStack.f_41583_);
            if (stack.m_41619_()) continue;
            stack.m_41638_(slotType).get((Object)attribute).forEach(modifier -> modifiers.computeIfAbsent(modifier.m_22217_(), op -> new ArrayList()).add(modifier));
        }
        for (AttributeModifier modifier2 : modifiers.getOrDefault(AttributeModifier.Operation.ADDITION, Collections.emptyList())) {
            value = (float)((double)value + modifier2.m_22218_());
        }
        float val = value;
        for (AttributeModifier modifier3 : modifiers.getOrDefault(AttributeModifier.Operation.MULTIPLY_BASE, Collections.emptyList())) {
            val = (float)((double)val + (double)value * modifier3.m_22218_());
        }
        for (AttributeModifier modifier4 : modifiers.getOrDefault(AttributeModifier.Operation.MULTIPLY_TOTAL, Collections.emptyList())) {
            val = (float)((double)val * modifier4.m_22218_());
        }
        return val;
    }
}

