/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.renderer;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.VaultMod;
import iskallia.vault.entity.entity.AncientCopperGolemEntity;
import iskallia.vault.entity.model.AncientCopperGolemModel;
import iskallia.vault.entity.model.ModModelLayers;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;

public class AncientCopperGolemRenderer
extends HumanoidMobRenderer<AncientCopperGolemEntity, AncientCopperGolemModel<AncientCopperGolemEntity>> {
    private static final ResourceLocation COPPER = VaultMod.id("textures/entity/ancient_copper_golem/copper.png");
    private static final ResourceLocation EXPOSED = VaultMod.id("textures/entity/ancient_copper_golem/exposed.png");
    private static final ResourceLocation WEATHERED = VaultMod.id("textures/entity/ancient_copper_golem/weathered.png");
    private static final ResourceLocation OXIDIZED = VaultMod.id("textures/entity/ancient_copper_golem/oxidized.png");
    private final SkullModel skullModel;

    public AncientCopperGolemRenderer(EntityRendererProvider.Context context) {
        super(context, new AncientCopperGolemModel(context.m_174023_(ModModelLayers.ANCIENT_COPPER_GOLEM)), 0.3f);
        this.skullModel = new SkullModel(context.m_174023_(ModelLayers.f_171163_));
    }

    protected void setupRotations(AncientCopperGolemEntity pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        super.m_7523_((LivingEntity)pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        if (pEntityLiving.getWaxed()) {
            pEntityLiving.getPosing().ifPresent(pEntityLiving::loadAngles);
        }
    }

    public void render(AncientCopperGolemEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        if (pEntity.skin != null && pEntity.skin.gameProfile.get() != null && !pEntity.m_21224_()) {
            GameProfile profile = pEntity.skin.gameProfile.get();
            RenderType rendertype = AncientCopperGolemRenderer.getRenderType(profile);
            if (pEntity.getWaxed()) {
                AncientCopperGolemRenderer.renderSkull(pEntity.f_20883_ + 180.0f, pMatrixStack, pBuffer, pPackedLight, this.skullModel, rendertype);
            } else {
                AncientCopperGolemRenderer.renderSkull(Mth.m_14179_((float)pPartialTicks, (float)pEntity.f_20884_, (float)pEntity.f_20883_) + 180.0f, pMatrixStack, pBuffer, pPackedLight, this.skullModel, rendertype);
            }
        }
    }

    protected void renderNameTag(AncientCopperGolemEntity pEntity, Component pDisplayName, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.m_85836_();
        pMatrixStack.m_85837_(0.0, 0.3, 0.0);
        super.m_7649_((Entity)pEntity, pDisplayName, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.m_85849_();
    }

    public static void renderSkull(float pYRot, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, SkullModel pModel, RenderType pRenderType) {
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.0, 1.0, 0.0);
        pPoseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        VertexConsumer vertexconsumer = pBufferSource.m_6299_(pRenderType);
        pModel.m_142698_(0.0f, pYRot, 0.0f);
        pModel.m_7695_(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pPoseStack.m_85849_();
    }

    public static RenderType getRenderType(@Nullable GameProfile pGameProfile) {
        ResourceLocation resourcelocation = DefaultPlayerSkin.m_118626_();
        if (pGameProfile != null) {
            Minecraft minecraft = Minecraft.m_91087_();
            Map map = minecraft.m_91109_().m_118815_(pGameProfile);
            return map.containsKey(MinecraftProfileTexture.Type.SKIN) ? RenderType.m_110473_((ResourceLocation)minecraft.m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN)) : RenderType.m_110458_((ResourceLocation)DefaultPlayerSkin.m_118627_((UUID)Player.m_36198_((GameProfile)pGameProfile)));
        }
        return RenderType.m_110464_((ResourceLocation)resourcelocation);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull AncientCopperGolemEntity entity) {
        return switch (entity.getTypeVariant()) {
            case 1 -> EXPOSED;
            case 2 -> WEATHERED;
            case 3 -> OXIDIZED;
            default -> COPPER;
        };
    }
}

