/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.entity.entity.VaultFireball;
import iskallia.vault.entity.model.FireballModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FireballRenderer
extends EntityRenderer<VaultFireball> {
    public static final ResourceLocation FIREBALL = VaultMod.id("textures/entity/fireball.png");
    private final FireballModel model;

    public FireballRenderer(EntityRendererProvider.Context p_174420_) {
        super(p_174420_);
        this.model = new FireballModel(p_174420_.m_174023_(FireballModel.MODEL_LOCATION));
    }

    public void render(VaultFireball pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        float alpha = (float)(VaultFireball.MAX_AGE - pEntity.getAge()) / (float)VaultFireball.MAX_AGE;
        pMatrixStack.m_85836_();
        pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)pPartialTicks, (float)pEntity.f_19859_, (float)pEntity.m_146908_()) - 90.0f));
        pMatrixStack.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14179_((float)pPartialTicks, (float)pEntity.f_19860_, (float)pEntity.m_146909_()) + 90.0f));
        pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)pPartialTicks, (float)((float)(pEntity.f_19797_ - 1) * 15.0f), (float)((float)pEntity.f_19797_ * 15.0f))));
        float scale = 1.1f;
        if (pEntity.getFireballType() == VaultFireball.FireballType.FIRESHOT) {
            scale = 0.5f;
        }
        pMatrixStack.m_85841_(scale, scale, scale);
        VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(pEntity)));
        float red = 1.0f;
        Model model = this.getModel(pEntity);
        if (model != null) {
            model.m_7695_(pMatrixStack, vertexconsumer, 0xF000F0, OverlayTexture.f_118083_, red, 1.0f, 1.0f, alpha);
        }
        pMatrixStack.m_85849_();
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public Model getModel(VaultFireball pEntity) {
        return this.model;
    }

    public ResourceLocation getTextureLocation(VaultFireball pEntity) {
        return FIREBALL;
    }
}

