/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.renderer.elite;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.entity.model.ModModelLayers;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EliteEnderOrnamentLayer<T extends EnderMan>
extends RenderLayer<T, EndermanModel<T>> {
    public static final ResourceLocation ORNAMENT_TEXTURE = VaultMod.id("textures/entity/elite/enderman_ornament.png");
    protected float angleOffset;
    protected EnderOrnamentModel model;

    public EliteEnderOrnamentLayer(RenderLayerParent<T, EndermanModel<T>> renderer, EntityModelSet modelSet, float angleOffset) {
        super(renderer);
        this.angleOffset = angleOffset;
        this.model = new EnderOrnamentModel(modelSet.m_171103_(ModModelLayers.ELITE_ENDERMAN_ORNAMENT));
    }

    public void render(@Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource bufferSource, int pPackedLight, @Nonnull T entity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, -2.0, 0.0);
        float radius = 0.8f;
        float angle = this.angleOffset + pAgeInTicks * 3.5f;
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(30.0f));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(angle));
        matrixStack.m_85837_((double)radius, 0.0, 0.0);
        matrixStack.m_85845_(Vector3f.f_122226_.m_122240_(angle));
        matrixStack.m_85845_(Vector3f.f_122222_.m_122240_(30.0f));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(pNetHeadYaw));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(pHeadPitch));
        float scale = 0.75f;
        matrixStack.m_85841_(scale, scale, scale);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(this.model.m_103119_(ORNAMENT_TEXTURE));
        this.model.m_7695_(matrixStack, vertexConsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }

    public static class EnderOrnamentModel
    extends Model {
        private final ModelPart body;

        public EnderOrnamentModel(ModelPart root) {
            super(RenderType::m_110458_);
            this.body = root.m_171324_("body");
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.m_171576_();
            PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.5f)).m_171514_(4, 21).m_171488_(-2.0f, -3.0f, -1.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
            return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
        }

        public void m_7695_(@Nonnull PoseStack matrixStack, @Nonnull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.body.m_104306_(matrixStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }
}

