/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.renderer.mushroom;

import iskallia.vault.VaultMod;
import iskallia.vault.entity.entity.mushroom.MushroomEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;

public abstract class MushroomRenderer<M extends MushroomEntity>
extends MobRenderer<M, EntityModel<M>> {
    private static final Map<String, ResourceLocation> LOCATION_BY_PATH = new HashMap<String, ResourceLocation>();
    private static final Map<Integer, String> TYPE_BY_VARIANT = (Map)Util.m_137469_(new HashMap(), textures -> {
        textures.put(0, "purple");
        textures.put(1, "red");
    });

    public MushroomRenderer(EntityRendererProvider.Context ctx, Supplier<EntityModel<M>> modelSupplier) {
        super(ctx, modelSupplier.get(), 0.5f);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(M entity) {
        String type = TYPE_BY_VARIANT.getOrDefault(((MushroomEntity)((Object)entity)).getTypeVariant(), TYPE_BY_VARIANT.get(0));
        String path = "textures/entity/mushroom/t%d/%s.png".formatted(((MushroomEntity)((Object)entity)).getTier(), type);
        return LOCATION_BY_PATH.computeIfAbsent(path, VaultMod::id);
    }
}

