/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.etching;

import iskallia.vault.etching.EtchingSet;
import iskallia.vault.event.event.VaultGearEquipmentChangeEvent;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.world.data.PlayerEtchingData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class EtchingHelper {
    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        PlayerEtchingData.get(srv).tick(srv);
    }

    @SubscribeEvent
    public static void onGearChange(VaultGearEquipmentChangeEvent event) {
        PlayerEtchingData.get(event.getPlayer().f_8924_).refreshEtchingSets(event.getPlayer());
    }

    public static List<EtchingSet<?>> getEquippedEtchings(LivingEntity entity) {
        ArrayList foundEtchings = new ArrayList();
        Map<EtchingSet<?>, Integer> equippedEtchings = EtchingHelper.getEquippedEtchingCount(entity);
        equippedEtchings.forEach((etchingSet, count) -> {
            if (count >= 4) {
                foundEtchings.add((EtchingSet<?>)((Object)etchingSet));
            }
        });
        return foundEtchings;
    }

    public static Map<EtchingSet<?>, Integer> getEquippedEtchingCount(LivingEntity entity) {
        HashMap etchings = new HashMap();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            VaultGearData data;
            EtchingSet etching;
            Object item;
            ItemStack stack = entity.m_6844_(slot);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultGearItem) || !(item = VaultGearItem.of(stack)).isIntendedForSlot(stack, slot) || (etching = (EtchingSet)(data = VaultGearData.read(stack)).getFirstValue(ModGearAttributes.ETCHING).orElse(null)) == null) continue;
            int count = etchings.getOrDefault((Object)etching, 0);
            etchings.put(etching, count + 1);
        }
        return etchings;
    }
}

