/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.etching.set;

import com.google.common.collect.Lists;
import com.google.gson.annotations.Expose;
import iskallia.vault.etching.EtchingSet;
import iskallia.vault.etching.set.GearAttributeSet;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.init.ModGearAttributes;
import java.util.List;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class DryadSet
extends EtchingSet<Config>
implements GearAttributeSet {
    private static final UUID HEALTH_MODIFIER_ID = UUID.fromString("a31d29a6-072c-46e2-b623-2740a7508afe");

    public DryadSet(ResourceLocation name) {
        super(name);
    }

    @Override
    public Class<Config> getConfigClass() {
        return Config.class;
    }

    @Override
    public Config getDefaultConfig() {
        return new Config(20.0f);
    }

    @Override
    public void tick(ServerPlayer player) {
        super.tick(player);
        AttributeInstance instance = player.m_21051_(Attributes.f_22276_);
        AttributeModifier mod = instance.m_22111_(HEALTH_MODIFIER_ID);
        if (mod == null) {
            instance.m_22118_(new AttributeModifier(HEALTH_MODIFIER_ID, "Dryad Added Health", (double)((Config)this.getConfig()).getExtraHealth(), AttributeModifier.Operation.ADDITION));
        }
    }

    @Override
    public void remove(ServerPlayer player) {
        super.remove(player);
        player.m_21051_(Attributes.f_22276_).m_22120_(HEALTH_MODIFIER_ID);
    }

    @Override
    public List<VaultGearAttributeInstance<?>> getAttributes() {
        return Lists.newArrayList((Object[])new VaultGearAttributeInstance[]{new VaultGearAttributeInstance<Float>(ModGearAttributes.HEALTH, Float.valueOf(((Config)this.getConfig()).getExtraHealth()))});
    }

    public static class Config {
        @Expose
        private float extraHealth;

        public Config(float extraHealth) {
            this.extraHealth = extraHealth;
        }

        public float getExtraHealth() {
            return this.extraHealth;
        }
    }
}

