/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import iskallia.vault.block.TreasureDoorBlock;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.gear.FocusItem;
import iskallia.vault.item.gear.IdolItem;
import iskallia.vault.item.gear.VaultShieldItem;
import iskallia.vault.item.gear.WandItem;
import iskallia.vault.network.message.ClientboundPlayerLastDamageSourceMessage;
import iskallia.vault.network.message.MobCritParticleMessage;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.calc.PlayerStat;
import iskallia.vault.util.damage.ThornsReflectDamageSource;
import iskallia.vault.world.data.DiscoveredModelsData;
import iskallia.vault.world.data.ServerVaults;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityEvents {
    @SubscribeEvent
    public static void onTradesLoad(VillagerTradesEvent event) {
        for (List trades : event.getTrades().values()) {
            trades.removeIf(trade -> {
                try {
                    MerchantOffer offer = trade.m_5670_(null, new Random());
                    ItemStack output = offer.m_45370_();
                    if (output.m_41619_()) {
                        return true;
                    }
                    Item outItem = output.m_41720_();
                    if (outItem == Items.f_41852_) {
                        return true;
                    }
                    if (outItem instanceof ShieldItem) {
                        return true;
                    }
                    if (outItem instanceof TippedArrowItem) {
                        return true;
                    }
                    if (!outItem.getRegistryName().m_135827_().equals("minecraft")) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onDamageTotem(LivingHurtEvent event) {
        Level world = event.getEntity().m_20193_();
        if (world.m_5776_() || !(world instanceof ServerLevel)) {
            return;
        }
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (event.getSource().m_19376_()) {
            return;
        }
        ItemStack offHand = event.getEntityLiving().m_21206_();
        if (ServerVaults.get(world).isEmpty() && offHand.m_41720_() instanceof VaultGearItem) {
            return;
        }
        if (!(offHand.m_41720_() instanceof IdolItem || offHand.m_41720_() instanceof VaultShieldItem || offHand.m_41720_() instanceof WandItem || offHand.m_41720_() instanceof FocusItem)) {
            return;
        }
        int damage = (int)CommonEvents.PLAYER_STAT.invoke(PlayerStat.DURABILITY_DAMAGE, (LivingEntity)player, Math.max(1.0f, event.getAmount() / 6.0f)).getValue();
        if (damage <= 1) {
            damage = 1;
        }
        offHand.m_41622_(damage, event.getEntityLiving(), entity -> entity.m_21166_(EquipmentSlot.OFFHAND));
    }

    @SubscribeEvent
    public static void onDamageArmorHit(LivingDamageEvent event) {
        Player player;
        LivingEntity damaged;
        block6: {
            block5: {
                damaged = event.getEntityLiving();
                if (!(damaged instanceof Player)) break block5;
                player = (Player)damaged;
                if (!damaged.m_20193_().m_5776_()) break block6;
            }
            return;
        }
        Entity trueSrc = event.getSource().m_7639_();
        if (trueSrc instanceof LivingEntity) {
            for (double chance = ((LivingEntity)trueSrc).m_21133_(ModAttributes.BREAK_ARMOR_CHANCE); chance > 0.0 && !((double)damaged.m_183503_().m_5822_().nextFloat() > chance); chance -= 1.0) {
                player.m_150109_().m_150072_(event.getSource(), 4.0f, Inventory.f_150068_);
            }
        }
    }

    @SubscribeEvent
    public static void entityDealCrit(LivingHurtEvent event) {
        LivingEntity attacked = event.getEntityLiving();
        if (attacked.f_19853_.f_46443_) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        AttributeMap attributes = attacker.m_21204_();
        if (!attributes.m_22171_(ModAttributes.CRIT_CHANCE)) {
            return;
        }
        if (!attributes.m_22171_(ModAttributes.CRIT_MULTIPLIER)) {
            return;
        }
        double chance = attacker.m_21133_(ModAttributes.CRIT_CHANCE);
        if ((double)attacked.m_183503_().m_5822_().nextFloat() >= chance) {
            return;
        }
        float multiplier = (float)attacker.m_21133_(ModAttributes.CRIT_MULTIPLIER);
        if (AttributeSnapshotHelper.canHaveSnapshot(attacked) && multiplier > 1.0f) {
            AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(attacked);
            float mitigation = snapshot.getAttributeValue(ModGearAttributes.CRITICAL_HIT_TAKEN_REDUCTION, VaultGearAttributeTypeMerger.floatSum()).floatValue();
            float multiplierPart = multiplier - 1.0f;
            multiplierPart = Math.max(multiplierPart - multiplierPart * mitigation, 0.0f);
            multiplier = multiplierPart + 1.0f;
        }
        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new MobCritParticleMessage(new Vec3(event.getEntity().m_20185_(), event.getEntity().m_20186_() + (double)event.getEntity().m_20206_(), event.getEntity().m_20189_())));
        attacker.f_19853_.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), ModSounds.MOB_CRIT, attacker.m_5720_(), 1.2f, new Random().nextFloat() * 0.5f + 0.5f);
        event.setAmount(event.getAmount() * multiplier);
    }

    @SubscribeEvent
    public static void onLivingHurtTp(LivingHurtEvent event) {
        block8: {
            boolean direct;
            block7: {
                if (event.getEntityLiving().f_19853_.f_46443_) {
                    return;
                }
                boolean bl = direct = event.getSource().m_7640_() == event.getSource().m_7639_();
                if (!direct || !event.getEntityLiving().m_21204_().m_22171_(ModAttributes.TP_CHANCE)) break block7;
                double chance = event.getEntityLiving().m_21133_(ModAttributes.TP_CHANCE);
                if (!event.getEntityLiving().m_21204_().m_22171_(ModAttributes.TP_RANGE)) break block8;
                double range = event.getEntityLiving().m_21133_(ModAttributes.TP_RANGE);
                if (event.getEntityLiving().f_19853_.f_46441_.nextDouble() < chance) {
                    for (int i = 0; i < 64; ++i) {
                        if (!EntityEvents.teleportRandomly(event.getEntityLiving(), range)) continue;
                        event.getEntityLiving().f_19853_.m_6263_(null, event.getEntityLiving().f_19854_, event.getEntityLiving().f_19855_, event.getEntityLiving().f_19856_, ModSounds.BOSS_TP_SFX, event.getEntityLiving().m_5720_(), 1.0f, 1.0f);
                        event.setCanceled(true);
                        return;
                    }
                }
                break block8;
            }
            if (!direct && event.getEntityLiving().m_21204_().m_22171_(ModAttributes.TP_INDIRECT_CHANCE)) {
                double chance = event.getEntityLiving().m_21133_(ModAttributes.TP_INDIRECT_CHANCE);
                if (event.getEntityLiving().m_21204_().m_22171_(ModAttributes.TP_RANGE)) {
                    double range = event.getEntityLiving().m_21133_(ModAttributes.TP_RANGE);
                    if (event.getEntityLiving().f_19853_.f_46441_.nextDouble() < chance) {
                        for (int i = 0; i < 64; ++i) {
                            if (!EntityEvents.teleportRandomly(event.getEntityLiving(), range)) continue;
                            event.getEntityLiving().f_19853_.m_6263_(null, event.getEntityLiving().f_19854_, event.getEntityLiving().f_19855_, event.getEntityLiving().f_19856_, ModSounds.BOSS_TP_SFX, event.getEntityLiving().m_5720_(), 1.0f, 1.0f);
                            event.setCanceled(true);
                            return;
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void breedSnowFox(BabyEntitySpawnEvent event) {
        Mob mob = event.getParentA();
        if (mob instanceof Fox) {
            Fox foxA = (Fox)mob;
            mob = event.getParentB();
            if (mob instanceof Fox) {
                Fox foxB = (Fox)mob;
                if (foxA.m_28554_() == Fox.Type.SNOW && foxB.m_28554_() == Fox.Type.SNOW) {
                    ServerPlayer player = (ServerPlayer)event.getCausedByPlayer();
                    DiscoveredModelsData discoveredModelsData = DiscoveredModelsData.get((ServerLevel)player.f_19853_);
                    ResourceLocation modelId = ModDynamicModels.Armor.SILENTFOXXY.getId();
                    if (!discoveredModelsData.getDiscoveredModels(player.m_142081_()).contains(modelId)) {
                        MutableComponent info = new TextComponent("You have bred a snowfox!!!").m_130940_(ChatFormatting.GOLD);
                        player.m_6352_((Component)info, Util.f_137441_);
                        discoveredModelsData.discoverAllArmorPieceAndBroadcast((Player)player, ModDynamicModels.Armor.SILENTFOXXY);
                    }
                }
            }
        }
    }

    private static boolean teleportRandomly(LivingEntity entity, double range) {
        if (!entity.f_19853_.m_5776_() && entity.m_6084_()) {
            double d0 = entity.m_20185_() + (entity.f_19853_.f_46441_.nextDouble() - 0.5) * (range * 2.0);
            double d1 = entity.m_20186_() + ((double)entity.f_19853_.f_46441_.nextInt((int)(range * 2.0)) - range);
            double d2 = entity.m_20189_() + (entity.f_19853_.f_46441_.nextDouble() - 0.5) * (range * 2.0);
            return entity.m_20984_(d0, d1, d2, true);
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void thornsReflectDamage(LivingAttackEvent event) {
        Entity source;
        if (event.getSource() instanceof ThornsReflectDamageSource) {
            return;
        }
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (event.getSource() == DamageSource.f_19319_ || event.getSource() == DamageSource.f_19320_) {
                ModNetwork.CHANNEL.sendTo((Object)new ClientboundPlayerLastDamageSourceMessage(event.getSource()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
        if (!((source = event.getSource().m_7639_()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        LivingEntity attacked = event.getEntityLiving();
        if (attacked.m_21051_(ModAttributes.THORNS_CHANCE) == null || attacked.m_21051_(ModAttributes.THORNS_DAMAGE) == null) {
            return;
        }
        Random rand = attacked.m_183503_().m_5822_();
        double thornsChance = attacked.m_21051_(ModAttributes.THORNS_CHANCE).m_22135_();
        if ((double)rand.nextFloat() >= thornsChance) {
            return;
        }
        double thornsMultiplier = attacked.m_21051_(ModAttributes.THORNS_DAMAGE).m_22135_();
        if (thornsMultiplier <= 0.0) {
            return;
        }
        float dmg = (float)attacked.m_21051_(Attributes.f_22281_).m_22135_();
        ThornsReflectDamageSource src = ThornsReflectDamageSource.of((Entity)event.getEntityLiving());
        attacker.m_6469_((DamageSource)src, (float)((double)dmg * thornsMultiplier));
        event.getEntityLiving().f_19853_.m_5594_(null, event.getEntityLiving().m_20097_(), SoundEvents.f_12511_, SoundSource.BLOCKS, 1.0f, (rand.nextFloat() - rand.nextFloat()) * 0.2f + 1.0f);
    }

    @SubscribeEvent
    public static void onEntityDestroy(LivingDestroyBlockEvent event) {
        if (event.getState().m_60734_() instanceof TreasureDoorBlock) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        ResourceLocation id = event.getEntityLiving().m_6095_().getRegistryName();
        if (id != null && id.m_135827_().equals("rottencreatures")) {
            event.setResult(Event.Result.DENY);
        }
    }
}

