/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import iskallia.vault.VaultMod;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.EntityChainAttackedEvent;
import iskallia.vault.core.event.common.EntityDamageBlockEvent;
import iskallia.vault.core.event.common.EntityStunnedEvent;
import iskallia.vault.entity.entity.EffectCloudEntity;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.event.ActiveFlagsCheck;
import iskallia.vault.event.PlayerActiveFlags;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ChainingParticleMessage;
import iskallia.vault.network.message.ShockedParticleMessage;
import iskallia.vault.network.message.StunnedParticleMessage;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.talent.type.JavelinConductTalent;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.Entropy;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.util.calc.BlockChanceHelper;
import iskallia.vault.util.calc.ChainHelper;
import iskallia.vault.util.calc.FatalStrikeHelper;
import iskallia.vault.util.calc.GrantedEffectHelper;
import iskallia.vault.util.calc.ThornsHelper;
import iskallia.vault.util.damage.AttackScaleHelper;
import iskallia.vault.util.damage.CritHelper;
import iskallia.vault.util.damage.ThornsReflectDamageSource;
import iskallia.vault.world.data.PlayerTalentsData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class GearAttributeEvents {
    private static final Random rand = new Random();

    @SubscribeEvent
    public static void fireImmunePreventFireDamage(LivingAttackEvent event) {
        if (!event.getSource().m_19384_()) {
            return;
        }
        GearAttributeEvents.withSnapshot((LivingEvent)event, false, (LivingEntity entity, AttributeSnapshot snapshot) -> {
            if (snapshot.getAttributeValue(ModGearAttributes.IS_FIRE_IMMUNE, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void triggerAoEAttack(LivingHurtEvent event) {
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        if (attacker.m_183503_().m_5776_() || !AttributeSnapshotHelper.canHaveSnapshot(attacker)) {
            return;
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            boolean hasConduct = false;
            if (ActiveFlags.IS_JAVELIN_ATTACKING.isSet()) {
                if (attacker instanceof ServerPlayer) {
                    ServerPlayer sPlayer = (ServerPlayer)attacker;
                    TalentTree talents = PlayerTalentsData.get(sPlayer.m_183503_()).getTalents((Player)sPlayer);
                    for (JavelinConductTalent talent : talents.getAll(JavelinConductTalent.class, Skill::isUnlocked)) {
                        hasConduct = true;
                    }
                }
                if (!hasConduct) {
                    return;
                }
            }
            if (!hasConduct) {
                if (CritHelper.getCrit(player)) {
                    return;
                }
                if (PlayerActiveFlags.isSet(player, PlayerActiveFlags.Flag.ATTACK_AOE)) {
                    return;
                }
                if (AttackScaleHelper.getLastAttackScale(player) < 1.0f) {
                    return;
                }
            }
        }
        LivingEntity attacked = event.getEntityLiving();
        Level world = attacker.m_183503_();
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(attacker);
        int aoeSize = snapshot.getAttributeValue(ModGearAttributes.ON_HIT_AOE, VaultGearAttributeTypeMerger.intSum());
        if (aoeSize <= 0) {
            return;
        }
        ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> {
            List<Mob> nearby = EntityHelper.getNearby((LevelAccessor)world, (Vec3i)attacked.m_142538_(), aoeSize, Mob.class);
            nearby.remove(attacked);
            nearby.remove(attacker);
            nearby.removeIf(mob -> (attacker instanceof EternalEntity || attacker instanceof Player) && mob instanceof EternalEntity);
            nearby.forEach(mob -> {
                Vec3 movement = mob.m_20184_();
                mob.m_6469_(event.getSource(), event.getAmount() * 0.6f);
                mob.m_20256_(movement);
            });
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                PlayerActiveFlags.set(player, PlayerActiveFlags.Flag.ATTACK_AOE, 2);
            }
        });
    }

    @SubscribeEvent
    public static void triggerChainAttack(LivingHurtEvent event) {
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        if (attacker.m_183503_().m_5776_() || !AttributeSnapshotHelper.canHaveSnapshot(attacker)) {
            return;
        }
        if (ActiveFlags.IS_AOE_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_SMITE_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_THORNS_REFLECTING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_EFFECT_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_DOT_ATTACKING.isSet()) {
            return;
        }
        boolean hasConduct = false;
        if (ActiveFlags.IS_JAVELIN_ATTACKING.isSet()) {
            if (attacker instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)attacker;
                TalentTree talents = PlayerTalentsData.get(sPlayer.m_183503_()).getTalents((Player)sPlayer);
                for (JavelinConductTalent talent : talents.getAll(JavelinConductTalent.class, Skill::isUnlocked)) {
                    hasConduct = true;
                }
            }
            if (!hasConduct) {
                return;
            }
        }
        if (!hasConduct && attacker instanceof Player) {
            Player player = (Player)attacker;
            if (ActiveFlagsCheck.checkIfFullSwingAttack()) {
                if (CritHelper.getCrit(player)) {
                    return;
                }
                if (AttackScaleHelper.getLastAttackScale(player) < 1.0f) {
                    return;
                }
            }
            if (PlayerActiveFlags.isSet(player, PlayerActiveFlags.Flag.CHAINING_AOE)) {
                return;
            }
        }
        LivingEntity attacked = event.getEntityLiving();
        Level world = attacker.m_183503_();
        int chainCount = ChainHelper.getChainCount(attacker);
        if (chainCount <= 0) {
            return;
        }
        float chainRange = AreaOfEffectHelper.adjustAreaOfEffect(attacker, 5.0f);
        ActiveFlags.IS_CHAINING_ATTACKING.runIfNotSet(() -> {
            List<Mob> nearby = EntityHelper.getNearby((LevelAccessor)world, (Vec3i)attacked.m_142538_(), chainRange, Mob.class);
            ArrayList<Vec3> nearbyPos = new ArrayList<Vec3>();
            nearby.remove(attacked);
            nearby.remove(attacker);
            nearby.removeIf(mob -> (attacker instanceof EternalEntity || attacker instanceof Player) && mob instanceof EternalEntity);
            if (!nearby.isEmpty()) {
                nearby.sort(Comparator.comparing(e -> Float.valueOf(e.m_20270_((Entity)attacked))));
                nearby = nearby.subList(0, Math.min(chainCount, nearby.size()));
                float multiplier = 0.5f;
                nearbyPos.add(attacked.m_20182_().m_82520_(0.0, (double)(attacked.m_20206_() / 3.0f), 0.0));
                for (Mob mob2 : nearby) {
                    Vec3 movement = mob2.m_20184_();
                    nearbyPos.add(mob2.m_20182_().m_82520_(0.0, (double)(mob2.m_20206_() / 3.0f), 0.0));
                    mob2.m_6469_(event.getSource(), event.getAmount() * multiplier);
                    mob2.m_20256_(movement);
                    multiplier *= 0.5f;
                }
                CommonEvents.ENTITY_CHAIN_ATTACKED.invoke(new EntityChainAttackedEvent.Data(attacker, nearby));
            }
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ChainingParticleMessage(nearbyPos));
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                PlayerActiveFlags.set(player, PlayerActiveFlags.Flag.CHAINING_AOE, 2);
            }
        });
    }

    @SubscribeEvent
    public static void triggerKnockbackAttack(LivingHurtEvent event) {
        AttributeSnapshot snapshot;
        float knockbackChance;
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        boolean hasConduct = false;
        if (ActiveFlags.IS_JAVELIN_ATTACKING.isSet()) {
            if (attacker instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)attacker;
                TalentTree talents = PlayerTalentsData.get(sPlayer.m_183503_()).getTalents((Player)sPlayer);
                for (JavelinConductTalent talent : talents.getAll(JavelinConductTalent.class, Skill::isUnlocked)) {
                    hasConduct = true;
                }
            }
            if (!hasConduct) {
                return;
            }
        }
        if (attacker.m_183503_().m_5776_() || !AttributeSnapshotHelper.canHaveSnapshot(attacker)) {
            return;
        }
        if (!hasConduct && attacker instanceof Player) {
            Player player = (Player)attacker;
            if (ActiveFlagsCheck.checkIfFullSwingAttack()) {
                if (CritHelper.getCrit(player)) {
                    return;
                }
                if (AttackScaleHelper.getLastAttackScale(player) < 1.0f) {
                    return;
                }
            }
            if (PlayerActiveFlags.isSet(player, PlayerActiveFlags.Flag.ATTACK_AOE)) {
                return;
            }
            if (ActiveFlags.IS_TOTEM_ATTACKING.isSet() || ActiveFlags.IS_CHARMED_ATTACKING.isSet() || ActiveFlags.IS_EFFECT_ATTACKING.isSet()) {
                return;
            }
        }
        if (!Entropy.canExecute((Entity)attacker, Entropy.Stat.KNOCKBACK_ATTACK_CHANCE, knockbackChance = (snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(attacker)).getAttributeValue(ModGearAttributes.SHOCKING_HIT_CHANCE, VaultGearAttributeTypeMerger.floatSum()).floatValue())) {
            return;
        }
        Level world = attacker.m_183503_();
        LivingEntity attacked = event.getEntityLiving();
        ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> {
            List<Mob> nearby = EntityHelper.getNearby((LevelAccessor)world, (Vec3i)attacked.m_142538_(), 5.0f, Mob.class);
            nearby.remove(attacker);
            nearby.removeIf(mob -> (attacker instanceof EternalEntity || attacker instanceof Player) && mob instanceof EternalEntity);
            nearby.forEach(mob -> {
                EntityHelper.knockbackIgnoreResist((LivingEntity)mob, attacker, 1.0f);
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ShockedParticleMessage(new Vec3(mob.m_20182_().f_82479_, mob.m_20182_().f_82480_ + (double)(mob.m_20206_() / 2.0f), mob.m_20182_().f_82481_), new Vec3((double)(mob.m_20205_() / 2.0f), (double)(mob.m_20206_() / 2.0f), (double)(mob.m_20205_() / 2.0f)), mob.m_142049_()));
            });
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                PlayerActiveFlags.set(player, PlayerActiveFlags.Flag.ATTACK_AOE, 2);
            }
        });
    }

    @SubscribeEvent
    public static void triggerStunAttack(LivingHurtEvent event) {
        AttributeSnapshot snapshot;
        float stunChance;
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        if (attacker.m_183503_().m_5776_() || !AttributeSnapshotHelper.canHaveSnapshot(attacker)) {
            return;
        }
        if (ActiveFlags.IS_AOE_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_SMITE_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_THORNS_REFLECTING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_EFFECT_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_DOT_ATTACKING.isSet()) {
            return;
        }
        boolean hasConduct = false;
        if (ActiveFlags.IS_JAVELIN_ATTACKING.isSet()) {
            if (attacker instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)attacker;
                TalentTree talents = PlayerTalentsData.get(sPlayer.m_183503_()).getTalents((Player)sPlayer);
                for (JavelinConductTalent talent : talents.getAll(JavelinConductTalent.class, Skill::isUnlocked)) {
                    hasConduct = true;
                }
            }
            if (!hasConduct) {
                return;
            }
        }
        if (!hasConduct && attacker instanceof Player) {
            Player player = (Player)attacker;
            if (ActiveFlagsCheck.checkIfFullSwingAttack()) {
                if (CritHelper.getCrit(player)) {
                    return;
                }
                if (AttackScaleHelper.getLastAttackScale(player) < 1.0f) {
                    return;
                }
            }
            if (PlayerActiveFlags.isSet(player, PlayerActiveFlags.Flag.ATTACK_AOE)) {
                return;
            }
        }
        if (!Entropy.canExecute((Entity)attacker, Entropy.Stat.STUN_ATTACK_CHANCE, stunChance = (snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(attacker)).getAttributeValue(ModGearAttributes.ON_HIT_STUN, VaultGearAttributeTypeMerger.floatSum()).floatValue())) {
            return;
        }
        LivingEntity attacked = event.getEntityLiving();
        attacked.m_7292_(new MobEffectInstance(ModEffects.NO_AI, 30, 1, false, false){

            public boolean m_19552_(LivingEntity livingEntity, Runnable p_19554_) {
                if (!livingEntity.m_21224_()) {
                    ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StunnedParticleMessage(new Vec3(livingEntity.m_20185_(), livingEntity.m_20186_() + (double)livingEntity.m_20206_(), livingEntity.m_20189_()), livingEntity.m_20205_()));
                }
                return super.m_19552_(livingEntity, p_19554_);
            }
        });
        CommonEvents.ENTITY_STUNNED.invoke(new EntityStunnedEvent.Data(attacker, attacked));
    }

    @SubscribeEvent
    public static void blockAttack(LivingAttackEvent event) {
        ItemStack shieldStack;
        LivingEntity attacked = event.getEntityLiving();
        DamageSource damageSource = event.getSource();
        if (attacked.m_183503_().m_5776_() || damageSource.m_19378_()) {
            return;
        }
        if (damageSource.m_146707_()) {
            return;
        }
        ItemStack mainHandStack = attacked.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHandStack = attacked.m_21120_(InteractionHand.OFF_HAND);
        Object object = mainHandStack.m_41720_() instanceof ShieldItem ? mainHandStack : (shieldStack = offHandStack.m_41720_() instanceof ShieldItem ? offHandStack : null);
        if (shieldStack == null) {
            return;
        }
        if (!AttributeSnapshotHelper.canHaveSnapshot(attacked)) {
            return;
        }
        float blockChance = BlockChanceHelper.getBlockChance(attacked);
        if (!Entropy.canExecute((Entity)attacked, Entropy.Stat.BLOCK, blockChance)) {
            CommonEvents.ENTITY_DAMAGE_BLOCK.invoke(new EntityDamageBlockEvent.Data(true, damageSource, attacked));
            return;
        }
        event.setCanceled(true);
        CommonEvents.ENTITY_DAMAGE_BLOCK.invoke(new EntityDamageBlockEvent.Data(false, damageSource, attacked));
        if (shieldStack.m_41720_() instanceof VaultGearItem) {
            VaultGearData gearData = VaultGearData.read(shieldStack);
            gearData.getFirstValue(ModGearAttributes.GEAR_MODEL).flatMap(ModDynamicModels.Shields.REGISTRY::get).ifPresent(shieldModel -> shieldModel.onBlocked(attacked, damageSource));
        }
        attacked.m_183503_().m_7605_((Entity)attacked, (byte)29);
        if (attacked instanceof Player) {
            Player player = (Player)attacked;
            BlockChanceHelper.setPlayerBlocking(player);
        }
    }

    @SubscribeEvent
    public static void increaseDamageDealt(LivingHurtEvent event) {
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        if (attacker.m_183503_().m_5776_() || !AttributeSnapshotHelper.canHaveSnapshot(attacker)) {
            return;
        }
        LivingEntity attacked = event.getEntityLiving();
        MobType type = attacked.m_6336_();
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(attacker);
        float increasedDamage = 0.0f;
        if (!ActiveFlags.IS_AP_ATTACKING.isSet()) {
            increasedDamage += snapshot.getAttributeValue(ModGearAttributes.DAMAGE_INCREASE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        }
        if (type == MobType.f_21641_) {
            increasedDamage += snapshot.getAttributeValue(ModGearAttributes.DAMAGE_UNDEAD, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        } else if (type == MobType.f_21642_) {
            increasedDamage += snapshot.getAttributeValue(ModGearAttributes.DAMAGE_SPIDERS, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        } else if (type == MobType.f_21643_) {
            increasedDamage += snapshot.getAttributeValue(ModGearAttributes.DAMAGE_ILLAGERS, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id("mob_type/nether"), (Entity)attacked)) {
            increasedDamage += snapshot.getAttributeValue(ModGearAttributes.DAMAGE_NETHER, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id("mob_type/champion"), (Entity)attacked)) {
            increasedDamage += snapshot.getAttributeValue(ModGearAttributes.DAMAGE_CHAMPION, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id("mob_type/dungeon"), (Entity)attacked)) {
            increasedDamage += snapshot.getAttributeValue(ModGearAttributes.DAMAGE_DUNGEON, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id("mob_type/tank"), (Entity)attacked)) {
            increasedDamage += snapshot.getAttributeValue(ModGearAttributes.DAMAGE_TANK, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id("mob_type/horde"), (Entity)attacked)) {
            increasedDamage += snapshot.getAttributeValue(ModGearAttributes.DAMAGE_HORDE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id("mob_type/assassin"), (Entity)attacked)) {
            increasedDamage += snapshot.getAttributeValue(ModGearAttributes.DAMAGE_ASSASSIN, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id("mob_type/dweller"), (Entity)attacked)) {
            increasedDamage += snapshot.getAttributeValue(ModGearAttributes.DAMAGE_DWELLER, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        }
        event.setAmount(event.getAmount() * (1.0f + increasedDamage));
    }

    @SubscribeEvent
    public static void triggerEffectCloudsActive(LivingHurtEvent event) {
        boolean doEffectClouds;
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        if (attacker.m_183503_().m_5776_() || !AttributeSnapshotHelper.canHaveSnapshot(attacker)) {
            return;
        }
        boolean hasConduct = false;
        if (ActiveFlags.IS_JAVELIN_ATTACKING.isSet()) {
            if (attacker instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)attacker;
                TalentTree talents = PlayerTalentsData.get(sPlayer.m_183503_()).getTalents((Player)sPlayer);
                for (JavelinConductTalent talent : talents.getAll(JavelinConductTalent.class, Skill::isUnlocked)) {
                    hasConduct = true;
                }
            }
            if (!hasConduct) {
                return;
            }
        }
        if (!hasConduct && !ActiveFlags.IS_SMITE_BASE_ATTACKING.isSet()) {
            Player player;
            if (attacker instanceof Player && AttackScaleHelper.getLastAttackScale(player = (Player)attacker) < 1.0f) {
                return;
            }
            if (attacker instanceof Player && CritHelper.getCrit(player = (Player)attacker)) {
                return;
            }
        }
        boolean bl = doEffectClouds = (!ActiveFlags.IS_AOE_ATTACKING.isSet() || ActiveFlags.IS_CHAINING_ATTACKING.isSet()) && !ActiveFlags.IS_DOT_ATTACKING.isSet() && !ActiveFlags.IS_GLACIAL_SHATTER_ATTACKING.isSet() && !ActiveFlags.IS_REFLECT_ATTACKING.isSet() && !ActiveFlags.IS_SMITE_ATTACKING.isSet() && !ActiveFlags.IS_THORNS_REFLECTING.isSet();
        if (doEffectClouds) {
            LivingEntity attacked = event.getEntityLiving();
            AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(attacker);
            snapshot.getAttributeValue(ModGearAttributes.EFFECT_CLOUD, VaultGearAttributeTypeMerger.asList()).forEach(cloud -> {
                MobEffect effect = cloud.getPrimaryEffect();
                if (effect == null) {
                    return;
                }
                if (!Entropy.canExecute((Entity)attacker, Entropy.Stat.effectCloud(effect), cloud.getTriggerChance())) {
                    return;
                }
                EffectCloudEntity cloudEntity = new EffectCloudEntity(attacker.m_183503_(), attacked.m_20185_(), attacked.m_20186_(), attacked.m_20189_());
                cloud.apply(cloudEntity);
                cloudEntity.setRadius(AreaOfEffectHelper.adjustAreaOfEffect(attacker, cloudEntity.getRadius()));
                cloudEntity.setOwner(attacker);
                attacker.m_183503_().m_7967_((Entity)cloudEntity);
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void triggerEffectCloudsPassive(LivingHurtEvent event) {
        Player player;
        boolean doEffectClouds;
        boolean bl = doEffectClouds = !ActiveFlags.IS_AOE_ATTACKING.isSet() && !ActiveFlags.IS_DOT_ATTACKING.isSet() && !ActiveFlags.IS_REFLECT_ATTACKING.isSet();
        if (!doEffectClouds) {
            return;
        }
        if (event.getSource().m_7639_() == null) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && CritHelper.getCrit(player = (Player)entity)) {
            return;
        }
        GearAttributeEvents.withSnapshot((LivingEvent)event, true, (LivingEntity attacked, AttributeSnapshot snapshot) -> snapshot.getAttributeValue(ModGearAttributes.EFFECT_CLOUD_WHEN_HIT, VaultGearAttributeTypeMerger.asList()).forEach(cloud -> {
            MobEffect effect = cloud.getPrimaryEffect();
            if (effect == null) {
                return;
            }
            if (!Entropy.canExecute((Entity)attacked, Entropy.Stat.effectCloudWhenHit(effect), cloud.getTriggerChance())) {
                return;
            }
            EffectCloudEntity cloudEntity = new EffectCloudEntity(attacked.m_183503_(), attacked.m_20185_(), attacked.m_20186_(), attacked.m_20189_());
            cloud.apply(cloudEntity);
            cloudEntity.setRadius(AreaOfEffectHelper.adjustAreaOfEffect(attacked, cloudEntity.getRadius()));
            cloudEntity.setOwner((LivingEntity)attacked);
            attacked.m_183503_().m_7967_((Entity)cloudEntity);
        }));
    }

    @SubscribeEvent
    public static void removeImmuneEffects(LivingEvent.LivingUpdateEvent event) {
        GearAttributeEvents.withSnapshot((LivingEvent)event, true, (LivingEntity entity, AttributeSnapshot snapshot) -> GrantedEffectHelper.getImmunities(entity).forEach(arg_0 -> ((LivingEntity)entity).m_21195_(arg_0)));
    }

    @SubscribeEvent
    public static void avoidPotionEffect(PotionEvent.PotionApplicableEvent event) {
        GearAttributeEvents.withSnapshot((LivingEvent)event, true, (LivingEntity entity, AttributeSnapshot snapshot) -> {
            if (GrantedEffectHelper.canAvoidEffect(event.getPotionEffect().m_19544_(), entity, rand)) {
                event.setResult(Event.Result.DENY);
            }
        });
    }

    @SubscribeEvent
    public static void forceVanillaCrit(CriticalHitEvent event) {
        GearAttributeEvents.withSnapshot((LivingEvent)event, true, (LivingEntity entity, AttributeSnapshot snapshot) -> {
            float criticalChance = snapshot.getAttributeValue(ModGearAttributes.VANILLA_CRITICAL_HIT_CHANCE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
            if (Entropy.canExecute((Entity)entity, Entropy.Stat.VANILLA_CRITICAL, criticalChance)) {
                if (event.getDamageModifier() < 1.5f) {
                    event.setDamageModifier(1.5f);
                }
                event.setResult(Event.Result.ALLOW);
            }
        });
    }

    @SubscribeEvent
    public static void doFatalStrikeAttack(LivingHurtEvent event) {
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        if (source.m_183503_().m_5776_()) {
            return;
        }
        float fatalStrikeChance = FatalStrikeHelper.getFatalStrikeChance(attacker);
        if (Entropy.canExecute((Entity)attacker, Entropy.Stat.FATAL_STRIKE, fatalStrikeChance)) {
            float fatalPercentDamage = FatalStrikeHelper.getFatalStrikeDamage(attacker);
            float damage = event.getAmount() * (1.0f + fatalPercentDamage);
            event.setAmount(damage);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void thornsReflectDamage(LivingAttackEvent event) {
        if (event.getSource() instanceof ThornsReflectDamageSource || ActiveFlags.IS_THORNS_REFLECTING.isSet()) {
            return;
        }
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        GearAttributeEvents.withSnapshot((LivingEvent)event, true, (LivingEntity attacked, AttributeSnapshot snapshot) -> {
            float additionalThornsDamage;
            ActiveFlags.IS_THORNS_REFLECTING.push();
            float reflectedDamage = 0.0f;
            ThornsReflectDamageSource src = ThornsReflectDamageSource.of((Entity)attacked);
            float dmg = (float)attacked.m_21133_(Attributes.f_22281_);
            float thornsMultiplier = ThornsHelper.getThornsDamageMultiplier(attacked);
            if (thornsMultiplier > 0.0f) {
                reflectedDamage += dmg * thornsMultiplier;
            }
            if ((reflectedDamage += (additionalThornsDamage = ThornsHelper.getAdditionalThornsFlatDamage(attacked))) > 0.0f) {
                attacker.m_6469_((DamageSource)src, reflectedDamage);
            }
        });
    }

    private static void withSnapshot(LivingEvent event, boolean serverOnly, BiConsumer<LivingEntity, AttributeSnapshot> fn) {
        GearAttributeEvents.withSnapshot(event.getEntityLiving(), serverOnly, fn);
    }

    private static void withSnapshot(LivingEntity entity, boolean serverOnly, BiConsumer<LivingEntity, AttributeSnapshot> fn) {
        if (!AttributeSnapshotHelper.canHaveSnapshot(entity)) {
            return;
        }
        if (serverOnly && entity.m_20193_().m_5776_()) {
            return;
        }
        fn.accept(entity, AttributeSnapshotHelper.getInstance().getSnapshot(entity));
    }

    static {
        CommonEvents.ENTITY_TICK.register(GearAttributeEvents.class, event -> {
            if (ActiveFlags.IS_THORNS_REFLECTING.isSet()) {
                ActiveFlags.IS_THORNS_REFLECTING.pop();
            }
        });
    }
}

