/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.client.ClientAbilityData;
import iskallia.vault.client.gui.screen.AbilitySelectionScreen;
import iskallia.vault.client.gui.screen.bestiary.BestiaryScreen;
import iskallia.vault.client.gui.screen.quest.QuestOverviewElementScreen;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.init.ModKeybinds;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.AbilityQuickselectMessage;
import iskallia.vault.network.message.AngelToggleMessage;
import iskallia.vault.network.message.ServerboundAbilityKeyMessage;
import iskallia.vault.network.message.ServerboundMagnetToggleMessage;
import iskallia.vault.network.message.ServerboundOpenStatisticsMessage;
import iskallia.vault.network.message.ServerboundPickaxeOffsetKeyMessage;
import iskallia.vault.network.message.ToolMessage;
import iskallia.vault.network.message.bounty.ServerboundBountyProgressMessage;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.HoldAbility;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class InputEvents {
    private static boolean isShiftDown;
    private static boolean scrollingAbilities;
    private static final Set<InputConstants.Key> KEY_DOWN_SET;

    public static boolean isShiftDown() {
        return isShiftDown;
    }

    @SubscribeEvent
    public static void onShiftKey(InputEvent.KeyInputEvent event) {
        InputConstants.Key shiftKey = Minecraft.m_91087_().f_91066_.f_92090_.getKey();
        if (event.getKey() == shiftKey.m_84873_()) {
            if (event.getAction() == 1) {
                isShiftDown = true;
            } else if (event.getAction() == 0) {
                isShiftDown = false;
            }
        }
    }

    @SubscribeEvent
    public static void onKey(InputEvent.KeyInputEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            return;
        }
        InputEvents.onInput(minecraft, InputConstants.m_84827_((int)event.getKey(), (int)event.getScanCode()), event.getAction());
    }

    @SubscribeEvent
    public static void onMouse(InputEvent.MouseInputEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            return;
        }
        InputEvents.onInput(minecraft, InputConstants.Type.MOUSE.m_84895_(event.getButton()), event.getAction());
    }

    private static void onInput(Minecraft minecraft, InputConstants.Key key, int action) {
        if (key == InputConstants.f_84822_) {
            return;
        }
        if (action == 1) {
            KEY_DOWN_SET.add(key);
        } else if (action == 0) {
            KEY_DOWN_SET.remove(key);
        }
        if (minecraft.f_91080_ != null) {
            if (action == 0) {
                InputEvents.checkAndReleaseHoldAbility(key);
                scrollingAbilities = false;
            }
            return;
        }
        if (action == 0) {
            if (InputEvents.isKeyDown(ModKeybinds.abilityKey.getKey()) && ModKeybinds.abilityKey.getKeyModifier().matches(key) || ModKeybinds.abilityKey.getKey().equals((Object)key)) {
                if (!scrollingAbilities) {
                    ServerboundAbilityKeyMessage.send(ServerboundAbilityKeyMessage.Opcode.KeyUp);
                } else {
                    scrollingAbilities = false;
                }
                return;
            }
            for (Map.Entry<String, KeyMapping> entry : ModKeybinds.abilityQuickfireKey.entrySet()) {
                KeyMapping keyMapping = entry.getValue();
                if ((!InputEvents.isKeyDown(keyMapping.getKey()) || !keyMapping.getKeyModifier().matches(key)) && !keyMapping.getKey().equals((Object)key)) continue;
                ModNetwork.CHANNEL.sendToServer((Object)new AbilityQuickselectMessage(entry.getKey(), 0));
                return;
            }
            return;
        }
        if (action != 1) {
            return;
        }
        for (Map.Entry<String, KeyMapping> entry : ModKeybinds.abilityQuickfireKey.entrySet()) {
            if (!entry.getValue().isActiveAndMatches(key)) continue;
            ModNetwork.CHANNEL.sendToServer((Object)new AbilityQuickselectMessage(entry.getKey(), 1));
            return;
        }
        if (isShiftDown && ToolMessage.Offset.isKey(key.m_84873_())) {
            ToolMessage.sendOffset(key.m_84873_());
            return;
        }
        if (isShiftDown) {
            if (key.m_84873_() == 263) {
                ServerboundPickaxeOffsetKeyMessage.send(ServerboundPickaxeOffsetKeyMessage.Opcode.LEFT);
                return;
            }
            if (key.m_84873_() == 262) {
                ServerboundPickaxeOffsetKeyMessage.send(ServerboundPickaxeOffsetKeyMessage.Opcode.RIGHT);
                return;
            }
            if (key.m_84873_() == 265) {
                ServerboundPickaxeOffsetKeyMessage.send(ServerboundPickaxeOffsetKeyMessage.Opcode.UP);
                return;
            }
            if (key.m_84873_() == 264) {
                ServerboundPickaxeOffsetKeyMessage.send(ServerboundPickaxeOffsetKeyMessage.Opcode.DOWN);
                return;
            }
        }
        if (ModKeybinds.abilityKey.isActiveAndMatches(key)) {
            ServerboundAbilityKeyMessage.send(ServerboundAbilityKeyMessage.Opcode.KeyDown);
        } else if (ModKeybinds.abilityWheelKey.isActiveAndMatches(key)) {
            minecraft.m_91152_((Screen)new AbilitySelectionScreen());
            ServerboundAbilityKeyMessage.send(ServerboundAbilityKeyMessage.Opcode.CancelKeyDown);
        } else if (ModKeybinds.openAbilityTree.isActiveAndMatches(key)) {
            ModNetwork.CHANNEL.sendToServer((Object)ServerboundOpenStatisticsMessage.INSTANCE);
        } else if (ModKeybinds.bountyStatusKey.isActiveAndMatches(key)) {
            ModNetwork.CHANNEL.sendToServer((Object)ServerboundBountyProgressMessage.INSTANCE);
        } else if (ModKeybinds.angelToggleKey.isActiveAndMatches(key)) {
            ModNetwork.CHANNEL.sendToServer((Object)AngelToggleMessage.INSTANCE);
        } else if (ModKeybinds.magnetToggleKey.isActiveAndMatches(key)) {
            ModNetwork.CHANNEL.sendToServer((Object)ServerboundMagnetToggleMessage.INSTANCE);
        } else if (ModKeybinds.openQuestScreen.isActiveAndMatches(key)) {
            Minecraft.m_91087_().m_91152_((Screen)new QuestOverviewElementScreen());
        } else if (ModKeybinds.openBestiary.isActiveAndMatches(key)) {
            Minecraft.m_91087_().m_91152_((Screen)new BestiaryScreen());
        }
    }

    private static void checkAndReleaseHoldAbility(InputConstants.Key key) {
        Ability ability = ClientAbilityData.getSelectedAbility();
        if (ability instanceof HoldAbility && ability.isActive()) {
            if (ModKeybinds.abilityKey.getKeyModifier().matches(key) || ModKeybinds.abilityKey.getKey().equals((Object)key)) {
                ServerboundAbilityKeyMessage.send(ServerboundAbilityKeyMessage.Opcode.KeyUp);
            } else {
                KeyMapping keyMapping = ModKeybinds.abilityQuickfireKey.get(ability.getParent().getParent().getId());
                if (keyMapping != null && (keyMapping.getKeyModifier().matches(key) || keyMapping.getKey().equals((Object)key))) {
                    ServerboundAbilityKeyMessage.send(ServerboundAbilityKeyMessage.Opcode.KeyUp);
                }
            }
        }
    }

    private static boolean isKeyDown(InputConstants.Key key) {
        return KEY_DOWN_SET.contains(key);
    }

    @SubscribeEvent
    public static void onMouseScroll(InputEvent.MouseScrollEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            return;
        }
        IVaultOptions options = (IVaultOptions)Minecraft.m_91087_().f_91066_;
        if (!options.isAbilityScrollingEnabled()) {
            return;
        }
        double scrollDelta = event.getScrollDelta();
        if (ModKeybinds.abilityKey.m_90857_()) {
            if (minecraft.f_91080_ == null) {
                scrollingAbilities = true;
                if (scrollDelta < 0.0) {
                    ServerboundAbilityKeyMessage.send(ServerboundAbilityKeyMessage.Opcode.ScrollDown);
                } else {
                    ServerboundAbilityKeyMessage.send(ServerboundAbilityKeyMessage.Opcode.ScrollUp);
                }
            }
            event.setCanceled(true);
        }
    }

    static {
        scrollingAbilities = false;
        KEY_DOWN_SET = new HashSet<InputConstants.Key>();
    }
}

