/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ClientboundMobEffectRemoveMessage;
import iskallia.vault.network.message.ClientboundMobEffectUpdateMessage;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class MobEffectClientSyncEvent {
    @SubscribeEvent
    public static void on(PotionEvent.PotionAddedEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity.f_19853_.f_46443_) {
            return;
        }
        if (livingEntity instanceof Player) {
            return;
        }
        MobEffectInstance effectInstance = event.getPotionEffect();
        if (!ModEffects.SYNC_TO_CLIENT_ON_MOB.contains(effectInstance.m_19544_())) {
            return;
        }
        int entityId = livingEntity.m_142049_();
        ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> ((PotionEvent.PotionAddedEvent)event).getEntityLiving()), (Object)new ClientboundMobEffectUpdateMessage(entityId, effectInstance));
    }

    @SubscribeEvent
    public static void on(PotionEvent.PotionRemoveEvent event) {
        MobEffectClientSyncEvent.syncRemoveEvent(event.getEntityLiving(), event.getPotionEffect());
    }

    @SubscribeEvent
    public static void on(PotionEvent.PotionExpiryEvent event) {
        MobEffectClientSyncEvent.syncRemoveEvent(event.getEntityLiving(), event.getPotionEffect());
    }

    private static void syncRemoveEvent(LivingEntity livingEntity, MobEffectInstance effectInstance) {
        if (livingEntity.f_19853_.f_46443_) {
            return;
        }
        if (livingEntity instanceof Player) {
            return;
        }
        if (effectInstance == null || !ModEffects.SYNC_TO_CLIENT_ON_MOB.contains(effectInstance.m_19544_())) {
            return;
        }
        ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> livingEntity), (Object)new ClientboundMobEffectRemoveMessage(livingEntity.m_142049_(), effectInstance.m_19544_()));
    }

    private MobEffectClientSyncEvent() {
    }
}

