/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.fluid.block;

import iskallia.vault.block.VaultOreBlock;
import iskallia.vault.fluid.VoidFluid;
import iskallia.vault.init.ModEffects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class VoidFluidBlock
extends LiquidBlock {
    public VoidFluidBlock(Supplier<? extends VoidFluid> supplier, BlockBehaviour.Properties properties) {
        super(supplier, properties);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.m_7892_(state, world, pos, entity);
        entity.m_20095_();
        if (!world.f_46443_ && entity instanceof Player) {
            ServerPlayer player = (ServerPlayer)entity;
            VoidFluidBlock.affectPlayer(player);
        } else if (entity instanceof ItemEntity) {
            BlockItem blockItem;
            ItemStack itemStack;
            Item item;
            ItemEntity itemEntity = (ItemEntity)entity;
            if (state.m_60819_().m_76170_() && (item = (itemStack = itemEntity.m_32055_()).m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof VaultOreBlock) {
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                VoidFluidBlock.transformOre(itemEntity, (VaultOreBlock)blockItem.m_40614_());
            }
        }
    }

    public static void affectPlayer(ServerPlayer player) {
        if (!player.m_21023_(ModEffects.TIMER_ACCELERATION) || player.m_21124_(ModEffects.TIMER_ACCELERATION).m_19557_() < 40) {
            int duration = 100;
            int amplifier = 1;
            MobEffectInstance acceleration = new MobEffectInstance(ModEffects.TIMER_ACCELERATION, duration, amplifier);
            MobEffectInstance blindness = new MobEffectInstance(MobEffects.f_19610_, duration, amplifier);
            player.m_7292_(acceleration);
            player.m_7292_(blindness);
        }
    }

    public static void transformOre(ItemEntity itemEntity, VaultOreBlock oreBlock) {
        Level world = itemEntity.f_19853_;
        BlockPos pos = itemEntity.m_142538_();
        ItemStack itemStack = itemEntity.m_32055_();
        itemStack.m_41774_(1);
        if (itemStack.m_41613_() <= 0) {
            itemEntity.m_146870_();
        }
        if (!world.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12016_, SoundSource.MASTER, 1.0f, (float)Math.random());
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123771_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 100, 0.0, 0.0, 0.0, Math.PI);
        }
        ItemEntity gemEntity = VoidFluidBlock.createGemEntity(world, oreBlock, pos);
        world.m_7967_((Entity)gemEntity);
    }

    @Nonnull
    private static ItemEntity createGemEntity(Level world, VaultOreBlock oreBlock, BlockPos pos) {
        double x = (float)pos.m_123341_() + 0.5f;
        double y = (float)pos.m_123342_() + 0.5f;
        double z = (float)pos.m_123343_() + 0.5f;
        ItemStack itemStack = new ItemStack((ItemLike)oreBlock.getAssociatedGem(), 2);
        ItemEntity itemEntity = new ItemEntity(world, x, y, z, itemStack);
        itemEntity.m_32010_(40);
        float mag = world.f_46441_.nextFloat() * 0.2f;
        float angle = world.f_46441_.nextFloat() * ((float)Math.PI * 2);
        itemEntity.m_20334_((double)(-Mth.m_14031_((float)angle) * mag), (double)0.2f, (double)(Mth.m_14089_((float)angle) * mag));
        return itemEntity;
    }
}

