/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear;

import iskallia.vault.gear.VaultGearModifierHelper;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.crafting.VaultGearCraftingHelper;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.expertise.type.LegendaryExpertise;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.world.data.DiscoveredModelsData;
import iskallia.vault.world.data.PlayerExpertisesData;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GearRollHelper {
    public static final Random rand = new Random();
    private static final int ROLL_TIME = 120;
    private static final int ENTRIES_PER_ROLL = 50;

    public static void tickGearRoll(ItemStack stack) {
        VaultGearData data = VaultGearData.read(stack);
        Object item = VaultGearItem.of(stack);
        VaultGearRarity rarity = data.getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE).flatMap(rollTypeStr -> ModConfigs.VAULT_GEAR_TYPE_CONFIG.getRollPool((String)rollTypeStr)).orElse(ModConfigs.VAULT_GEAR_TYPE_CONFIG.getDefaultRoll()).getRandom(rand);
        data.setRarity(rarity);
        data.write(stack);
        ResourceLocation modelKey = item.getRandomModel(stack, rand);
        if (modelKey != null) {
            data.updateAttribute(ModGearAttributes.GEAR_MODEL, modelKey);
        }
        data.write(stack);
    }

    public static void initializeAndDiscoverGear(ItemStack stack, Player player) {
        GearRollHelper.initializeGear(stack, player);
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            DiscoveredModelsData worldData = DiscoveredModelsData.get(sPlayer.m_183503_().m_142572_());
            worldData.discoverModelAndBroadcast(stack, (Player)sPlayer);
        }
    }

    public static void initializeGear(ItemStack stack) {
        GearRollHelper.initializeGear(stack, null);
    }

    public static void initializeGear(ItemStack stack, Player player) {
        Level level;
        VaultGearData data = VaultGearData.read(stack);
        data.setState(VaultGearState.IDENTIFIED);
        data.write(stack);
        VaultGearModifierHelper.reRollRepairSlots(stack, rand);
        VaultGearCraftingHelper.reRollCraftingPotential(stack);
        VaultGearModifierHelper.generateAffixSlots(stack, rand);
        VaultGearModifierHelper.generateImplicits(stack, rand);
        VaultGearModifierHelper.generateModifiers(stack, rand);
        float extraLegendaryChance = 0.0f;
        if (player instanceof ServerPlayer && (level = player.f_19853_) instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            ExpertiseTree expertises = PlayerExpertisesData.get(sLevel).getExpertises(player);
            for (LegendaryExpertise expertise : expertises.getAll(LegendaryExpertise.class, Skill::isUnlocked)) {
                extraLegendaryChance += expertise.getExtraLegendaryChance();
            }
        }
        if (data.getFirstValue(ModGearAttributes.IS_LOOT).orElse(false).booleanValue() && rand.nextFloat() < ModConfigs.VAULT_GEAR_CRAFTING_CONFIG.getLegendaryModifierChance() + extraLegendaryChance) {
            VaultGearModifierHelper.generateLegendaryModifier(stack, rand);
        }
    }

    public static void tickToll(ItemStack stack, Player player, BiConsumer<ItemStack, Player> onRollTick, Consumer<ItemStack> onFinish) {
        Level world = player.m_183503_();
        CompoundTag rollTag = stack.m_41698_("RollHelper");
        int ticks = rollTag.m_128451_("RollTicks");
        int lastHit = rollTag.m_128451_("LastHit");
        double displacement = GearRollHelper.getDisplacement(ticks);
        if (ticks >= 120) {
            onFinish.accept(stack);
            stack.m_41749_("RollHelper");
            world.m_5594_(null, player.m_142538_(), ModSounds.IDENTIFICATION_SFX, SoundSource.PLAYERS, 0.3f, 1.0f);
            return;
        }
        if ((int)displacement != lastHit || ticks == 0) {
            onRollTick.accept(stack, player);
            rollTag.m_128405_("LastHit", (int)displacement);
            world.m_5594_(null, player.m_142538_(), ModSounds.RAFFLE_SFX, SoundSource.PLAYERS, 0.4f, 1.0f);
        }
        rollTag.m_128405_("RollTicks", ticks + 1);
    }

    private static double getDisplacement(int tick) {
        double c = 7200.0;
        return ((double)(-tick * tick * tick) / 6.0 + c * (double)tick) * 50.0 / (-288000.0 + c * 120.0);
    }
}

