/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import iskallia.vault.client.util.ClientScheduler;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.tool.ColorBlender;
import iskallia.vault.util.VHSmpUtil;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;

public class VaultGearHelper {
    public static void initializeGearRollType(ItemStack stack, ServerPlayer player) {
        VaultGearHelper.initializeGearRollType(stack, player, (RandomSource)JavaRandom.ofNanoTime());
    }

    public static void initializeGearRollType(ItemStack stack, ServerPlayer player, RandomSource random) {
        int playerLevel = PlayerVaultStatsData.get(player.m_183503_()).getVaultStats(player.m_142081_()).getVaultLevel();
        VaultGearHelper.initializeGearRollType(stack, playerLevel, random);
    }

    public static void initializeGearRollType(ItemStack stack, int gearLevel, RandomSource random) {
        VaultGearData data = VaultGearData.read(stack);
        if (data.has(ModGearAttributes.GEAR_ROLL_TYPE_POOL) && !data.has(ModGearAttributes.GEAR_ROLL_TYPE)) {
            data.getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE_POOL).ifPresent(typePool -> {
                String rollType = ModConfigs.VAULT_GEAR_TYPE_POOL_CONFIG.getGearRollType((String)typePool, gearLevel, random);
                if (rollType != null) {
                    data.updateAttribute(ModGearAttributes.GEAR_ROLL_TYPE, rollType);
                    data.write(stack);
                }
            });
        }
        if (!data.has(ModGearAttributes.GEAR_ROLL_TYPE)) {
            data.updateAttribute(ModGearAttributes.GEAR_ROLL_TYPE, ModConfigs.VAULT_GEAR_TYPE_CONFIG.getDefaultRoll().getName());
            data.write(stack);
        }
    }

    public static InteractionResultHolder<ItemStack> rightClick(Level world, Player player, InteractionHand hand, InteractionResultHolder<ItemStack> defaultUse) {
        VaultGearItem gearItem;
        Item item;
        if (world.m_5776_()) {
            return defaultUse;
        }
        if (VHSmpUtil.isArenaWorld(world)) {
            return defaultUse;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof VaultGearItem && (gearItem = (VaultGearItem)item).tryStartIdentification(player, stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return defaultUse;
    }

    public static Component getDisplayName(ItemStack stack, Component defaultName) {
        if (!ModConfigs.isInitialized()) {
            return defaultName;
        }
        GearDataCache clientCache = GearDataCache.of(stack);
        if (clientCache.getState() == VaultGearState.UNIDENTIFIED) {
            Style style = Optional.ofNullable(clientCache.getGearRollType()).flatMap(ModConfigs.VAULT_GEAR_TYPE_CONFIG::getRollPool).map(pool -> defaultName.m_7383_().m_131148_(TextColor.m_131266_((int)pool.getColor()))).orElse(defaultName.m_7383_());
            return new TextComponent("Unidentified ").m_6270_(style).m_7220_((Component)defaultName.m_6881_().m_6270_(style));
        }
        ColorBlender colorBlender = new ColorBlender(1.0f);
        Optional.ofNullable(clientCache.getGearColorComponents()).ifPresent(colors -> colors.forEach(color -> colorBlender.add((int)color, 60.0f)));
        float time = ClientScheduler.INSTANCE.getTickCount();
        int color = colorBlender.getColor(time);
        Optional<String> customName = Optional.ofNullable(clientCache.getGearName());
        return (Component)customName.map(s -> new TextComponent(s).m_6270_(Style.f_131099_.m_178520_(color))).orElseGet(() -> defaultName.m_6881_().m_6270_(defaultName.m_7383_().m_178520_(color)));
    }

    public static int getGearColor(ItemStack stack) {
        GearDataCache clientCache = GearDataCache.of(stack);
        if (clientCache.getState() == VaultGearState.UNIDENTIFIED) {
            return -1;
        }
        CompoundTag displayTag = stack.m_41737_("display");
        if (displayTag != null && displayTag.m_128425_("color", 3)) {
            return displayTag.m_128451_("color");
        }
        return clientCache.getGearColor(-1);
    }

    public static boolean shouldPlayGearReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged || !ItemStack.m_41746_((ItemStack)oldStack, (ItemStack)newStack)) {
            return true;
        }
        return AttributeGearData.readUUID(oldStack).map(oldUuid -> AttributeGearData.readUUID(newStack).map(newUuid -> !oldUuid.equals(newUuid)).orElse(true)).orElse(true);
    }

    public static Multimap<Attribute, AttributeModifier> getModifiers(ItemStack stack, EquipmentSlot slot) {
        Object gearItem = VaultGearItem.of(stack);
        if (!gearItem.isIntendedForSlot(stack, slot)) {
            return ImmutableMultimap.of();
        }
        if (gearItem.isBroken(stack)) {
            return ImmutableMultimap.of();
        }
        return VaultGearHelper.getModifiers(VaultGearData.read(stack));
    }

    public static Multimap<Attribute, AttributeModifier> getModifiers(UUID uuid, Stream<VaultGearAttributeInstance<?>> instances) {
        AttributeGearData data = AttributeGearData.empty();
        data.setIdentifier(uuid);
        instances.forEach(instance -> data.updateAttribute(instance.getAttribute(), instance.getValue()));
        return VaultGearHelper.getModifiers(data);
    }

    public static Multimap<Attribute, AttributeModifier> getModifiers(AttributeGearData data) {
        double attackSpeed;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID identifier = data.getIdentifier();
        if (data.has(ModGearAttributes.ATTACK_DAMAGE)) {
            double attackDamage = data.get(ModGearAttributes.ATTACK_DAMAGE, VaultGearAttributeTypeMerger.doubleSum());
            VaultGearHelper.addAttribute((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, Attributes.f_22281_, attackDamage, identifier);
        }
        if (data.has(ModGearAttributes.ATTACK_SPEED)) {
            attackSpeed = data.get(ModGearAttributes.ATTACK_SPEED, VaultGearAttributeTypeMerger.doubleSum());
            VaultGearHelper.addAttribute((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, Attributes.f_22283_, attackSpeed, identifier);
        }
        if (data.has(ModGearAttributes.ATTACK_SPEED_PERCENT)) {
            attackSpeed = data.get(ModGearAttributes.ATTACK_SPEED_PERCENT, VaultGearAttributeTypeMerger.doubleSum());
            VaultGearHelper.addAttribute((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, Attributes.f_22283_, attackSpeed, identifier, AttributeModifier.Operation.MULTIPLY_BASE);
        }
        if (data.has(ModGearAttributes.ARMOR)) {
            double armor = data.get(ModGearAttributes.ARMOR, VaultGearAttributeTypeMerger.intSum()).intValue();
            VaultGearHelper.addAttribute((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, Attributes.f_22284_, armor, identifier);
        }
        if (data.has(ModGearAttributes.ARMOR_TOUGHNESS)) {
            double armorToughness = data.get(ModGearAttributes.ARMOR_TOUGHNESS, VaultGearAttributeTypeMerger.intSum()).intValue();
            VaultGearHelper.addAttribute((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, Attributes.f_22285_, armorToughness, identifier);
        }
        if (data.has(ModGearAttributes.KNOCKBACK_RESISTANCE)) {
            float knockbackResistance = data.get(ModGearAttributes.KNOCKBACK_RESISTANCE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
            VaultGearHelper.addAttribute((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, Attributes.f_22278_, knockbackResistance, identifier);
        }
        if (data.has(ModGearAttributes.HEALTH)) {
            float health = data.get(ModGearAttributes.HEALTH, VaultGearAttributeTypeMerger.floatSum()).floatValue();
            VaultGearHelper.addAttribute((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, Attributes.f_22276_, health, identifier);
        }
        if (data.has(ModGearAttributes.REACH)) {
            double reach = data.get(ModGearAttributes.REACH, VaultGearAttributeTypeMerger.doubleSum());
            VaultGearHelper.addAttribute((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, (Attribute)ForgeMod.REACH_DISTANCE.get(), reach, identifier);
        }
        if (data.has(ModGearAttributes.ATTACK_RANGE)) {
            double reach = data.get(ModGearAttributes.ATTACK_RANGE, VaultGearAttributeTypeMerger.doubleSum());
            VaultGearHelper.addAttribute((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, (Attribute)ForgeMod.ATTACK_RANGE.get(), reach, identifier);
        }
        if (data.has(ModGearAttributes.MANA_REGEN_ADDITIVE_PERCENTILE)) {
            float manaRegen = data.get(ModGearAttributes.MANA_REGEN_ADDITIVE_PERCENTILE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
            VaultGearHelper.addAttribute((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, ModAttributes.MANA_REGEN, manaRegen, identifier, AttributeModifier.Operation.MULTIPLY_BASE);
        }
        if (data.has(ModGearAttributes.MANA_ADDITIVE)) {
            int manaFlat = data.get(ModGearAttributes.MANA_ADDITIVE, VaultGearAttributeTypeMerger.intSum());
            VaultGearHelper.addAttribute((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, ModAttributes.MANA_MAX, manaFlat, identifier);
        }
        if (data.has(ModGearAttributes.MANA_ADDITIVE_PERCENTILE)) {
            float manaPercent = data.get(ModGearAttributes.MANA_ADDITIVE_PERCENTILE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
            VaultGearHelper.addAttribute((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, ModAttributes.MANA_MAX, manaPercent, identifier, AttributeModifier.Operation.MULTIPLY_BASE);
        }
        if (data.has(ModGearAttributes.HEALING_EFFECTIVENESS)) {
            float healingPercent = data.get(ModGearAttributes.HEALING_EFFECTIVENESS, VaultGearAttributeTypeMerger.floatSum()).floatValue();
            VaultGearHelper.addAttribute((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, ModAttributes.HEALING_MAX, healingPercent, identifier, AttributeModifier.Operation.MULTIPLY_BASE);
        }
        if (data.has(ModGearAttributes.MOVEMENT_SPEED)) {
            float movementSpeed = data.get(ModGearAttributes.MOVEMENT_SPEED, VaultGearAttributeTypeMerger.floatSum()).floatValue();
            VaultGearHelper.addAttribute((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, Attributes.f_22279_, movementSpeed, identifier, AttributeModifier.Operation.MULTIPLY_BASE);
        }
        return builder.build();
    }

    private static void addAttribute(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder, Attribute attribute, double value, UUID seed) {
        VaultGearHelper.addAttribute(builder, attribute, value, seed, AttributeModifier.Operation.ADDITION);
    }

    private static void addAttribute(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder, Attribute attribute, double value, UUID seed, AttributeModifier.Operation operation) {
        builder.put((Object)attribute, (Object)new AttributeModifier(VaultGearHelper.seededId(seed, attribute, operation), "VaultGear %s".formatted(attribute.m_22087_()), value, operation));
    }

    private static UUID seededId(UUID seed, Attribute attribute, AttributeModifier.Operation operation) {
        long attrHash = VaultGearHelper.hash(attribute.getRegistryName().toString());
        return new UUID(seed.getMostSignificantBits() ^ (attrHash ^= VaultGearHelper.hash(operation.name())), seed.getLeastSignificantBits() ^ attrHash);
    }

    private static long hash(String str) {
        long hash = 1125899906842597L;
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            hash = 31L * hash + (long)str.charAt(i);
        }
        return hash;
    }
}

