/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear;

import iskallia.vault.VaultMod;
import iskallia.vault.config.gear.VaultGearTagConfig;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.gear.VaultGearClassification;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.MiscUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class VaultGearModifierHelper {
    public static void reForgeAllModifiers(ItemStack stack, Random random) {
        VaultGearModifierHelper.removeAllModifiers(stack);
        VaultGearModifierHelper.generateModifiers(stack, random);
    }

    public static void reForgeAllImplicits(ItemStack stack, Random random) {
        VaultGearModifierHelper.removeAllModifiersOfType(stack, VaultGearModifier.AffixType.IMPLICIT);
        VaultGearModifierHelper.generateImplicits(stack, random);
    }

    public static boolean reForgeAllWithTag(VaultGearTagConfig.ModTagGroup modGroupTag, ItemStack stack, Random random) {
        ItemStack emptyCopy = stack.m_41777_();
        VaultGearModifierHelper.removeAllModifiers(emptyCopy);
        if (VaultGearModifierHelper.getAvailableModGroupOutcomes(modGroupTag, emptyCopy).isEmpty()) {
            return false;
        }
        VaultGearModifierHelper.removeAllModifiers(stack);
        if (!VaultGearModifierHelper.addNewModifierOfGroup(modGroupTag, stack, random)) {
            return false;
        }
        VaultGearModifierHelper.generateModifiers(stack, random);
        return true;
    }

    public static boolean addNewModifierOfGroup(VaultGearTagConfig.ModTagGroup modGroupTag, ItemStack stack, Random random) {
        WeightedList<TierGroupOutcome> outcomes = VaultGearModifierHelper.getAvailableModGroupOutcomes(modGroupTag, stack);
        HashMap<VaultGearTierConfig.ModifierTierGroup, Integer> highestTiers = new HashMap<VaultGearTierConfig.ModifierTierGroup, Integer>();
        for (TierGroupOutcome outcome : outcomes.keySet()) {
            int current = highestTiers.getOrDefault(outcome.tierGroup, -1);
            highestTiers.put(outcome.tierGroup, Math.max(outcome.tier.getModifierTier(), current));
        }
        outcomes.entrySet().removeIf(entry -> ((TierGroupOutcome)entry.getKey()).tier.getModifierTier() != ((Integer)highestTiers.get(((TierGroupOutcome)entry.getKey()).tierGroup)).intValue());
        TierGroupOutcome outcome = outcomes.getRandom(random).orElse(null);
        if (outcome == null) {
            return false;
        }
        VaultGearData data = VaultGearData.read(stack);
        if (!data.isModifiable()) {
            return false;
        }
        data.addModifier(outcome.type(), outcome.tier().makeModifier(outcome.tierGroup(), random));
        data.write(stack);
        return true;
    }

    private static WeightedList<TierGroupOutcome> getAvailableModGroupOutcomes(VaultGearTagConfig.ModTagGroup modGroupTag, ItemStack stack) {
        boolean generateSuffixes;
        WeightedList<TierGroupOutcome> groupOutcomes = new WeightedList<TierGroupOutcome>();
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack.m_41720_()).orElse(null);
        if (cfg == null) {
            return groupOutcomes;
        }
        VaultGearData data = VaultGearData.read(stack);
        int itemLevel = data.getItemLevel();
        Set<String> existingGroups = data.getExistingModifierGroups(VaultGearData.Type.EXPLICIT_MODIFIERS);
        boolean generatePrefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0) > data.getModifiers(VaultGearModifier.AffixType.PREFIX).size();
        boolean bl = generateSuffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0) > data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size();
        if (!generatePrefixes && !generateSuffixes) {
            return groupOutcomes;
        }
        modGroupTag.getTags().forEach(tag -> cfg.getModifierConfigurationsByTag((String)tag).forEach(tpl -> {
            if (!((VaultGearTierConfig.ModifierAffixTagGroup)((Object)((Object)((Object)tpl.m_14418_())))).isGenericGroup()) {
                return;
            }
            if (existingGroups.contains(((VaultGearTierConfig.ModifierTierGroup)tpl.m_14419_()).getModifierGroup())) {
                return;
            }
            VaultGearModifier.AffixType type = ((VaultGearTierConfig.ModifierAffixTagGroup)((Object)((Object)((Object)tpl.m_14418_())))).getTargetAffixType();
            if (type == VaultGearModifier.AffixType.PREFIX && !generatePrefixes) {
                return;
            }
            if (type == VaultGearModifier.AffixType.SUFFIX && !generateSuffixes) {
                return;
            }
            ((VaultGearTierConfig.ModifierTierGroup)tpl.m_14419_()).getModifiersForLevel(itemLevel).forEach(tier -> groupOutcomes.add(new TierGroupOutcome(type, (VaultGearTierConfig.ModifierTierGroup)tpl.m_14419_(), (VaultGearTierConfig.ModifierTier<?>)tier), tier.getWeight()));
        }));
        return groupOutcomes;
    }

    public static boolean reForgeTierOfRandomModifier(ItemStack stack, long worldGameTime, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack.m_41720_()).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("Unknown VaultGear: " + stack);
            return false;
        }
        if (!data.isModifiable()) {
            return false;
        }
        int itemLevel = data.getItemLevel();
        ArrayList<Tuple> modifierReplacements = new ArrayList<Tuple>();
        data.getModifiers(VaultGearModifier.AffixType.PREFIX).forEach(modifier -> {
            if (!modifier.getCategory().isModifiableByArtisanFoci()) {
                return;
            }
            if (modifier.getCategory() == VaultGearModifier.AffixCategory.CRAFTED) {
                return;
            }
            VaultGearTierConfig.ModifierTierGroup group = cfg.getTierGroup(modifier.getModifierIdentifier());
            if (group != null) {
                WeightedList replacementTiers = new WeightedList();
                group.getModifiersForLevel(itemLevel).forEach(tier -> replacementTiers.add(new VaultGearTierConfig.ModifierOutcome(tier, group), tier.getWeight()));
                modifierReplacements.add(new Tuple(modifier, replacementTiers));
            }
        });
        data.getModifiers(VaultGearModifier.AffixType.SUFFIX).forEach(modifier -> {
            if (!modifier.getCategory().isModifiableByArtisanFoci()) {
                return;
            }
            if (modifier.getCategory() == VaultGearModifier.AffixCategory.CRAFTED) {
                return;
            }
            VaultGearTierConfig.ModifierTierGroup group = cfg.getTierGroup(modifier.getModifierIdentifier());
            if (group != null) {
                WeightedList replacementTiers = new WeightedList();
                group.getModifiersForLevel(itemLevel).forEach(tier -> replacementTiers.add(new VaultGearTierConfig.ModifierOutcome(tier, group), tier.getWeight()));
                modifierReplacements.add(new Tuple(modifier, replacementTiers));
            }
        });
        modifierReplacements.removeIf(tpl -> ((WeightedList)tpl.m_14419_()).size() <= 1);
        if (modifierReplacements.isEmpty()) {
            return false;
        }
        Tuple potentialReplacements = (Tuple)MiscUtils.getRandomEntry(modifierReplacements);
        if (potentialReplacements == null) {
            return false;
        }
        VaultGearTierConfig.ModifierOutcome replacement = ((WeightedList)potentialReplacements.m_14419_()).getRandom(random).orElse(null);
        if (replacement == null) {
            return false;
        }
        data.getAllModifierAffixes().forEach(VaultGearModifier::resetGameTimeAdded);
        VaultGearModifier existing = (VaultGearModifier)potentialReplacements.m_14418_();
        VaultGearModifier newModifier = replacement.makeModifier(random);
        VaultGearAttributeComparator comparator = existing.getAttribute().getAttributeComparator();
        if (comparator != null && comparator.compare(existing.getValue(), newModifier.getValue()) == 0) {
            return VaultGearModifierHelper.reForgeTierOfRandomModifier(stack, worldGameTime, random);
        }
        existing.setValue(newModifier.getValue());
        existing.setRolledTier(newModifier.getRolledTier());
        existing.setGameTimeAdded(worldGameTime);
        existing.setCategory(VaultGearModifier.AffixCategory.NONE);
        data.write(stack);
        return true;
    }

    public static boolean addNewModifier(ItemStack stack, long worldGameTime, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack.m_41720_()).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("Unknown VaultGear: " + stack);
            return false;
        }
        if (!data.isModifiable()) {
            return false;
        }
        int itemLevel = data.getItemLevel();
        int prefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0);
        int suffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0);
        if ((prefixes -= data.getModifiers(VaultGearModifier.AffixType.PREFIX).size()) <= 0 && (suffixes -= data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size()) <= 0) {
            return false;
        }
        ArrayList<VaultGearModifier.AffixType> types = new ArrayList<VaultGearModifier.AffixType>();
        if (prefixes > 0) {
            types.add(VaultGearModifier.AffixType.PREFIX);
        }
        if (suffixes > 0) {
            types.add(VaultGearModifier.AffixType.SUFFIX);
        }
        VaultGearModifier.AffixType type = (VaultGearModifier.AffixType)((Object)MiscUtils.getRandomEntry(types, random));
        return cfg.getRandomModifier(type, itemLevel, random, data.getExistingModifierGroups(VaultGearData.Type.EXPLICIT_MODIFIERS)).map(modifier -> {
            data.getAllModifierAffixes().forEach(VaultGearModifier::resetGameTimeAdded);
            modifier.setGameTimeAdded(worldGameTime);
            data.addModifier(type, (VaultGearModifier<?>)modifier);
            data.write(stack);
            return true;
        }).orElse(false);
    }

    public static boolean removeRandomModifier(ItemStack stack, Random random) {
        VaultGearModifier.AffixType type;
        VaultGearData data = VaultGearData.read(stack);
        if (!data.isModifiable()) {
            return false;
        }
        int prefixes = data.getModifiers(VaultGearModifier.AffixType.PREFIX).size();
        int suffixes = data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size();
        if (prefixes <= 0 && suffixes <= 0) {
            return false;
        }
        ArrayList<VaultGearModifier.AffixType> types = new ArrayList<VaultGearModifier.AffixType>();
        if (prefixes > 0) {
            types.add(VaultGearModifier.AffixType.PREFIX);
        }
        if (suffixes > 0) {
            types.add(VaultGearModifier.AffixType.SUFFIX);
        }
        if ((type = (VaultGearModifier.AffixType)((Object)MiscUtils.getRandomEntry(types, random))) == null) {
            return false;
        }
        ArrayList modifiers = new ArrayList(data.getModifiers(type));
        modifiers.removeIf(modifier -> !modifier.getCategory().isModifiableByArtisanFoci());
        if (modifiers.isEmpty()) {
            return false;
        }
        VaultGearModifier<?> randomMod = MiscUtils.getRandomEntry(modifiers, random);
        data.removeModifier(randomMod);
        data.write(stack);
        return true;
    }

    public static boolean hasAnyOpenAffix(ItemStack stack) {
        VaultGearData data = VaultGearData.read(stack);
        int prefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0);
        int suffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0);
        return (prefixes -= data.getModifiers(VaultGearModifier.AffixType.PREFIX).size()) > 0 || (suffixes -= data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size()) > 0;
    }

    public static boolean hasOpenPrefix(ItemStack stack) {
        VaultGearData data = VaultGearData.read(stack);
        int prefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0) - data.getModifiers(VaultGearModifier.AffixType.PREFIX).size();
        return prefixes > 0;
    }

    public static boolean hasOpenSuffix(ItemStack stack) {
        VaultGearData data = VaultGearData.read(stack);
        int suffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0) - data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size();
        return suffixes > 0;
    }

    public static void removeAllModifiers(ItemStack stack) {
        VaultGearModifierHelper.removeAllModifiersOfType(stack, VaultGearModifier.AffixType.PREFIX);
        VaultGearModifierHelper.removeAllModifiersOfType(stack, VaultGearModifier.AffixType.SUFFIX);
    }

    public static void removeAllModifiersOfType(ItemStack stack, VaultGearModifier.AffixType type) {
        VaultGearData data = VaultGearData.read(stack);
        if (!data.isModifiable()) {
            return;
        }
        ArrayList modifiers = new ArrayList(data.getModifiers(type));
        for (VaultGearModifier vaultGearModifier : modifiers) {
            if (!vaultGearModifier.getCategory().isModifiableByArtisanFoci()) continue;
            data.removeModifier(vaultGearModifier);
        }
        data.write(stack);
    }

    public static boolean createOrReplaceAbilityEnhancementModifier(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack.m_41720_()).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("Unknown VaultGear: " + stack);
            return false;
        }
        if (!data.isModifiable()) {
            return false;
        }
        Optional<VaultGearModifier<?>> modifierOpt = cfg.getRandomModifier(VaultGearTierConfig.ModifierAffixTagGroup.ABILITY_ENHANCEMENT, data.getItemLevel(), random, Collections.emptySet());
        if (modifierOpt.isEmpty()) {
            return false;
        }
        VaultGearModifier<?> newModifier = modifierOpt.get();
        newModifier.setCategory(VaultGearModifier.AffixCategory.ABILITY_ENHANCEMENT);
        List<VaultGearModifier<?>> implicits = data.getModifiers(VaultGearTierConfig.ModifierAffixTagGroup.ABILITY_ENHANCEMENT.getTargetAffixType());
        for (VaultGearModifier<?> modifier : new ArrayList(implicits)) {
            if (modifier.getCategory() != VaultGearModifier.AffixCategory.ABILITY_ENHANCEMENT) continue;
            data.removeModifier(modifier);
        }
        if (!data.addModifierFirst(VaultGearModifier.AffixType.IMPLICIT, newModifier)) {
            return false;
        }
        data.write(stack);
        return true;
    }

    public static boolean generateLegendaryModifier(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack.m_41720_()).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("Unknown VaultGear: " + stack);
            return false;
        }
        if (!data.isModifiable()) {
            return false;
        }
        ArrayList<Tuple> modifiers = new ArrayList<Tuple>();
        data.getModifiers(VaultGearModifier.AffixType.PREFIX).forEach(modifier -> modifiers.add(new Tuple((Object)VaultGearModifier.AffixType.PREFIX, modifier)));
        data.getModifiers(VaultGearModifier.AffixType.SUFFIX).forEach(modifier -> modifiers.add(new Tuple((Object)VaultGearModifier.AffixType.SUFFIX, modifier)));
        modifiers.removeIf(tpl -> {
            VaultGearTierConfig.ModifierTierGroup group = cfg.getTierGroup(((VaultGearModifier)tpl.m_14419_()).getModifierIdentifier());
            if (group == null) {
                return false;
            }
            return group.size() <= 1 || group.getTags().contains("noLegendary");
        });
        modifiers.removeIf(tpl -> !((VaultGearModifier)tpl.m_14419_()).getCategory().isModifiableByArtisanFoci());
        Tuple randomMod = (Tuple)MiscUtils.getRandomEntry(modifiers, random);
        if (randomMod == null) {
            return false;
        }
        VaultGearModifier<?> newMod = cfg.maxAndIncreaseTier((VaultGearModifier.AffixType)((Object)randomMod.m_14418_()), (VaultGearModifier)randomMod.m_14419_(), data.getItemLevel(), 2, random);
        if (newMod == null) {
            return false;
        }
        newMod.setCategory(VaultGearModifier.AffixCategory.LEGENDARY);
        if (data.removeModifier((VaultGearModifier)randomMod.m_14419_())) {
            data.addModifierFirst((VaultGearModifier.AffixType)((Object)randomMod.m_14418_()), newMod);
        }
        data.write(stack);
        return true;
    }

    public static void generateAffixSlots(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        VaultGearRarity rarity = data.getRarity();
        Item item = stack.m_41720_();
        if (item instanceof VaultGearItem) {
            int suffixes;
            int prefixes;
            VaultGearItem item2 = (VaultGearItem)item;
            VaultGearClassification classification = item2.getClassification(stack);
            int modifierCount = classification.getModifierCount(rarity);
            if (modifierCount - (prefixes = modifierCount / 2) - (suffixes = modifierCount / 2) > 0) {
                if (random.nextBoolean()) {
                    ++prefixes;
                } else {
                    ++suffixes;
                }
            }
            if (classification.hasOnlySuffixes()) {
                prefixes = 0;
                suffixes = classification.getModifierCount(rarity);
            }
            data.updateAttribute(ModGearAttributes.PREFIXES, prefixes);
            data.updateAttribute(ModGearAttributes.SUFFIXES, suffixes);
        }
        data.write(stack);
    }

    public static void generateImplicits(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack.m_41720_()).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("Unknown VaultGear: " + stack);
            return;
        }
        if (!data.isModifiable()) {
            return;
        }
        int itemLevel = data.getItemLevel();
        cfg.generateImplicits(itemLevel, random).forEach(modifier -> {
            if (!data.hasModifier(modifier.getModifierIdentifier())) {
                data.addModifier(VaultGearModifier.AffixType.IMPLICIT, (VaultGearModifier<?>)modifier);
            }
        });
        data.write(stack);
    }

    public static boolean reRollRepairSlots(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        if (!data.isModifiable()) {
            return false;
        }
        int repairs = 2 + random.nextInt(4);
        data.setRepairSlots(repairs);
        data.write(stack);
        return true;
    }

    public static boolean generateModifiersOfAffix(ItemStack stack, VaultGearModifier.AffixType affixType, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack.m_41720_()).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("Unknown VaultGear: " + stack);
            return false;
        }
        if (!data.isModifiable()) {
            return false;
        }
        int itemLevel = data.getItemLevel();
        int maxPrefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0);
        int maxSuffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0);
        if (affixType == VaultGearModifier.AffixType.PREFIX && maxPrefixes <= 0) {
            return false;
        }
        if (affixType == VaultGearModifier.AffixType.SUFFIX && maxSuffixes <= 0) {
            return false;
        }
        int prefixCount = data.getModifiers(VaultGearModifier.AffixType.PREFIX).size();
        int suffixCount = data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size();
        int possibleGenerated = VaultGearModifierHelper.getGeneratedModifierCount(maxPrefixes + maxSuffixes, itemLevel, random);
        int toGenerate = possibleGenerated - Math.min(prefixCount, maxPrefixes) - Math.min(suffixCount, maxSuffixes);
        toGenerate = affixType == VaultGearModifier.AffixType.PREFIX ? Math.min(toGenerate, maxPrefixes - prefixCount) : Math.min(toGenerate, maxSuffixes - suffixCount);
        for (int i = 0; i < toGenerate; ++i) {
            VaultGearModifier modifier = cfg.getRandomModifier(affixType, itemLevel, random, data.getExistingModifierGroups(VaultGearData.Type.EXPLICIT_MODIFIERS)).orElse(null);
            if (modifier == null || !data.addModifier(affixType, modifier)) continue;
            if (affixType == VaultGearModifier.AffixType.PREFIX) {
                ++prefixCount;
                continue;
            }
            ++suffixCount;
        }
        data.write(stack);
        return true;
    }

    public static void generateModifiers(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack.m_41720_()).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("Unknown VaultGear: " + stack);
            return;
        }
        if (!data.isModifiable()) {
            return;
        }
        int itemLevel = data.getItemLevel();
        int maxPrefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0) - data.getModifiers(VaultGearModifier.AffixType.PREFIX).size();
        int maxSuffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0) - data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size();
        int generatedModifiers = VaultGearModifierHelper.getGeneratedModifierCount(maxPrefixes + maxSuffixes, itemLevel, random);
        int rolledPrefixes = 0;
        int rolledSuffixes = 0;
        if (stack.m_41720_() == ModItems.JEWEL) {
            generatedModifiers = maxPrefixes + maxSuffixes;
        }
        for (int i = 0; i < generatedModifiers; ++i) {
            VaultGearModifier modifier;
            VaultGearModifier.AffixType type;
            ArrayList<VaultGearModifier.AffixType> types = new ArrayList<VaultGearModifier.AffixType>();
            if (rolledPrefixes < maxPrefixes) {
                types.add(VaultGearModifier.AffixType.PREFIX);
            }
            if (rolledSuffixes < maxSuffixes) {
                types.add(VaultGearModifier.AffixType.SUFFIX);
            }
            if ((type = (VaultGearModifier.AffixType)((Object)MiscUtils.getRandomEntry(types, random))) == null || (modifier = (VaultGearModifier)cfg.getRandomModifier(type, itemLevel, random, data.getExistingModifierGroups(VaultGearData.Type.EXPLICIT_MODIFIERS)).orElse(null)) == null || !data.addModifier(type, modifier)) continue;
            if (type == VaultGearModifier.AffixType.PREFIX) {
                ++rolledPrefixes;
                continue;
            }
            ++rolledSuffixes;
        }
        data.write(stack);
    }

    private static int getGeneratedModifierCount(int modifierCount, int itemLevel, Random random) {
        if (itemLevel <= 20) {
            return modifierCount;
        }
        return Math.round((float)modifierCount * 0.6f + (float)modifierCount * 0.4f * random.nextFloat());
    }

    public record TierGroupOutcome(VaultGearModifier.AffixType type, VaultGearTierConfig.ModifierTierGroup tierGroup, VaultGearTierConfig.ModifierTier<?> tier) {
    }
}

