/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute;

import com.google.gson.JsonObject;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.data.GearDataVersion;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.tooltip.ModifierCategoryTooltip;
import iskallia.vault.util.MiscUtils;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class VaultGearModifier<T>
extends VaultGearAttributeInstance<T> {
    private int rolledTier = -1;
    private String modifierGroup = "";
    private ResourceLocation modifierIdentifier = null;
    private long gameTimeAdded = Long.MIN_VALUE;
    private AffixCategory category = AffixCategory.NONE;

    VaultGearModifier(VaultGearAttribute<T> attribute) {
        super(attribute);
    }

    public VaultGearModifier(VaultGearAttribute<T> attribute, T value) {
        super(attribute, value);
    }

    public void setRolledTier(int rolledTier) {
        this.rolledTier = rolledTier;
    }

    public int getRolledTier() {
        return this.rolledTier;
    }

    public void setCategory(@Nonnull AffixCategory category) {
        this.category = category;
    }

    @Nonnull
    public AffixCategory getCategory() {
        return this.category;
    }

    public void setModifierGroup(String modifierGroup) {
        this.modifierGroup = modifierGroup;
    }

    public String getModifierGroup() {
        return this.modifierGroup;
    }

    public void setModifierIdentifier(ResourceLocation modifierIdentifier) {
        this.modifierIdentifier = modifierIdentifier;
    }

    public ResourceLocation getModifierIdentifier() {
        return this.modifierIdentifier;
    }

    public void setGameTimeAdded(long gameTimeAdded) {
        this.gameTimeAdded = gameTimeAdded;
    }

    public long getGameTimeAdded() {
        return this.gameTimeAdded;
    }

    public boolean hasGameTimeAdded() {
        return this.getGameTimeAdded() != Long.MIN_VALUE;
    }

    public void resetGameTimeAdded() {
        this.setGameTimeAdded(Long.MIN_VALUE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<MutableComponent> getDisplay(VaultGearData data, AffixType type, ItemStack stack, boolean displayDetail) {
        return super.getDisplay(data, type, stack, displayDetail).map(this.category.getModifierFormatter()).map(displayText -> {
            if (!this.hasGameTimeAdded()) {
                return displayText;
            }
            int showDuration = 600;
            long added = this.getGameTimeAdded();
            ClientLevel currentWorld = Minecraft.m_91087_().f_91073_;
            if (currentWorld == null || currentWorld.m_46467_() - added > (long)showDuration) {
                return displayText;
            }
            displayText.m_7220_((Component)new TextComponent(" [new]").m_130940_(ChatFormatting.GOLD));
            return displayText;
        }).map(displayText -> {
            MutableComponent minMaxRangeCmp;
            if (!displayDetail) {
                return displayText;
            }
            Style txtStyle = Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(false)).m_131162_(Boolean.valueOf(false)).m_131136_(Boolean.valueOf(false));
            String categoryInfo = this.getCategory().getTooltipDescriptor();
            VaultGearTierConfig.ModifierConfigRange configRange = VaultGearTierConfig.getConfig(stack.m_41720_()).map(tierCfg -> tierCfg.getTierConfigRange(this, data.getItemLevel())).orElse(VaultGearTierConfig.ModifierConfigRange.empty());
            ConfigurableAttributeGenerator attributeGenerator = this.getAttribute().getGenerator();
            TextComponent cmpRangeDescriptor = new TextComponent(categoryInfo);
            if (configRange.minAvailableConfig() != null && configRange.maxAvailableConfig() != null && (minMaxRangeCmp = attributeGenerator.getConfigRangeDisplay(this.getAttribute().getReader(), configRange.minAvailableConfig(), configRange.maxAvailableConfig())) != null) {
                if (!cmpRangeDescriptor.getString().isBlank()) {
                    cmpRangeDescriptor.m_130946_(" ");
                }
                cmpRangeDescriptor.m_7220_((Component)minMaxRangeCmp);
                if (Screen.m_96639_()) {
                    cmpRangeDescriptor.m_130946_(",");
                }
            }
            if (Screen.m_96639_()) {
                if (!cmpRangeDescriptor.getString().isBlank()) {
                    cmpRangeDescriptor.m_130946_(" ");
                }
                if (configRange.tierConfig() != null) {
                    MutableComponent rangeCmp = attributeGenerator.getConfigRangeDisplay(this.getAttribute().getReader(), configRange.tierConfig());
                    if (rangeCmp != null) {
                        cmpRangeDescriptor.m_130946_("T%s: ".formatted(this.getRolledTier() + 1));
                        cmpRangeDescriptor.m_7220_((Component)rangeCmp);
                    }
                } else {
                    cmpRangeDescriptor.m_130946_("T%s".formatted(this.getRolledTier() + 1));
                }
            }
            if (!cmpRangeDescriptor.getString().isBlank()) {
                displayText.m_7220_((Component)new TextComponent(" ").m_130948_(txtStyle).m_130946_("(").m_7220_((Component)cmpRangeDescriptor).m_130946_(")"));
            }
            return displayText;
        });
    }

    public Optional<MutableComponent> getConfigDisplay(ItemStack stack) {
        return VaultGearTierConfig.getConfig(stack.m_41720_()).map(tierCfg -> tierCfg.getTierConfig(this)).map(cfg -> {
            ConfigurableAttributeGenerator configGen = this.getAttribute().getGenerator();
            return configGen.getConfigDisplay(this.getAttribute().getReader(), cfg);
        });
    }

    @Override
    public void write(BitBuffer buf) {
        super.write(buf);
        buf.writeInt(this.rolledTier);
        this.category.write(buf);
        buf.writeString(this.modifierGroup);
        buf.writeNullable(this.modifierIdentifier, BitBuffer::writeIdentifier);
        buf.writeLong(this.gameTimeAdded);
    }

    @Override
    public void read(BitBuffer buf, GearDataVersion version) {
        super.read(buf, version);
        this.rolledTier = buf.readInt();
        this.category = AffixCategory.read(buf, version);
        this.modifierGroup = buf.readString();
        this.modifierIdentifier = buf.readNullable(BitBuffer::readIdentifier);
        this.gameTimeAdded = buf.readLong();
    }

    @Override
    public void toNbt(CompoundTag tag) {
        super.toNbt(tag);
        tag.m_128405_("rolledTier", this.rolledTier);
        this.category.writeNbt(tag);
        tag.m_128359_("modifierGroup", this.modifierGroup);
        if (this.modifierIdentifier != null) {
            tag.m_128359_("modifierIdentifier", this.modifierIdentifier.toString());
        }
        tag.m_128356_("gameTimeAdded", this.gameTimeAdded);
    }

    @Override
    protected void fromNbt(CompoundTag tag, GearDataVersion version) {
        super.fromNbt(tag, version);
        this.rolledTier = tag.m_128451_("rolledTier");
        this.category = AffixCategory.readNbt(tag, version);
        this.modifierGroup = tag.m_128461_("modifierGroup");
        if (tag.m_128425_("modifierIdentifier", 8)) {
            this.modifierIdentifier = new ResourceLocation(tag.m_128461_("modifierIdentifier"));
        }
        this.gameTimeAdded = tag.m_128454_("gameTimeAdded");
    }

    @Override
    public JsonObject serialize(AffixType type) {
        JsonObject obj = super.serialize(type);
        obj.addProperty("legendary", Boolean.valueOf(this.category == AffixCategory.LEGENDARY));
        obj.addProperty("category", this.category.name());
        return obj;
    }

    public static enum AffixCategory {
        NONE,
        LEGENDARY("Legendary", ModifierCategoryTooltip::modifyLegendaryTooltip),
        ABYSSAL("Abyssal", ModifierCategoryTooltip::modifyAbyssalTooltip),
        ABILITY_ENHANCEMENT("Enhancement", ModifierCategoryTooltip::modifyEnhancementTooltip),
        CRAFTED("Crafted", ModifierCategoryTooltip::modifyCraftedTooltip);

        private final String descriptor;
        private final Function<MutableComponent, MutableComponent> modifierFormatter;

        private AffixCategory() {
            this("");
        }

        private AffixCategory(String descriptor) {
            this(descriptor, Function.identity());
        }

        private AffixCategory(String descriptor, Function<MutableComponent, MutableComponent> modifierFormatter) {
            this.descriptor = descriptor;
            this.modifierFormatter = modifierFormatter;
        }

        @Nonnull
        public String getTooltipDescriptor() {
            return this.descriptor;
        }

        public Function<MutableComponent, MutableComponent> getModifierFormatter() {
            return this.modifierFormatter;
        }

        public boolean isModifiableByArtisanFoci() {
            return this != ABYSSAL && this != ABILITY_ENHANCEMENT;
        }

        public void write(BitBuffer buf) {
            buf.writeInt(this.ordinal());
        }

        public static AffixCategory read(BitBuffer buf, GearDataVersion version) {
            if (GearDataVersion.V0_3.isLaterThan(version)) {
                if (buf.readBoolean()) {
                    return LEGENDARY;
                }
                return NONE;
            }
            return MiscUtils.getEnumEntry(AffixCategory.class, buf.readInt());
        }

        public void writeNbt(CompoundTag tag) {
            tag.m_128405_("category", this.ordinal());
        }

        public static AffixCategory readNbt(CompoundTag tag, GearDataVersion version) {
            if (tag.m_128425_("legendary", 1)) {
                return tag.m_128471_("legendary") ? LEGENDARY : NONE;
            }
            return MiscUtils.getEnumEntry(AffixCategory.class, tag.m_128451_("category"));
        }
    }

    public static enum AffixType {
        IMPLICIT("Implicits", "Implicit", isPositive -> ""),
        PREFIX("Prefixes", "Prefix", isPositive -> isPositive != false ? "+" : ""),
        SUFFIX("Suffixes", "Suffix", isPositive -> isPositive != false ? "+" : "");

        private static final AffixType[] EXPLICITS;
        private final String plural;
        private final String singular;
        private final Function<Boolean, String> affixPrefix;

        private AffixType(String plural, String singular, Function<Boolean, String> affixPrefix) {
            this.plural = plural;
            this.singular = singular;
            this.affixPrefix = affixPrefix;
        }

        public String getPlural() {
            return this.plural;
        }

        public String getSingular() {
            return this.singular;
        }

        public String getAffixPrefix(boolean isPositive) {
            return this.affixPrefix.apply(isPositive);
        }

        public MutableComponent getAffixPrefixComponent(boolean isPositive) {
            return new TextComponent(this.getAffixPrefix(isPositive));
        }

        public static AffixType[] explicits() {
            return EXPLICITS;
        }

        static {
            EXPLICITS = new AffixType[]{PREFIX, SUFFIX};
        }
    }
}

