/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.ability;

import com.google.gson.JsonArray;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.ability.AbilityFloatValueAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.init.ModConfigs;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class AbilityCooldownFlatAttribute
extends AbilityFloatValueAttribute {
    public AbilityCooldownFlatAttribute(String abilityKey, float amount) {
        super(abilityKey, amount);
    }

    public float adjustCooldown(String ability, float cooldown) {
        if (this.affectsAbility(ability)) {
            return cooldown + this.getAmount();
        }
        return cooldown;
    }

    public String toString() {
        return "AbilityCooldownFlatAttribute{abilityKey='" + this.abilityKey + "', amount=" + this.amount + "}";
    }

    public static VaultGearAttributeType<AbilityCooldownFlatAttribute> type() {
        return AbilityFloatValueAttribute.type(AbilityCooldownFlatAttribute::new);
    }

    public static AbilityFloatValueAttribute.Generator<AbilityCooldownFlatAttribute, AbilityFloatValueAttribute.Config> generator() {
        return AbilityFloatValueAttribute.generator(AbilityCooldownFlatAttribute::new, AbilityFloatValueAttribute.Config.class);
    }

    public static Reader reader() {
        return new Reader();
    }

    private static class Reader
    extends AbilityFloatValueAttribute.Reader<AbilityCooldownFlatAttribute> {
        private Reader() {
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<AbilityCooldownFlatAttribute> instance, VaultGearModifier.AffixType type) {
            AbilityCooldownFlatAttribute attribute = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(attribute);
            if (valueDisplay == null) {
                return null;
            }
            MutableComponent cooldownCmp = new TextComponent("Cooldown").m_130948_(Style.f_131099_.m_131148_(ModConfigs.COLORS.getColor("cooldown")));
            return new TextComponent("").m_7220_((Component)type.getAffixPrefixComponent(attribute.getAmount() >= 0.0f).m_130948_(this.getValueStyle())).m_7220_((Component)valueDisplay.m_130948_(this.getValueStyle())).m_130946_("s").m_130948_(this.getValueStyle()).m_130946_(" to ").m_7220_((Component)cooldownCmp).m_130946_(" of ").m_7220_((Component)new TextComponent(attribute.getAbilityKey()).m_130948_(this.getAbilityStyle())).m_6270_(this.getColoredTextStyle());
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(AbilityCooldownFlatAttribute value) {
            float amtTicks = value.getAmount();
            return new TextComponent(this.formatValue(amtTicks / 20.0f));
        }

        @Override
        protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<AbilityCooldownFlatAttribute> instance, VaultGearModifier.AffixType type) {
            AbilityCooldownFlatAttribute attribute = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(attribute);
            if (valueDisplay == null) {
                return;
            }
            out.add(type.getAffixPrefix(attribute.getAmount() >= 0.0f));
            out.add(valueDisplay.getString());
            out.add("s to Cooldown of ");
            out.add(attribute.getAbilityKey());
        }
    }
}

