/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.ability;

import com.google.gson.JsonArray;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.ability.AbilityFloatValueAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.init.ModConfigs;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class AbilityCooldownPercentAttribute
extends AbilityFloatValueAttribute {
    public AbilityCooldownPercentAttribute(String abilityKey, float amount) {
        super(abilityKey, amount);
    }

    public float adjustCooldown(String ability, float cooldown) {
        if (this.affectsAbility(ability)) {
            return cooldown * Math.max(1.0f + this.getAmount(), 0.0f);
        }
        return cooldown;
    }

    public String toString() {
        return "AbilityCooldownPercentAttribute{abilityKey='" + this.abilityKey + "', amount=" + this.amount + "}";
    }

    public static VaultGearAttributeType<AbilityCooldownPercentAttribute> type() {
        return AbilityFloatValueAttribute.type(AbilityCooldownPercentAttribute::new);
    }

    public static AbilityFloatValueAttribute.Generator<AbilityCooldownPercentAttribute, AbilityFloatValueAttribute.Config> generator() {
        return AbilityFloatValueAttribute.generator(AbilityCooldownPercentAttribute::new, AbilityFloatValueAttribute.Config.class);
    }

    public static Reader reader() {
        return new Reader();
    }

    private static class Reader
    extends AbilityFloatValueAttribute.Reader<AbilityCooldownPercentAttribute> {
        private Reader() {
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<AbilityCooldownPercentAttribute> instance, VaultGearModifier.AffixType type) {
            AbilityCooldownPercentAttribute attribute = instance.getValue();
            TextComponent valueDisplay = this.getValueComponent(Math.abs(attribute.getAmount()));
            boolean positive = attribute.getAmount() >= 0.0f;
            MutableComponent cooldownCmp = new TextComponent("Cooldown").m_130948_(Style.f_131099_.m_131148_(ModConfigs.COLORS.getColor("cooldown")));
            String cdInfo = positive ? " increased " : " reduced ";
            return new TextComponent("").m_7220_((Component)type.getAffixPrefixComponent(positive).m_130948_(this.getValueStyle())).m_7220_((Component)valueDisplay.m_130948_(this.getValueStyle())).m_130946_(cdInfo).m_7220_((Component)cooldownCmp).m_130946_(" of ").m_7220_((Component)new TextComponent(attribute.getAbilityKey()).m_130948_(this.getAbilityStyle())).m_6270_(this.getColoredTextStyle());
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(AbilityCooldownPercentAttribute value) {
            return this.getValueComponent(value.getAmount());
        }

        @Override
        protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<AbilityCooldownPercentAttribute> instance, VaultGearModifier.AffixType type) {
            AbilityCooldownPercentAttribute attribute = instance.getValue();
            TextComponent valueDisplay = this.getValueComponent(Math.abs(attribute.getAmount()));
            boolean positive = attribute.getAmount() >= 0.0f;
            String cdInfo = positive ? " increased Cooldown of " : " reduced Cooldown of ";
            out.add(type.getAffixPrefix(positive));
            out.add(valueDisplay.getString());
            out.add(cdInfo);
            out.add(attribute.getAbilityKey());
        }

        private TextComponent getValueComponent(float value) {
            return new TextComponent(this.formatValue(value * 100.0f) + "%");
        }
    }
}

