/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.ability;

import com.google.gson.Gson;
import com.google.gson.annotations.Expose;
import iskallia.vault.gear.attribute.ability.AbilityGearAttribute;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityModification;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.util.NetcodeUtils;
import java.text.DecimalFormat;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Style;

public abstract class AbilityFloatValueAttribute
extends AbilityGearAttribute {
    protected final float amount;

    public AbilityFloatValueAttribute(String abilityKey, float amount) {
        super(abilityKey);
        this.amount = amount;
    }

    public float getAmount() {
        return this.amount;
    }

    public static <T extends AbilityFloatValueAttribute> VaultGearAttributeType<T> type(BiFunction<String, Float, T> ctor) {
        return VaultGearAttributeType.of((buf, attribute) -> {
            buf.writeString(attribute.getAbilityKey());
            buf.writeFloat(attribute.getAmount());
        }, buf -> (AbilityFloatValueAttribute)ctor.apply(buf.readString(), Float.valueOf(buf.readFloat())), (buf, attribute) -> {
            NetcodeUtils.writeString(buf, attribute.getAbilityKey());
            buf.writeFloat(attribute.getAmount());
        }, buf -> {
            String abilityKey = NetcodeUtils.readString(buf);
            float amount = buf.readFloat();
            return (AbilityFloatValueAttribute)ctor.apply(abilityKey, Float.valueOf(amount));
        }, arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), AbilityFloatValueAttribute.read(ctor), AbilityFloatValueAttribute.write());
    }

    private static <T extends AbilityFloatValueAttribute> Function<Tag, T> read(BiFunction<String, Float, T> ctor) {
        return nbt -> {
            CompoundTag tag = (CompoundTag)nbt;
            String ability = tag.m_128461_("ability");
            float amount = tag.m_128457_("amount");
            return (AbilityFloatValueAttribute)ctor.apply(ability, Float.valueOf(amount));
        };
    }

    private static <T extends AbilityFloatValueAttribute> Function<T, Tag> write() {
        return attribute -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("ability", attribute.getAbilityKey());
            tag.m_128350_("amount", attribute.getAmount());
            return tag;
        };
    }

    public static <T extends AbilityFloatValueAttribute, C extends Config> Generator<T, C> generator(BiFunction<String, Float, T> ctor, Class<C> configClass) {
        return new Generator<T, C>(ctor, configClass);
    }

    public static <T extends AbilityFloatValueAttribute, C extends Config> Generator<T, C> generator(Function<C, T> cfgConverter, Class<C> configClass) {
        return new Generator<T, C>(cfgConverter, configClass);
    }

    public static class Generator<T extends AbilityFloatValueAttribute, C extends Config>
    extends ConfigurableAttributeGenerator<T, C> {
        private final Function<C, T> cfgConverter;
        private final Class<C> configClass;

        protected Generator(BiFunction<String, Float, T> ctor, Class<C> configClass) {
            this((C cfg) -> (AbilityFloatValueAttribute)ctor.apply(cfg.getAbilityKey(), Float.valueOf(cfg.getAmount())), configClass);
        }

        protected Generator(Function<C, T> cfgConverter, Class<C> configClass) {
            this.cfgConverter = cfgConverter;
            this.configClass = configClass;
        }

        @Override
        @Nullable
        public Class<C> getConfigurationObjectClass() {
            return this.configClass;
        }

        @Override
        public T generateRandomValue(C object, Random random) {
            return (T)((AbilityFloatValueAttribute)this.cfgConverter.apply(object));
        }
    }

    public static class Config
    extends AbilityGearAttribute.AbilityAttributeConfig {
        @Expose
        private float amount;

        public Config(String abilityKey, float amount) {
            super(abilityKey);
            this.amount = amount;
        }

        public float getAmount() {
            return this.amount;
        }
    }

    public static abstract class Reader<T extends AbilityFloatValueAttribute>
    extends VaultGearModifierReader<T> {
        private static final DecimalFormat FORMAT = new DecimalFormat("0.#");

        protected Reader() {
            this(0xB4B4B4);
        }

        protected Reader(int rgbColor) {
            super("", rgbColor);
        }

        protected Style getAbilityStyle() {
            return SpecialAbilityModification.getAbilityStyle();
        }

        protected Style getValueStyle() {
            return SpecialAbilityModification.getValueStyle();
        }

        protected String formatValue(float value) {
            return FORMAT.format(value);
        }
    }
}

