/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.ability.special.base;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.annotations.Expose;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.ability.AbilityGearAttribute;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityModification;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityModificationRegistry;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.NetcodeUtils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class SpecialAbilityGearAttribute<C extends SpecialAbilityModification.Config<C>, T extends SpecialAbilityModification<C>>
extends AbilityGearAttribute {
    private final T modification;
    private final C modificationConfig;

    protected SpecialAbilityGearAttribute(String abilityKey, T modification, C modificationConfig) {
        super(abilityKey);
        this.modification = modification;
        this.modificationConfig = modificationConfig;
    }

    public T getModification() {
        return this.modification;
    }

    public C getModificationConfig() {
        return this.modificationConfig;
    }

    public static VaultGearAttributeType<SpecialAbilityGearAttribute> type() {
        return VaultGearAttributeType.of((buf, attribute) -> {
            buf.writeString(attribute.getAbilityKey());
            buf.writeIdentifier(((SpecialAbilityModification)attribute.getModification()).getKey());
            ((SpecialAbilityModification.Config)attribute.getModificationConfig()).write((BitBuffer)buf, attribute.getModificationConfig());
        }, buf -> {
            String ability = buf.readString();
            Object modification = SpecialAbilityModificationRegistry.getAbilityModification(buf.readIdentifier());
            Object cfg = ((SpecialAbilityModification)modification).read((BitBuffer)buf);
            return new SpecialAbilityGearAttribute(ability, modification, cfg);
        }, (buf, attribute) -> {
            NetcodeUtils.writeString(buf, attribute.getAbilityKey());
            NetcodeUtils.writeIdentifier(buf, ((SpecialAbilityModification)attribute.getModification()).getKey());
            ((SpecialAbilityModification.Config)attribute.getModificationConfig()).netWrite((ByteBuf)buf, attribute.getModificationConfig());
        }, buf -> {
            String ability = NetcodeUtils.readString(buf);
            Object modification = SpecialAbilityModificationRegistry.getAbilityModification(NetcodeUtils.readIdentifier(buf));
            Object cfg = ((SpecialAbilityModification)modification).netRead((ByteBuf)buf);
            return new SpecialAbilityGearAttribute(ability, modification, cfg);
        }, arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), SpecialAbilityGearAttribute::read, SpecialAbilityGearAttribute::write);
    }

    private static SpecialAbilityGearAttribute read(Tag tag) {
        CompoundTag nbt = (CompoundTag)tag;
        String ability = nbt.m_128461_("ability");
        String modificationKey = nbt.m_128461_("modification");
        Tag cfgTag = nbt.m_128423_("config");
        Object modification = SpecialAbilityModificationRegistry.getAbilityModification(new ResourceLocation(modificationKey));
        Object cfg = ((SpecialAbilityModification)modification).nbtRead(cfgTag);
        return new SpecialAbilityGearAttribute(ability, modification, cfg);
    }

    private static Tag write(SpecialAbilityGearAttribute attribute) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("ability", attribute.getAbilityKey());
        nbt.m_128359_("modification", ((SpecialAbilityModification)attribute.getModification()).getKey().toString());
        nbt.m_128365_("config", ((SpecialAbilityModification.Config)attribute.getModificationConfig()).nbtWrite(attribute.getModificationConfig()));
        return nbt;
    }

    public static Generator<?, ?> generator() {
        return new Generator();
    }

    public static Reader<?, ?> reader() {
        return new Reader();
    }

    public static class Generator<C extends SpecialAbilityModification.Config<C>, T extends SpecialAbilityModification<C>>
    extends ConfigurableAttributeGenerator<SpecialAbilityGearAttribute<C, T>, SpecialAbilityConfig<C, T>> {
        private Generator() {
        }

        @Override
        @Nullable
        public Class<SpecialAbilityConfig<C, T>> getConfigurationObjectClass() {
            return MiscUtils.cast(SpecialAbilityConfig.class);
        }

        @Override
        public SpecialAbilityGearAttribute<C, T> generateRandomValue(SpecialAbilityConfig<C, T> cfg, Random random) {
            return new SpecialAbilityGearAttribute<C, T>(cfg.getAbilityKey(), cfg.getModification(), cfg.getConfig());
        }
    }

    public static class Reader<C extends SpecialAbilityModification.Config<C>, T extends SpecialAbilityModification<C>>
    extends VaultGearModifierReader<SpecialAbilityGearAttribute<C, T>> {
        private Reader() {
            super("", 0xB4B4B4);
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<SpecialAbilityGearAttribute<C, T>> instance, VaultGearModifier.AffixType type) {
            SpecialAbilityGearAttribute<C, T> attribute = instance.getValue();
            return ((SpecialAbilityModification)attribute.getModification()).getDisplay(attribute.getModificationConfig(), this.getColoredTextStyle(), type);
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(SpecialAbilityGearAttribute<C, T> value) {
            return ((SpecialAbilityModification)value.getModification()).getValueDisplay(value.getModificationConfig());
        }

        @Override
        protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<SpecialAbilityGearAttribute<C, T>> instance, VaultGearModifier.AffixType type) {
            SpecialAbilityGearAttribute<C, T> attribute = instance.getValue();
            ((SpecialAbilityModification)attribute.getModification()).serializeTextElements(out, attribute.getModificationConfig(), type);
        }
    }

    public static class SpecialAbilityConfig<C extends SpecialAbilityModification.Config<C>, T extends SpecialAbilityModification<C>>
    extends AbilityGearAttribute.AbilityAttributeConfig
    implements ConfigurableAttributeGenerator.CustomTierConfig {
        @Expose
        private final ResourceLocation specialModificationKey;
        private C specialConfig;

        public SpecialAbilityConfig(String abilityKey, ResourceLocation specialModificationKey, C config) {
            super(abilityKey);
            this.specialModificationKey = specialModificationKey;
            this.specialConfig = config;
        }

        @Nullable
        public C getConfig() {
            return this.specialConfig;
        }

        @Nullable
        public T getModification() {
            return SpecialAbilityModificationRegistry.getAbilityModification(this.specialModificationKey);
        }

        @Override
        public void deserializeAdditional(JsonObject configObject, JsonDeserializationContext ctx) {
            T modification = this.getModification();
            if (modification != null) {
                this.specialConfig = (SpecialAbilityModification.Config)ctx.deserialize((JsonElement)configObject, ((SpecialAbilityModification)modification).getConfigClass());
            }
        }

        @Override
        public void serializeAdditional(JsonObject configObject, JsonSerializationContext ctx) {
            T modification = this.getModification();
            if (modification != null && this.specialConfig != null) {
                JsonObject obj = ctx.serialize(this.specialConfig, ((SpecialAbilityModification)modification).getConfigClass()).getAsJsonObject();
                for (String key : obj.keySet()) {
                    configObject.add(key, obj.get(key));
                }
            }
        }
    }
}

