/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.ability.special.base;

import iskallia.vault.gear.attribute.ability.special.DashVelocityModification;
import iskallia.vault.gear.attribute.ability.special.EmpowerImmunityModification;
import iskallia.vault.gear.attribute.ability.special.EternalsSpeedModification;
import iskallia.vault.gear.attribute.ability.special.ExecuteHealthModification;
import iskallia.vault.gear.attribute.ability.special.FarmerAdditionalRangeModification;
import iskallia.vault.gear.attribute.ability.special.GhostWalkDurationModification;
import iskallia.vault.gear.attribute.ability.special.HealAdditionalHealthModification;
import iskallia.vault.gear.attribute.ability.special.HunterRangeModification;
import iskallia.vault.gear.attribute.ability.special.ManaShieldAbsorptionModification;
import iskallia.vault.gear.attribute.ability.special.ManaShieldImplodeRadiusModification;
import iskallia.vault.gear.attribute.ability.special.MegaJumpVelocityModification;
import iskallia.vault.gear.attribute.ability.special.NovaRadiusModification;
import iskallia.vault.gear.attribute.ability.special.RampageDamageModification;
import iskallia.vault.gear.attribute.ability.special.TauntRadiusModification;
import iskallia.vault.gear.attribute.ability.special.VeinMinerAdditionalBlocksModification;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityModification;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class SpecialAbilityModificationRegistry {
    private static final Map<ResourceLocation, SpecialAbilityModification<?>> specialModifications = new HashMap();

    public static <T extends SpecialAbilityModification<?>> T getAbilityModification(ResourceLocation key) {
        SpecialAbilityModification<?> modification = specialModifications.get(key);
        if (modification == null) {
            throw new IllegalArgumentException("Unknown special modification: " + key);
        }
        return (T)modification;
    }

    public static void init() {
        SpecialAbilityModificationRegistry.register(new DashVelocityModification());
        SpecialAbilityModificationRegistry.register(new ExecuteHealthModification());
        SpecialAbilityModificationRegistry.register(new FarmerAdditionalRangeModification());
        SpecialAbilityModificationRegistry.register(new GhostWalkDurationModification());
        SpecialAbilityModificationRegistry.register(new HealAdditionalHealthModification());
        SpecialAbilityModificationRegistry.register(new HunterRangeModification());
        SpecialAbilityModificationRegistry.register(new ManaShieldAbsorptionModification());
        SpecialAbilityModificationRegistry.register(new MegaJumpVelocityModification());
        SpecialAbilityModificationRegistry.register(new NovaRadiusModification());
        SpecialAbilityModificationRegistry.register(new RampageDamageModification());
        SpecialAbilityModificationRegistry.register(new EmpowerImmunityModification());
        SpecialAbilityModificationRegistry.register(new TauntRadiusModification());
        SpecialAbilityModificationRegistry.register(new VeinMinerAdditionalBlocksModification());
        SpecialAbilityModificationRegistry.register(new EternalsSpeedModification());
        SpecialAbilityModificationRegistry.register(new ManaShieldImplodeRadiusModification());
    }

    private static void register(SpecialAbilityModification<?> modification) {
        specialModifications.put(modification.getKey(), modification);
    }
}

