/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class RegistryAttributeGenerator<T extends IForgeRegistryEntry<T>>
extends ConfigurableAttributeGenerator<T, RegistryLookup> {
    private final IForgeRegistry<T> registry;

    public RegistryAttributeGenerator(IForgeRegistry<T> registry) {
        this.registry = registry;
    }

    @Override
    @Nullable
    public Class<RegistryLookup> getConfigurationObjectClass() {
        return RegistryLookup.class;
    }

    @Override
    public T generateRandomValue(RegistryLookup object, Random random) {
        return this.getEntry(object);
    }

    public T getEntry(RegistryLookup lookup) {
        return (T)this.registry.getValue(lookup.getRegistryKey());
    }

    public static class RegistryLookup {
        @Expose
        private ResourceLocation registryKey;

        public ResourceLocation getRegistryKey() {
            return this.registryKey;
        }
    }
}

