/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.type;

import iskallia.vault.gear.attribute.custom.EffectAvoidanceGearAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.effect.MobEffect;

public class EffectAvoidanceCombinedMerger
extends VaultGearAttributeTypeMerger<EffectAvoidanceGearAttribute, Avoidances> {
    private static final EffectAvoidanceCombinedMerger INSTANCE = new EffectAvoidanceCombinedMerger();

    private EffectAvoidanceCombinedMerger() {
    }

    public static EffectAvoidanceCombinedMerger getInstance() {
        return INSTANCE;
    }

    @Override
    public Avoidances merge(Avoidances merged, EffectAvoidanceGearAttribute other) {
        if (other.getChance() <= 0.0f) {
            return merged;
        }
        float chance = merged.avoidanceChances.getOrDefault(other.getEffect(), Float.valueOf(0.0f)).floatValue();
        merged.avoidanceChances.put(other.getEffect(), Float.valueOf(chance + other.getChance()));
        return merged;
    }

    @Override
    public Avoidances getBaseValue() {
        return new Avoidances();
    }

    public static class Avoidances {
        private final Map<MobEffect, Float> avoidanceChances = new HashMap<MobEffect, Float>();

        public Map<MobEffect, Float> getAvoidanceChances() {
            return Collections.unmodifiableMap(this.avoidanceChances);
        }
    }
}

