/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.charm;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.CharmConfig;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.gear.CharmItem;
import iskallia.vault.world.data.ServerVaults;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class CharmEffect<T extends Config>
extends ForgeRegistryEntry<CharmEffect<?>> {
    public CharmEffect(ResourceLocation name) {
        this.setRegistryName(name);
    }

    public abstract Class<T> getConfigClass();

    public abstract T getDefaultConfig();

    public CharmConfig.Charm getCharmConfig() {
        return ModConfigs.CHARM.getCharmConfig(this);
    }

    public T getConfig() {
        return (T)((Config)this.getCharmConfig().getConfig());
    }

    public boolean isUsable(ItemStack trinket, Player player) {
        Vault vault;
        if (!CharmItem.isIdentified(trinket)) {
            return false;
        }
        Vault vault2 = vault = player.f_19853_.f_46443_ ? (Vault)ClientVaults.getActive().orElse(null) : (Vault)ServerVaults.get(player.f_19853_).orElse(null);
        if (vault == null) {
            return CharmItem.hasUsesLeft(trinket);
        }
        return CharmItem.isUsableInVault(trinket, vault.get(Vault.ID));
    }

    public void onEquip(LivingEntity entity, ItemStack stack) {
    }

    public void onUnEquip(LivingEntity entity, ItemStack stack) {
    }

    public void onWornTick(LivingEntity entity, ItemStack stack) {
    }

    public static class Config<T extends Number> {
        @Expose
        private final ResourceLocation key;
        private final float value;

        public Config(VaultGearAttribute<T> attribute, float value) {
            this.key = attribute.getRegistryName();
            this.value = value;
        }

        public VaultGearAttribute<T> getAttribute() {
            return VaultGearAttributeRegistry.getAttribute(this.key);
        }

        public VaultGearAttributeInstance<?> toAttributeInstance() {
            return VaultGearAttributeInstance.cast(this.getAttribute(), Float.valueOf(this.value));
        }

        public VaultGearAttributeInstance<?> toAttributeInstance(float value) {
            return VaultGearAttributeInstance.cast(this.getAttribute(), Float.valueOf(value));
        }
    }
}

