/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.crafting;

import iskallia.vault.block.entity.ToolStationTileEntity;
import iskallia.vault.container.oversized.OverSizedItemStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class ToolStationHelper {
    public static List<ItemStack> getMissingInputs(List<ItemStack> recipeInputs, Inventory playerInventory, ToolStationTileEntity tile) {
        ArrayList<ItemStack> missing = new ArrayList<ItemStack>();
        for (ItemStack input : recipeInputs) {
            int neededCount = input.m_41613_();
            for (OverSizedItemStack overSized : tile.getInventory().getOverSizedContents()) {
                if (!ToolStationHelper.isEqualCrafting(input, overSized.stack())) continue;
                neededCount -= overSized.amount();
            }
            for (ItemStack plStack : playerInventory.f_35974_) {
                if (!ToolStationHelper.isEqualCrafting(input, plStack)) continue;
                neededCount -= plStack.m_41613_();
            }
            if (neededCount <= 0) continue;
            missing.add(input);
        }
        return missing;
    }

    public static boolean consumeInputs(List<ItemStack> recipeInputs, Inventory playerInventory, ToolStationTileEntity tile, boolean simulate) {
        return ToolStationHelper.consumeInputs(recipeInputs, playerInventory, tile, simulate, new ArrayList<OverSizedItemStack>());
    }

    public static boolean consumeInputs(List<ItemStack> recipeInputs, Inventory playerInventory, ToolStationTileEntity tile, boolean simulate, List<OverSizedItemStack> consumed) {
        boolean missingInput = true;
        for (ItemStack input : recipeInputs) {
            int neededCount = input.m_41613_();
            NonNullList<OverSizedItemStack> overSizedContents = tile.getInventory().getOverSizedContents();
            for (int slot = 0; slot < overSizedContents.size(); ++slot) {
                OverSizedItemStack overSized = (OverSizedItemStack)overSizedContents.get(slot);
                if (neededCount <= 0) break;
                if (!ToolStationHelper.isEqualCrafting(input, overSized.stack())) continue;
                int deductedAmount = Math.min(neededCount, overSized.amount());
                if (!simulate) {
                    tile.getInventory().setOverSizedStack(slot, overSized.addCopy(-deductedAmount));
                    consumed.add(overSized.copyAmount(deductedAmount));
                }
                neededCount -= overSized.amount();
            }
            NonNullList items = playerInventory.f_35974_;
            for (ItemStack plStack : items) {
                if (neededCount <= 0) break;
                if (!ToolStationHelper.isEqualCrafting(input, plStack)) continue;
                int deductedAmount = Math.min(neededCount, plStack.m_41613_());
                if (!simulate) {
                    ItemStack deducted = plStack.m_41777_();
                    deducted.m_41764_(deductedAmount);
                    consumed.add(OverSizedItemStack.of(deducted));
                    plStack.m_41774_(deductedAmount);
                }
                neededCount -= deductedAmount;
            }
            if (neededCount <= 0) continue;
            missingInput = false;
        }
        return missingInput;
    }

    private static boolean isEqualCrafting(ItemStack thisStack, ItemStack thatStack) {
        return thisStack.m_41720_() == thatStack.m_41720_() && thisStack.m_41773_() == thatStack.m_41773_() && (thisStack.m_41783_() == null || thisStack.areShareTagsEqual(thatStack));
    }
}

