/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.crafting;

import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;

public class VaultEnchanterHelper {
    public static boolean hasCraftedModifier(ItemStack gear) {
        if (gear.m_41619_() || !AttributeGearData.hasData(gear)) {
            return false;
        }
        VaultGearData data = VaultGearData.read(gear);
        for (VaultGearModifier<?> modifier : data.getAllModifierAffixes()) {
            if (modifier.getCategory() != VaultGearModifier.AffixCategory.CRAFTED) continue;
            return true;
        }
        return false;
    }

    public static boolean removeCraftedModifiers(ItemStack stack) {
        VaultGearData data = VaultGearData.read(stack);
        boolean removedModifiers = false;
        for (VaultGearModifier<?> modifier : new ArrayList(data.getModifiers(VaultGearModifier.AffixType.IMPLICIT))) {
            if (modifier.getCategory() != VaultGearModifier.AffixCategory.CRAFTED || !data.removeModifier(modifier)) continue;
            removedModifiers = true;
        }
        for (VaultGearModifier<?> modifier : new ArrayList(data.getModifiers(VaultGearModifier.AffixType.PREFIX))) {
            if (modifier.getCategory() != VaultGearModifier.AffixCategory.CRAFTED || !data.removeModifier(modifier)) continue;
            removedModifiers = true;
        }
        for (VaultGearModifier<?> modifier : new ArrayList(data.getModifiers(VaultGearModifier.AffixType.SUFFIX))) {
            if (modifier.getCategory() != VaultGearModifier.AffixCategory.CRAFTED || !data.removeModifier(modifier)) continue;
            removedModifiers = true;
        }
        if (removedModifiers) {
            data.write(stack);
        }
        return removedModifiers;
    }
}

