/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.crafting;

import iskallia.vault.config.gear.VaultGearCraftingConfig;
import iskallia.vault.config.gear.VaultGearTypeConfig;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.crafting.ProficiencyType;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.expertise.type.ArtisanExpertise;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.world.data.PlayerExpertisesData;
import iskallia.vault.world.data.PlayerProficiencyData;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.extensions.IForgeItem;

public class VaultGearCraftingHelper {
    private static final Random rand = new Random();

    public static void reducePotential(ItemStack stack, Player player, GearModification action) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultGearItem)) {
            return;
        }
        float chance = 0.0f;
        ExpertiseTree expertises = PlayerExpertisesData.get((ServerLevel)player.f_19853_).getExpertises(player);
        for (ArtisanExpertise expertise : expertises.getAll(ArtisanExpertise.class, Skill::isUnlocked)) {
            chance += expertise.getChanceToNotConsumePotential();
        }
        if (rand.nextFloat() < chance) {
            return;
        }
        VaultGearData data = VaultGearData.read(stack);
        int potentialReduction = ModConfigs.VAULT_GEAR_MODIFICATION_CONFIG.getPotentialUsed(action);
        int potential = data.getFirstValue(ModGearAttributes.CRAFTING_POTENTIAL).orElse(0);
        if (potential > 0) {
            data.updateAttribute(ModGearAttributes.CRAFTING_POTENTIAL, Math.max(potential - potentialReduction, 0));
        } else {
            data.updateAttribute(ModGearAttributes.CRAFTING_POTENTIAL, potential - potentialReduction);
        }
        data.write(stack);
    }

    @Nonnull
    public static <T extends IForgeItem & VaultGearItem> ItemStack doCraftGear(T item, ServerPlayer crafter, int level, boolean simulate) {
        ItemStack stack = new ItemStack((ItemLike)((VaultGearItem)item).getItem());
        VaultGearData data = VaultGearData.read(stack);
        data.setItemLevel(level);
        data.updateAttribute(ModGearAttributes.CRAFTED_BY, crafter.m_7755_().m_6111_());
        data.updateAttribute(ModGearAttributes.GEAR_ROLL_TYPE, VaultGearCraftingHelper.getCraftedRollType(stack, crafter).getName());
        data.write(stack);
        if (!simulate) {
            VaultGearCraftingHelper.notifyGearCrafted(stack, crafter);
        }
        return stack;
    }

    @Nonnull
    public static VaultGearTypeConfig.RollType getCraftedRollType(ItemStack stack, ServerPlayer player) {
        Item item;
        VaultGearCraftingConfig cfg = ModConfigs.VAULT_GEAR_CRAFTING_CONFIG;
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof VaultGearItem)) {
            return cfg.getDefaultCraftedPool();
        }
        VaultGearItem gearItem = (VaultGearItem)item;
        PlayerProficiencyData proficiencyData = PlayerProficiencyData.get(player.m_183503_());
        ProficiencyType type = gearItem.getCraftingProficiencyType(stack);
        return cfg.getRollPool(proficiencyData.getProficiency((Player)player, type));
    }

    public static void notifyGearCrafted(ItemStack stack, ServerPlayer player) {
        Item item;
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof VaultGearItem)) {
            return;
        }
        VaultGearItem gearItem = (VaultGearItem)item;
        VaultGearCraftingConfig cfg = ModConfigs.VAULT_GEAR_CRAFTING_CONFIG;
        PlayerProficiencyData proficiencyData = PlayerProficiencyData.get(player.m_183503_());
        ProficiencyType type = gearItem.getCraftingProficiencyType(stack);
        proficiencyData.updateProficiency(player, type, cfg.getRandomProficiencyGain());
    }

    public static void reRollCraftingPotential(ItemStack stack) {
        VaultGearData data = VaultGearData.read(stack);
        VaultGearRarity rarity = data.getRarity();
        String rollType = (String)data.get(ModGearAttributes.GEAR_ROLL_TYPE, VaultGearAttributeTypeMerger.firstNonNull());
        int potential = ModConfigs.VAULT_GEAR_CRAFTING_CONFIG.getNewCraftingPotential(rarity, rollType);
        potential = (int)((float)potential * (1.0f + ModConfigs.VAULT_GEAR_CRAFTING_CONFIG.getPotentialIncreasePerLevel() * (float)data.getItemLevel()));
        data.updateAttribute(ModGearAttributes.CRAFTING_POTENTIAL, potential);
        data.write(stack);
    }
}

