/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.crafting.recipe;

import io.netty.buffer.ByteBuf;
import iskallia.vault.config.recipe.ForgeRecipeType;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.util.NetcodeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class VaultForgeRecipe {
    private final ForgeRecipeType type;
    private final ResourceLocation id;
    protected final ItemStack output;
    private final List<ItemStack> inputs = new ArrayList<ItemStack>();

    protected VaultForgeRecipe(ForgeRecipeType type, ResourceLocation id, ItemStack output) {
        this(type, id, output, new ArrayList<ItemStack>());
    }

    public VaultForgeRecipe(ForgeRecipeType type, ResourceLocation id, ItemStack output, List<ItemStack> inputs) {
        this.type = type;
        this.id = id;
        this.output = output;
        this.inputs.addAll(inputs);
    }

    protected void readAdditional(FriendlyByteBuf buf) {
    }

    protected void writeAdditional(FriendlyByteBuf buf) {
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.inputs);
    }

    public boolean usesLevel() {
        return false;
    }

    protected ItemStack getRawOutput() {
        return this.output.m_41777_();
    }

    public ItemStack getDisplayOutput(int vaultLevel) {
        return this.getRawOutput();
    }

    public void addCraftingDisplayTooltip(ItemStack result, List<Component> out) {
    }

    public ItemStack createOutput(List<OverSizedItemStack> consumed, ServerPlayer crafter, int vaultLevel) {
        return this.getRawOutput();
    }

    public boolean canCraft(Player player) {
        return true;
    }

    public Component getDisabledText() {
        return new TextComponent("Undiscovered").m_130940_(ChatFormatting.ITALIC);
    }

    public static VaultForgeRecipe read(FriendlyByteBuf buf) {
        ForgeRecipeType recipeType = (ForgeRecipeType)buf.m_130066_(ForgeRecipeType.class);
        ResourceLocation id = buf.m_130281_();
        ItemStack out = buf.m_130267_();
        VaultForgeRecipe recipe = recipeType.makeRecipe(id, out);
        NetcodeUtils.readCollection((ByteBuf)buf, ArrayList::new, buffer -> OverSizedItemStack.read(buf).overSizedStack()).forEach(recipe.inputs::add);
        recipe.readAdditional(buf);
        return recipe;
    }

    public final void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.type);
        buf.m_130085_(this.getId());
        buf.writeItemStack(this.output, false);
        NetcodeUtils.writeCollection((ByteBuf)buf, this.inputs, (stack, buffer) -> new OverSizedItemStack((ItemStack)stack, stack.m_41613_()).write(buf));
        this.writeAdditional(buf);
    }
}

