/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.data;

import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.util.MiscUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class GearDataCache {
    private final ItemStack stack;

    private GearDataCache(ItemStack stack) {
        this.stack = stack;
    }

    public static GearDataCache of(ItemStack stack) {
        if (!AttributeGearData.hasData(stack)) {
            return new GearDataCache(ItemStack.f_41583_);
        }
        return new GearDataCache(stack);
    }

    public static void removeCache(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41784_().m_128441_("clientCache")) {
            stack.m_41784_().m_128473_("clientCache");
        }
    }

    public static void createCache(ItemStack stack) {
        GearDataCache cache = GearDataCache.of(stack);
        cache.getState();
        cache.getRarity();
        cache.getGearModel();
        cache.getGearColor(0);
        cache.getGearRollType();
        cache.getGearName();
        cache.getGearColorComponents();
        cache.getJewelColorComponents();
    }

    private CompoundTag cacheTag() {
        if (this.stack.m_41619_()) {
            return new CompoundTag();
        }
        return this.stack.m_41698_("clientCache");
    }

    @Nonnull
    private <T> CacheResult<T> getOptionalCache(String key, Function<Tag, T> nbtRead) {
        byte tagType = this.cacheTag().m_128435_(key);
        if (tagType == 0) {
            return CacheResult.miss();
        }
        if (tagType == 7) {
            return CacheResult.none();
        }
        return CacheResult.hit(nbtRead.apply(this.cacheTag().m_128423_(key)));
    }

    private void setOptionalCache(String key, @Nullable Tag value) {
        if (value == null) {
            this.cacheTag().m_128365_(key, (Tag)new ByteArrayTag(new byte[0]));
        } else {
            this.cacheTag().m_128365_(key, value);
        }
    }

    private <R, T> T queryCache(String key, Function<Tag, R> cacheRead, Function<R, Tag> cacheWrite, T cacheMissDefault, Function<R, T> cacheHitTransform, Function<ItemStack, R> cacheInit) {
        if (this.stack.m_41619_()) {
            return cacheMissDefault;
        }
        CacheResult<R> cacheResult = this.getOptionalCache(key, cacheRead);
        if (cacheResult.hitHasNoValue()) {
            return cacheMissDefault;
        }
        if (cacheResult.isHit()) {
            return cacheHitTransform.apply(cacheResult.value());
        }
        R rawValue = cacheInit.apply(this.stack);
        if (rawValue == null) {
            this.setOptionalCache(key, null);
            return cacheMissDefault;
        }
        this.setOptionalCache(key, cacheWrite.apply(rawValue));
        return cacheHitTransform.apply(rawValue);
    }

    private Integer queryIntCache(String key, int defaultValue, Function<ItemStack, Integer> cacheInit) {
        return this.queryCache(key, tag -> ((IntTag)tag).m_7047_(), IntTag::m_128679_, defaultValue, Function.identity(), cacheInit);
    }

    private <T extends Enum<T>> T queryEnumCache(String key, Class<T> enumClass, Function<ItemStack, Integer> cacheInit) {
        return (T)this.queryCache(key, tag -> ((IntTag)tag).m_7047_(), IntTag::m_128679_, null, ordinal -> MiscUtils.getEnumEntry(enumClass, ordinal), cacheInit);
    }

    @Nullable
    public VaultGearState getState() {
        return this.queryEnumCache("state", VaultGearState.class, stack -> {
            VaultGearState data = AttributeGearData.read(this.stack);
            if (!(data instanceof VaultGearData)) {
                return ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.STATE).map(Enum::ordinal).orElse(null);
            }
            VaultGearData gearData = (VaultGearData)((Object)data);
            return gearData.getState().ordinal();
        });
    }

    @Nullable
    public VaultGearRarity getRarity() {
        return this.queryEnumCache("rarity", VaultGearRarity.class, stack -> {
            Object data = AttributeGearData.read(this.stack);
            if (!(data instanceof VaultGearData)) {
                return null;
            }
            VaultGearData gearData = (VaultGearData)data;
            return gearData.getRarity().ordinal();
        });
    }

    public Optional<ResourceLocation> getGearModel() {
        return this.queryCache("model", Tag::m_7916_, StringTag::m_129297_, Optional.empty(), modelStr -> Optional.of(new ResourceLocation(modelStr)), stack -> {
            ResourceLocation data = AttributeGearData.read(this.stack);
            return data.getFirstValue(ModGearAttributes.GEAR_MODEL).map(ResourceLocation::toString).orElse(null);
        });
    }

    public int getGearColor(int defaultColor) {
        return this.queryIntCache("color", defaultColor, stack -> {
            Integer data = AttributeGearData.read(this.stack);
            Optional<Integer> colorOpt = ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.GEAR_COLOR);
            return colorOpt.orElse(null);
        });
    }

    @Nullable
    public String getGearRollType() {
        return this.queryCache("rollType", Tag::m_7916_, StringTag::m_129297_, null, Function.identity(), stack -> {
            String data = AttributeGearData.read(this.stack);
            Optional<String> rollTypeOpt = ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE);
            return rollTypeOpt.orElse(null);
        });
    }

    @Nullable
    public String getGearName() {
        return this.queryCache("gearName", Tag::m_7916_, StringTag::m_129297_, null, Function.identity(), stack -> {
            String data = AttributeGearData.read(stack);
            Optional<String> nameOpt = ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.GEAR_NAME);
            return nameOpt.orElse(null);
        });
    }

    @Nullable
    public List<Integer> getGearColorComponents() {
        return this.queryCache("colors", tag -> ((IntArrayTag)tag).m_128648_(), IntArrayTag::new, null, components -> Arrays.stream(components).boxed().toList(), stack -> {
            Object data = AttributeGearData.read(this.stack);
            if (!(data instanceof VaultGearData)) {
                return null;
            }
            VaultGearData gearData = (VaultGearData)data;
            ArrayList<Integer> components = new ArrayList<Integer>();
            components.add(gearData.getRarity().getColor().m_131265_());
            for (VaultGearAttributeInstance<?> attributeInstance : gearData.getAllAttributes()) {
                VaultGearModifier modifier;
                if (!(attributeInstance instanceof VaultGearModifier) || (modifier = (VaultGearModifier)attributeInstance).getCategory() != VaultGearModifier.AffixCategory.LEGENDARY) continue;
                components.add(15853364);
                break;
            }
            return components.stream().mapToInt(Integer::intValue).toArray();
        });
    }

    @Nullable
    public List<Integer> getJewelColorComponents() {
        return this.queryCache("jcolors", tag -> ((IntArrayTag)tag).m_128648_(), IntArrayTag::new, null, components -> Arrays.stream(components).boxed().toList(), stack -> {
            Object data = AttributeGearData.read(this.stack);
            if (!(data instanceof VaultGearData)) {
                return null;
            }
            VaultGearData gearData = (VaultGearData)data;
            ArrayList<Integer> components = new ArrayList<Integer>();
            for (VaultGearModifier<?> modifier : gearData.getAllModifierAffixes()) {
                components.add(modifier.getAttribute().getReader().getRgbColor());
            }
            return components.stream().mapToInt(Integer::intValue).toArray();
        });
    }

    private record CacheResult<T>(ResultType type, T value) {
        private static <T> CacheResult<T> miss() {
            return new CacheResult<Object>(ResultType.MISS, null);
        }

        private static <T> CacheResult<T> none() {
            return new CacheResult<Object>(ResultType.HIT_NONE, null);
        }

        private static <T> CacheResult<T> hit(T value) {
            return new CacheResult<T>(ResultType.HIT, value);
        }

        private boolean isHit() {
            return this.type == ResultType.HIT;
        }

        private boolean hitHasNoValue() {
            return this.type == ResultType.HIT_NONE;
        }
    }

    private static enum ResultType {
        HIT,
        HIT_NONE,
        MISS;

    }
}

