/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.item;

import iskallia.vault.gear.GearRollHelper;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface IdentifiableItem {
    default public VaultGearState getState(ItemStack stack) {
        VaultGearState data = AttributeGearData.read(stack);
        if (data instanceof VaultGearData) {
            VaultGearData gearData = (VaultGearData)((Object)data);
            return gearData.getState();
        }
        return ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.STATE).orElse(VaultGearState.UNIDENTIFIED);
    }

    default public void setState(ItemStack stack, VaultGearState state) {
        VaultGearState data = AttributeGearData.read(stack);
        if (data instanceof VaultGearData) {
            VaultGearData gearData = (VaultGearData)((Object)data);
            gearData.setState(state);
            gearData.write(stack);
            return;
        }
        ((AttributeGearData)((Object)data)).updateAttribute(ModGearAttributes.STATE, (VaultGearState)state);
        ((AttributeGearData)((Object)data)).write(stack);
    }

    default public boolean tryStartIdentification(Player player, ItemStack stack) {
        if (this.getState(stack) != VaultGearState.UNIDENTIFIED) {
            return false;
        }
        if (player.m_21120_(InteractionHand.OFF_HAND).m_150930_((Item)ModItems.IDENTIFICATION_TOME)) {
            this.instantIdentify(player, stack);
            return true;
        }
        this.setState(stack, VaultGearState.ROLLING);
        return true;
    }

    default public void inventoryIdentificationTick(Player player, ItemStack stack) {
        if (this.getState(stack) == VaultGearState.ROLLING) {
            GearRollHelper.tickToll(stack, player, this::tickRoll, finishStack -> this.tickFinishRoll((ItemStack)finishStack, player));
        }
    }

    default public void instantIdentify(Player player, ItemStack stack) {
        if (this.getState(stack) == VaultGearState.UNIDENTIFIED) {
            this.tickRoll(stack, player);
            this.tickFinishRoll(stack, player);
        }
    }

    public void tickRoll(ItemStack var1, Player var2);

    public void tickFinishRoll(ItemStack var1, Player var2);
}

