/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.modification;

import iskallia.vault.container.VaultArtisanStationContainer;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.gear.modification.GearModificationCost;
import iskallia.vault.init.ModGearAttributes;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public record GearModificationAction(int slotIndex, GearModification modification, boolean right) {
    private static final Random rand = new Random();

    @Nullable
    public Slot getCorrespondingSlot(VaultArtisanStationContainer container) {
        for (Slot slot : container.f_38839_) {
            if (slot.f_40219_ != this.slotIndex()) continue;
            return slot;
        }
        return null;
    }

    public void apply(VaultArtisanStationContainer container, ServerPlayer player) {
        if (!this.canApply(container, (Player)player)) {
            return;
        }
        ItemStack gear = container.getGearInputSlot().m_7993_();
        VaultGearData data = VaultGearData.read(gear);
        Optional<Integer> potential = data.getFirstValue(ModGearAttributes.CRAFTING_POTENTIAL);
        if (potential.isEmpty()) {
            return;
        }
        Slot inSlot = this.getCorrespondingSlot(container);
        if (inSlot == null) {
            return;
        }
        ItemStack input = inSlot.m_7993_();
        ItemStack material = input.m_41777_();
        input.m_41774_(1);
        inSlot.m_5852_(input);
        String rollType = (String)data.get(ModGearAttributes.GEAR_ROLL_TYPE, VaultGearAttributeTypeMerger.firstNonNull());
        GearModificationCost cost = GearModificationCost.getCost(data.getRarity(), rollType, data.getItemLevel(), potential.get(), this.modification());
        ItemStack bronze = container.getBronzeSlot().m_7993_();
        bronze.m_41774_(cost.costBronze());
        container.getBronzeSlot().m_5852_(bronze);
        ItemStack plating = container.getPlatingSlot().m_7993_();
        plating.m_41774_(cost.costPlating());
        container.getPlatingSlot().m_5852_(plating);
        this.modification().apply(gear, material, (Player)player, rand);
    }

    public boolean canApply(VaultArtisanStationContainer container, Player player) {
        Slot inSlot = this.getCorrespondingSlot(container);
        if (inSlot == null) {
            return false;
        }
        ItemStack gear = container.getGearInputSlot().m_7993_();
        ItemStack in = inSlot.m_7993_();
        if (in.m_41619_() || gear.m_41619_()) {
            return false;
        }
        VaultGearData data = VaultGearData.read(gear);
        Optional<Integer> potential = data.getFirstValue(ModGearAttributes.CRAFTING_POTENTIAL);
        if (potential.isEmpty()) {
            return false;
        }
        String rollType = (String)data.get(ModGearAttributes.GEAR_ROLL_TYPE, VaultGearAttributeTypeMerger.firstNonNull());
        GearModificationCost cost = GearModificationCost.getCost(data.getRarity(), rollType, data.getItemLevel(), potential.get(), this.modification());
        ItemStack bronze = container.getBronzeSlot().m_7993_();
        ItemStack plating = container.getPlatingSlot().m_7993_();
        if (bronze.m_41613_() < cost.costBronze() || plating.m_41613_() < cost.costPlating()) {
            return false;
        }
        return this.modification().canApply(gear, in, player, rand);
    }
}

