/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.reader;

import com.google.gson.JsonArray;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import java.text.DecimalFormat;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;

public class IncreasedPercentageReader<T extends Number>
extends VaultGearModifierReader<T> {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.##");

    public IncreasedPercentageReader(String modifierName, int rgbColor) {
        super(modifierName, rgbColor);
    }

    @Override
    @Nullable
    public MutableComponent getDisplay(VaultGearAttributeInstance<T> instance, VaultGearModifier.AffixType type) {
        MutableComponent valueDisplay = this.getValueDisplay((T)((Number)instance.getValue()));
        if (valueDisplay == null) {
            return null;
        }
        boolean positive = ((Number)instance.getValue()).doubleValue() >= 0.0;
        String incInfo = positive ? "Increased" : "Reduced";
        return new TextComponent(type.getAffixPrefix(positive)).m_130948_(this.getColoredTextStyle()).m_7220_((Component)valueDisplay).m_130948_(this.getColoredTextStyle()).m_130946_(" ").m_130946_(incInfo).m_130948_(this.getColoredTextStyle()).m_130946_(" ").m_7220_((Component)new TextComponent(this.getModifierName())).m_130948_(this.getColoredTextStyle());
    }

    @Override
    @Nullable
    public MutableComponent getValueDisplay(T value) {
        return new TextComponent(FORMAT.format(((Number)value).doubleValue() * 100.0) + "%");
    }

    @Override
    protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<T> instance, VaultGearModifier.AffixType type) {
        MutableComponent valueDisplay = this.getValueDisplay((T)((Number)instance.getValue()));
        if (valueDisplay == null) {
            return;
        }
        boolean positive = ((Number)instance.getValue()).doubleValue() >= 0.0;
        String incInfo = positive ? "Increased" : "Reduced";
        out.add(type.getAffixPrefix(((Number)instance.getValue()).doubleValue() >= 0.0));
        out.add(valueDisplay.getString());
        out.add(" ");
        out.add(incInfo);
        out.add(" ");
        out.add(this.getModifierName());
    }
}

