/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.reader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.util.TextComponentUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;

public abstract class VaultGearModifierReader<T> {
    private final String modifierName;
    private final int rgbColor;

    protected VaultGearModifierReader(String modifierName, int rgbColor) {
        this.modifierName = modifierName;
        this.rgbColor = rgbColor;
    }

    public String getModifierName() {
        return this.modifierName;
    }

    public int getRgbColor() {
        return this.rgbColor;
    }

    public Style getColoredTextStyle() {
        return Style.f_131099_.m_178520_(this.getRgbColor());
    }

    @Nullable
    public abstract MutableComponent getDisplay(VaultGearAttributeInstance<T> var1, VaultGearModifier.AffixType var2);

    @Nullable
    public abstract MutableComponent getValueDisplay(T var1);

    @Nonnull
    public JsonObject serializeDisplay(VaultGearAttributeInstance<T> instance, VaultGearModifier.AffixType type) {
        JsonObject obj = new JsonObject();
        obj.addProperty("color", (Number)this.getRgbColor());
        JsonArray elements = new JsonArray();
        this.serializeTextElements(elements, instance, type);
        obj.add("elements", (JsonElement)elements);
        return obj;
    }

    protected abstract void serializeTextElements(JsonArray var1, VaultGearAttributeInstance<T> var2, VaultGearModifier.AffixType var3);

    public MutableComponent formatConfigDisplay(LogicalSide side, Component configRange) {
        MutableComponent cmp = new TextComponent("%s " + this.getModifierName()).m_130948_(this.getColoredTextStyle());
        return TextComponentUtils.replace(TextComponentUtils.createSourceStack(side), (Component)cmp, "%s", configRange);
    }

    @Nullable
    public MutableComponent getDisplay(VaultGearAttributeInstance<T> instance, VaultGearData data, VaultGearModifier.AffixType type, ItemStack stack) {
        return this.getDisplay(instance, type);
    }
}

