/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.tooltip;

import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.config.EtchingConfig;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.etching.EtchingSet;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.tooltip.GearTooltip;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface VaultGearTooltipItem {
    default public List<Component> createTooltip(ItemStack stack, GearTooltip flag) {
        if (!ModConfigs.isInitialized()) {
            return Collections.emptyList();
        }
        long window = Minecraft.m_91087_().m_91268_().m_85439_();
        boolean shiftDown = InputConstants.m_84830_((long)window, (int)340) || InputConstants.m_84830_((long)window, (int)344);
        VaultGearData data = VaultGearData.read(stack);
        ArrayList<Component> tooltip = new ArrayList<Component>();
        VaultGearState state = data.getState();
        this.addTooltipItemLevel(data, stack, tooltip, state);
        if (flag.displayCraftingDetail()) {
            this.addTooltipCraftingPotential(data, stack, tooltip, state);
            this.addTooltipToolCapacity(data, stack, tooltip, state);
        }
        if (flag.displayBase()) {
            data.getFirstValue(ModGearAttributes.CRAFTED_BY).ifPresent(crafter -> tooltip.add((Component)new TextComponent("Crafted by: ").m_7220_((Component)new TextComponent(crafter).m_6270_(Style.f_131099_.m_178520_(16770048)))));
        }
        if (shiftDown || state == VaultGearState.UNIDENTIFIED) {
            this.addTooltipRarity(data, stack, tooltip, state);
        }
        if (state == VaultGearState.IDENTIFIED) {
            List<VaultGearModifier<?>> implicits;
            VaultGearItem gearItem;
            EquipmentSlot slot;
            Item item;
            if (flag.displayBase()) {
                this.addTooltipEtchingSet(tooltip, data);
            }
            if ((item = stack.m_41720_()) instanceof VaultGearItem && (slot = (gearItem = (VaultGearItem)item).getIntendedSlot(stack)) != null) {
                this.addSlotTooltip(tooltip, slot);
            }
            int usedRepairs = data.getUsedRepairSlots();
            int totalRepairs = data.getRepairSlots();
            this.addRepairTooltip(tooltip, usedRepairs, totalRepairs);
            this.addTooltipDurability(tooltip, stack);
            if (shiftDown && flag.displayBase()) {
                this.addTooltipGearModel(data, stack, tooltip);
            }
            if (!(implicits = data.getModifiers(VaultGearModifier.AffixType.IMPLICIT)).isEmpty()) {
                this.addTooltipAffixGroup(data, VaultGearModifier.AffixType.IMPLICIT, stack, tooltip, flag.displayModifierDetail());
                tooltip.add(TextComponent.f_131282_);
            }
            int maxPrefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0);
            List<VaultGearModifier<?>> prefixes = data.getModifiers(VaultGearModifier.AffixType.PREFIX);
            int maxSuffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0);
            List<VaultGearModifier<?>> suffixes = data.getModifiers(VaultGearModifier.AffixType.SUFFIX);
            if (maxPrefixes > 0 || !prefixes.isEmpty()) {
                this.addTooltipAffixGroup(data, VaultGearModifier.AffixType.PREFIX, stack, tooltip, flag.displayModifierDetail());
                if (flag.displayModifierDetail() && (maxSuffixes > 0 || !suffixes.isEmpty())) {
                    tooltip.add(TextComponent.f_131282_);
                }
            }
            if (maxSuffixes > 0 || !suffixes.isEmpty()) {
                this.addTooltipAffixGroup(data, VaultGearModifier.AffixType.SUFFIX, stack, tooltip, flag.displayModifierDetail());
                if (!data.isModifiable()) {
                    tooltip.add(TextComponent.f_131282_);
                }
            }
        }
        if (!data.isModifiable()) {
            MutableComponent ct = new TextComponent("").m_7220_((Component)new TextComponent("Corrupted").m_6270_(Style.f_131099_.m_178520_(12981760)));
            if (flag.displayModifierDetail()) {
                ct.m_7220_((Component)new TextComponent("  Unmodifiable Item").m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)ct);
        }
        return tooltip;
    }

    default public void addTooltipAffixGroup(VaultGearData data, VaultGearModifier.AffixType type, ItemStack stack, List<Component> tooltip, boolean displayDetails) {
        List<VaultGearModifier<?>> affixes = data.getModifiers(type);
        VaultGearAttribute<Integer> affixAttribute = type == VaultGearModifier.AffixType.PREFIX ? ModGearAttributes.PREFIXES : ModGearAttributes.SUFFIXES;
        int emptyAffixes = data.getFirstValue(affixAttribute).orElse(0);
        if (displayDetails) {
            tooltip.add((Component)new TextComponent(type.getPlural() + ":").m_130940_(ChatFormatting.GRAY));
        }
        affixes.forEach(modifier -> modifier.getDisplay(data, type, stack, displayDetails).ifPresent(tooltip::add));
        if (displayDetails && type != VaultGearModifier.AffixType.IMPLICIT) {
            for (int i = 0; i < emptyAffixes - affixes.size(); ++i) {
                tooltip.add(this.addTooltipEmptyAffixes(type));
            }
        }
    }

    default public void addRepairTooltip(List<Component> tooltip, int usedRepairs, int totalRepairs) {
        if (totalRepairs <= 0) {
            return;
        }
        int remaining = totalRepairs - usedRepairs;
        tooltip.add((Component)new TextComponent("Repairs: ").m_7220_(this.addTooltipDots(usedRepairs, ChatFormatting.YELLOW)).m_7220_(this.addTooltipDots(remaining, ChatFormatting.GRAY)));
    }

    default public void addSlotTooltip(List<Component> tooltip, EquipmentSlot slot) {
        tooltip.add((Component)new TextComponent("Slot: ").m_7220_((Component)new TranslatableComponent("the_vault.equipment." + slot.m_20751_()).m_130948_(Style.f_131099_.m_178520_(14869130))));
    }

    default public void addTooltipEtchingSet(List<Component> tooltip, VaultGearData data) {
        data.getFirstValue(ModGearAttributes.ETCHING).ifPresent(etchingSet -> {
            EtchingConfig.Etching etchingConfig = ModConfigs.ETCHING.getEtchingConfig((EtchingSet<?>)((Object)etchingSet));
            if (etchingConfig != null) {
                MutableComponent etchingCmp = new TextComponent(etchingConfig.getName()).m_130948_(Style.f_131099_.m_131148_(etchingConfig.getComponentColor()));
                tooltip.add((Component)new TextComponent("Etching: ").m_130940_(ChatFormatting.RED).m_7220_((Component)etchingCmp));
            }
        });
    }

    default public void addTooltipGearModel(VaultGearData data, ItemStack stack, List<Component> tooltip) {
        data.getFirstValue(ModGearAttributes.GEAR_MODEL).flatMap(modelId -> ModDynamicModels.REGISTRIES.getModel(stack.m_41720_(), (ResourceLocation)modelId)).ifPresent(gearModel -> {
            Item patt7655$temp = stack.m_41720_();
            if (patt7655$temp instanceof VaultGearItem) {
                VaultGearItem gearItem = (VaultGearItem)patt7655$temp;
                String name = gearModel.getDisplayName();
                if (gearModel instanceof ArmorPieceModel) {
                    ArmorPieceModel modelPiece = (ArmorPieceModel)gearModel;
                    name = modelPiece.getArmorModel().getDisplayName();
                }
                VaultGearRarity rollRarity = ModConfigs.GEAR_MODEL_ROLL_RARITIES.getRarityOf(gearItem, gearModel.getId());
                MutableComponent modelTooltip = new TextComponent("Model: ").m_130944_(new ChatFormatting[0]).m_7220_((Component)new TextComponent(name).m_130948_(Style.f_131099_.m_178520_(rollRarity.getColor().m_131265_())));
                tooltip.add((Component)modelTooltip);
            }
        });
    }

    default public void addTooltipRarity(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
        switch (state) {
            case UNIDENTIFIED: {
                data.getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE).flatMap(ModConfigs.VAULT_GEAR_TYPE_CONFIG::getRollPool).ifPresent(pool -> tooltip.add((Component)new TextComponent("Roll: ").m_7220_((Component)new TextComponent(pool.getName()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)pool.getColor()))))));
                break;
            }
            case IDENTIFIED: {
                MutableComponent rarityText = new TextComponent("Rarity: ").m_7220_((Component)data.getRarity().getDisplayName().m_6881_().m_130948_(Style.f_131099_.m_131148_(data.getRarity().getColor())));
                tooltip.add((Component)rarityText);
            }
        }
    }

    default public void addTooltipItemLevel(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
        if (VaultBarOverlay.vaultLevel >= data.getItemLevel()) {
            tooltip.add((Component)new TextComponent("Level: ").m_7220_((Component)new TextComponent("" + data.getItemLevel()).m_6270_(Style.f_131099_.m_178520_(11583738))));
        } else {
            tooltip.add((Component)new TextComponent("Requires Level: ").m_130940_(ChatFormatting.RED).m_7220_((Component)new TextComponent("" + data.getItemLevel()).m_130940_(ChatFormatting.RED)));
        }
    }

    default public void addTooltipCraftingPotential(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
        if (state != VaultGearState.IDENTIFIED) {
            return;
        }
        data.getFirstValue(ModGearAttributes.CRAFTING_POTENTIAL).ifPresent(craftingPotential -> {
            TextComponent potential = new TextComponent(String.valueOf(craftingPotential));
            if (craftingPotential > 0) {
                potential.m_130948_(Style.f_131099_.m_178520_(16757593));
            } else {
                potential.m_130940_(ChatFormatting.RED);
            }
            tooltip.add((Component)new TextComponent("Crafting Potential: ").m_7220_((Component)potential));
        });
    }

    default public void addTooltipToolCapacity(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
        if (state != VaultGearState.IDENTIFIED) {
            return;
        }
        data.getFirstValue(ModGearAttributes.TOOL_CAPACITY).ifPresent(craftingPotential -> {
            TextComponent potential = new TextComponent(String.valueOf(craftingPotential));
            if (craftingPotential > 0) {
                potential.m_130948_(Style.f_131099_.m_178520_(16757593));
            } else {
                potential.m_130940_(ChatFormatting.RED);
            }
            tooltip.add((Component)new TextComponent("Capacity: ").m_7220_((Component)potential));
        });
    }

    default public Component addTooltipEmptyAffixes(VaultGearModifier.AffixType type) {
        return new TextComponent("\u25a0 empty %s".formatted(type.name().toLowerCase(Locale.ROOT))).m_130940_(ChatFormatting.GRAY);
    }

    default public Component addTooltipDots(int amount, ChatFormatting formatting) {
        return new TextComponent("\u2b22 ".repeat(Math.max(0, amount))).m_130940_(formatting);
    }

    default public void addTooltipDurability(List<Component> tooltip, ItemStack stack) {
        if (VaultGearItem.of(stack).isBroken(stack)) {
            tooltip.add((Component)new TextComponent("Durability: ").m_7220_((Component)new TextComponent("BROKEN").m_130940_(ChatFormatting.RED)));
        } else if (stack.m_41763_() && stack.m_41776_() > 0) {
            tooltip.add((Component)new TextComponent("Durability: ").m_7220_((Component)new TextComponent("%d/%d".formatted(stack.m_41776_() - stack.m_41773_(), stack.m_41776_())).m_130940_(ChatFormatting.GRAY)));
        }
    }
}

