/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.trinket.effects;

import com.google.gson.annotations.Expose;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.TrinketHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ExplosionBlockPreventionTrinket
extends TrinketEffect<Config> {
    public static final float CHECK_SIZE = 16.0f;
    float chance;

    public ExplosionBlockPreventionTrinket(ResourceLocation name, float chance) {
        super(name);
        this.chance = chance;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onExplosion(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        if (explosion.m_46081_().isEmpty()) {
            return;
        }
        AABB gatherBox = AABB.m_165882_((Vec3)explosion.getPosition(), (double)16.0, (double)16.0, (double)16.0);
        for (Player player : event.getWorld().m_45955_(TargetingConditions.m_148353_(), null, gatherBox)) {
            for (TrinketHelper.TrinketStack<ExplosionBlockPreventionTrinket> trinketStack : TrinketHelper.getTrinkets((LivingEntity)player, ExplosionBlockPreventionTrinket.class)) {
                if (!trinketStack.isUsable(player)) continue;
                explosion.m_46080_();
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (TrinketHelper.TrinketStack trinketStack : TrinketHelper.getTrinkets((LivingEntity)player, ExplosionBlockPreventionTrinket.class)) {
                Entity hitBy;
                if (!trinketStack.isUsable(player) || !((hitBy = event.getSource().m_7640_()) instanceof Arrow)) continue;
                Arrow projectile = (Arrow)hitBy;
                if (!(player.m_21187_().nextFloat() <= ((Config)((ExplosionBlockPreventionTrinket)((Object)trinketStack.trinket())).getConfig()).getChance())) continue;
                player.f_19853_.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11791_, SoundSource.BLOCKS, 0.2f, 1.0f);
                event.setCanceled(true);
            }
        }
    }

    @Override
    public Class<Config> getConfigClass() {
        return Config.class;
    }

    @Override
    public Config getDefaultConfig() {
        return new Config(this.chance);
    }

    public static class Config
    extends TrinketEffect.Config {
        @Expose
        private float chance;

        public Config(float chance) {
            this.chance = chance;
        }

        public float getChance() {
            return this.chance;
        }
    }
}

