/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.trinket.effects;

import com.google.common.collect.Lists;
import com.google.gson.annotations.Expose;
import iskallia.vault.block.entity.base.HunterHiddenTileEntity;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.custom.EffectGearAttribute;
import iskallia.vault.gear.trinket.GearAttributeTrinket;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.network.message.ClientboundNightVisionGogglesParticlesMessage;
import iskallia.vault.skill.ability.effect.spi.HunterAbility;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;

public class NightVisionTrinket
extends TrinketEffect<Config>
implements GearAttributeTrinket {
    private final MobEffect effect;
    private final int addedAmplifier;
    private final float radius;
    private static final List<TilePredicate> filters = List.of(TilePredicate.of("the_vault:wooden_chest{Hidden:0b}", true).orElseThrow(), TilePredicate.of("the_vault:gilded_strongbox{Hidden:0b}", true).orElseThrow(), TilePredicate.of("the_vault:gilded_chest{Hidden:0b}", true).orElseThrow(), TilePredicate.of("the_vault:ornate_strongbox{Hidden:0b}", true).orElseThrow(), TilePredicate.of("the_vault:ornate_chest{Hidden:0b}", true).orElseThrow(), TilePredicate.of("the_vault:coin_pile{Hidden:0b}", true).orElseThrow(), TilePredicate.of("the_vault:living_strongbox{Hidden:0b}", true).orElseThrow(), TilePredicate.of("the_vault:living_chest{Hidden:0b}", true).orElseThrow());

    public NightVisionTrinket(ResourceLocation name, MobEffect effect, int addedAmplifier, float radius) {
        super(name);
        this.effect = effect;
        this.addedAmplifier = addedAmplifier;
        this.radius = radius;
    }

    @Override
    public Class<Config> getConfigClass() {
        return Config.class;
    }

    @Override
    public Config getDefaultConfig() {
        return new Config(this.effect.getRegistryName(), this.addedAmplifier, this.radius);
    }

    @Override
    public List<VaultGearAttributeInstance<?>> getAttributes() {
        Config cfg = (Config)this.getConfig();
        if (cfg.getEffect() == null) {
            return List.of();
        }
        return Lists.newArrayList((Object[])new VaultGearAttributeInstance[]{new VaultGearAttributeInstance<EffectGearAttribute>(ModGearAttributes.EFFECT, new EffectGearAttribute(cfg.getEffect(), cfg.getAddedAmplifier()))});
    }

    protected void forEachTile(Level world, Player player, double radius, Consumer<PartialTile> consumer) {
        double radiusSq = radius * radius;
        int iRadius = Mth.m_14165_((double)radius);
        Vec3i radVec = new Vec3i(iRadius, iRadius, iRadius);
        ChunkPos posMin = new ChunkPos(player.m_142538_().m_141950_(radVec));
        ChunkPos posMax = new ChunkPos(player.m_142538_().m_141952_(radVec));
        for (int xx = posMin.f_45578_; xx <= posMax.f_45578_; ++xx) {
            for (int zz = posMin.f_45579_; zz <= posMax.f_45579_; ++zz) {
                LevelChunk ch = world.m_7726_().m_7131_(xx, zz);
                if (ch == null) continue;
                ch.m_62954_().forEach((pos, tile) -> {
                    if (tile != null && pos.m_123331_((Vec3i)player.m_142538_()) <= radiusSq) {
                        consumer.accept(PartialTile.at((BlockGetter)world, pos));
                    }
                });
            }
        }
    }

    public boolean shouldHighlightTile(PartialTile tile) {
        return filters.stream().anyMatch(filter -> filter.test(tile));
    }

    protected List<HighlightPosition> selectPositions(ServerLevel world, ServerPlayer player, double radius) {
        ArrayList<HighlightPosition> result = new ArrayList<HighlightPosition>();
        this.forEachTile((Level)world, (Player)player, radius, tile -> {
            AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
            for (HunterAbility ability : abilities.getAll(HunterAbility.class, serverPlayer -> true)) {
                HunterHiddenTileEntity hiddenTile;
                if (ability.getParent().getId().equals("Hunter_Base") || !ability.getFilters().stream().anyMatch(filter -> filter.test((PartialTile)tile)) || !this.shouldHighlightTile((PartialTile)tile)) continue;
                if (tile instanceof HunterHiddenTileEntity && (hiddenTile = (HunterHiddenTileEntity)((Object)tile)).isHidden()) {
                    return;
                }
                result.add(new HighlightPosition(tile.getPos(), ability.getParent().getId()));
                break;
            }
        });
        return result;
    }

    @Override
    public void onWornTick(LivingEntity entity, ItemStack stack) {
        super.onWornTick(entity, stack);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (ServerVaults.get(player.f_19853_).isEmpty()) {
                return;
            }
            Optional<TrinketEffect<?>> trinketEffect = TrinketItem.getTrinket(stack);
            if (trinketEffect.isPresent()) {
                if (!trinketEffect.get().isUsable(stack, (Player)player)) {
                    return;
                }
                if (player.f_19797_ % 10 != 0) {
                    return;
                }
                Config cfg = (Config)this.getConfig();
                float radius = AreaOfEffectHelper.adjustAreaOfEffect((LivingEntity)player, cfg.radius);
                this.selectPositions((ServerLevel)player.f_19853_, player, radius).forEach(highlightPosition -> ModNetwork.CHANNEL.sendTo((Object)new ClientboundNightVisionGogglesParticlesMessage(highlightPosition.blockPos().m_123341_(), highlightPosition.blockPos().m_123342_(), highlightPosition.blockPos().m_123343_(), 30.0, 0.0, 0.0, highlightPosition.type), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT));
            }
        }
    }

    public static class Config
    extends TrinketEffect.Config {
        @Expose
        private ResourceLocation effect;
        @Expose
        private int addedAmplifier;
        @Expose
        private float radius;

        public Config(ResourceLocation effect, int addedAmplifier, float radius) {
            this.effect = effect;
            this.addedAmplifier = addedAmplifier;
            this.radius = radius;
        }

        public MobEffect getEffect() {
            return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(this.effect);
        }

        public int getAddedAmplifier() {
            return this.addedAmplifier;
        }

        public float getRadius() {
            return this.radius;
        }
    }

    public record HighlightPosition(BlockPos blockPos, String type) {
    }
}

