/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.init;

import iskallia.vault.VaultMod;
import iskallia.vault.core.SkyVaultsChunkGenerator;
import iskallia.vault.core.world.generator.DummyChunkGenerator;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModStructures;
import iskallia.vault.world.gen.decorator.BreadcrumbFeature;
import iskallia.vault.world.gen.decorator.OverworldOreFeature;
import iskallia.vault.world.gen.structure.ArchitectEventStructure;
import iskallia.vault.world.gen.structure.ArenaStructure;
import iskallia.vault.world.gen.structure.FinalVaultLobbyStructure;
import iskallia.vault.world.gen.structure.IRegistryIdentifiable;
import iskallia.vault.world.gen.structure.RaidChallengeStructure;
import iskallia.vault.world.gen.structure.VaultStructure;
import iskallia.vault.world.gen.structure.VaultTroveStructure;
import java.util.Arrays;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.event.RegistryEvent;

public class ModFeatures {
    public static Holder<VaultStructure.Feature> VAULT_FEATURE;
    public static Holder<ArchitectEventStructure.Feature> ARCHITECT_EVENT_FEATURE;
    public static Holder<RaidChallengeStructure.Feature> RAID_CHALLENGE_FEATURE;
    public static Holder<VaultTroveStructure.Feature> VAULT_TROVE_FEATURE;
    public static Holder<FinalVaultLobbyStructure.Feature> FINAL_VAULT_LOBBY_FEATURE;
    public static Holder<ArenaStructure.Feature> ARENA_FEATURE;
    public static Holder<ConfiguredFeature<?, ?>> CONFIGURED_BREADCRUMB_CHEST;
    public static Holder<ConfiguredFeature<?, ?>> CONFIGURED_CHROMATIC_IRON_ORE_SMALL;
    public static Holder<ConfiguredFeature<?, ?>> CONFIGURED_CHROMATIC_IRON_ORE_LARGE;
    public static Holder<ConfiguredFeature<?, ?>> CONFIGURED_VAULT_STONE;
    public static Holder<PlacedFeature> PLACED_BREADCRUMB_CHEST;
    public static Holder<PlacedFeature> PLACED_CHROMATIC_IRON_ORE_SMALL;
    public static Holder<PlacedFeature> PLACED_CHROMATIC_IRON_ORE_LARGE;
    public static Holder<PlacedFeature> PLACED_VAULT_STONE;

    public static void registerStructureFeatures() {
        VAULT_FEATURE = ModFeatures.register("vault", ModStructures.VAULT_STAR.configured());
        ARENA_FEATURE = ModFeatures.register("arena", ModStructures.ARENA.configured(new JigsawConfiguration(ArenaStructure.Pools.START, 5)));
        ARCHITECT_EVENT_FEATURE = ModFeatures.register("architect_event", ModStructures.ARCHITECT_EVENT.configured());
        RAID_CHALLENGE_FEATURE = ModFeatures.register("raid_challenge", ModStructures.RAID_CHALLENGE.configured());
        VAULT_TROVE_FEATURE = ModFeatures.register("trove", ModStructures.VAULT_TROVE.configured());
        FINAL_VAULT_LOBBY_FEATURE = ModFeatures.register("final_vault_lobby", ModStructures.FINAL_VAULT_LOBBY.configured());
        Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)VaultMod.id("dummy"), DummyChunkGenerator.CODEC);
        Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)VaultMod.id("sky_vaults"), SkyVaultsChunkGenerator.CODEC);
    }

    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        BreadcrumbFeature.register(event);
        OverworldOreFeature.register(event);
        CONFIGURED_BREADCRUMB_CHEST = ModFeatures.register("breadcrumb_chest", BreadcrumbFeature.INSTANCE, NoneFeatureConfiguration.f_67816_);
        CONFIGURED_CHROMATIC_IRON_ORE_SMALL = ModFeatures.register("chromatic_iron_ore_small", OverworldOreFeature.INSTANCE, new OreConfiguration(OreFeatures.f_195073_, ModBlocks.CHROMATIC_IRON_ORE.m_49966_(), 12, 0.25f));
        CONFIGURED_CHROMATIC_IRON_ORE_LARGE = ModFeatures.register("chromatic_iron_ore_large", OverworldOreFeature.INSTANCE, new OreConfiguration(OreFeatures.f_195073_, ModBlocks.CHROMATIC_IRON_ORE.m_49966_(), 36, 0.25f));
        CONFIGURED_VAULT_STONE = ModFeatures.register("vault_stone", OverworldOreFeature.INSTANCE, new OreConfiguration(OreFeatures.f_195073_, ModBlocks.VAULT_STONE.m_49966_(), 64));
        PLACED_BREADCRUMB_CHEST = ModFeatures.register("breadcrumb_chest", CONFIGURED_BREADCRUMB_CHEST, new PlacementModifier[0]);
        PLACED_CHROMATIC_IRON_ORE_SMALL = ModFeatures.register("placed_chromatic_iron_ore_small", CONFIGURED_CHROMATIC_IRON_ORE_SMALL, new PlacementModifier[]{RarityFilter.m_191900_((int)8), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)-32)), InSquarePlacement.m_191715_()});
        PLACED_CHROMATIC_IRON_ORE_LARGE = ModFeatures.register("placed_chromatic_iron_ore_large", CONFIGURED_CHROMATIC_IRON_ORE_LARGE, new PlacementModifier[]{RarityFilter.m_191900_((int)8), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)-32)), InSquarePlacement.m_191715_()});
        PLACED_VAULT_STONE = ModFeatures.register("placed_vault_stone", CONFIGURED_VAULT_STONE, new PlacementModifier[]{RarityFilter.m_191900_((int)10), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)-5)), InSquarePlacement.m_191715_()});
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<?, ?>> register(String name, F feature, FC config) {
        return BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)VaultMod.id(name), (Object)new ConfiguredFeature(feature, config));
    }

    private static <SF extends ConfiguredStructureFeature<FC, F>, FC extends FeatureConfiguration, F extends StructureFeature<FC>> Holder<SF> register(String name, SF feature) {
        if (feature instanceof IRegistryIdentifiable) {
            ((IRegistryIdentifiable)feature).setId(VaultMod.id(name));
        }
        return BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)VaultMod.id(name), feature);
    }

    public static Holder<PlacedFeature> register(String name, Holder<? extends ConfiguredFeature<?, ?>> configured, PlacementModifier ... modifiers) {
        return BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)VaultMod.id(name), (Object)new PlacedFeature(Holder.m_205706_(configured), Arrays.asList(modifiers)));
    }
}

