/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.init;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import iskallia.vault.VaultMod;
import iskallia.vault.block.CryoChamberBlock;
import iskallia.vault.block.DungeonDoorBlock;
import iskallia.vault.block.EasterEggBlock;
import iskallia.vault.block.PlaceholderBlock;
import iskallia.vault.block.TreasureDoorBlock;
import iskallia.vault.block.VaultOreBlock;
import iskallia.vault.block.model.BloodOrbModel;
import iskallia.vault.block.model.BountyBlockExclamationModel;
import iskallia.vault.block.model.BountyBlockQuestionModel;
import iskallia.vault.block.model.HeraldControllerModel;
import iskallia.vault.block.model.PylonCrystalModel;
import iskallia.vault.block.model.WendarrChainModel;
import iskallia.vault.block.model.WendarrSparkSourceModel;
import iskallia.vault.block.render.AncientCopperConduitRenderer;
import iskallia.vault.block.render.AngelBlockRenderer;
import iskallia.vault.block.render.ArtifactProjectorRenderer;
import iskallia.vault.block.render.IdentificationStandRenderer;
import iskallia.vault.block.render.PotionModifierDiscoveryRenderer;
import iskallia.vault.block.render.SparkRenderer;
import iskallia.vault.block.render.VaultEnchanterRenderer;
import iskallia.vault.block.render.VelvetBedRenderer;
import iskallia.vault.client.util.ClientScheduler;
import iskallia.vault.client.util.color.ColorUtil;
import iskallia.vault.config.CharmConfig;
import iskallia.vault.config.gear.VaultGearTypeConfig;
import iskallia.vault.core.event.ClientEvents;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.entity.model.BossProtectionCatalystModel;
import iskallia.vault.entity.model.FireballModel;
import iskallia.vault.entity.model.ModModelLayers;
import iskallia.vault.entity.model.PiercingJavelinModel;
import iskallia.vault.entity.model.ScatterJavelinModel;
import iskallia.vault.entity.model.ScrappyJavelinModel;
import iskallia.vault.entity.model.SightJavelinModel;
import iskallia.vault.etching.EtchingRegistry;
import iskallia.vault.etching.EtchingSet;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.charm.AttributeCharm;
import iskallia.vault.gear.charm.CharmEffect;
import iskallia.vault.gear.charm.CharmEffectRegistry;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.TrinketEffectRegistry;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.AugmentItem;
import iskallia.vault.item.ItemDrillArrow;
import iskallia.vault.item.LegacyMagnetItem;
import iskallia.vault.item.bottle.BottleItem;
import iskallia.vault.item.tool.JewelItem;
import iskallia.vault.research.StageManager;
import iskallia.vault.research.type.Research;
import iskallia.vault.util.calc.BlockChanceHelper;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModModels {
    public static void setupRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.VAULT_PORTAL, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.TREASURE_DOOR, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.DUNGEON_DOOR, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.VAULT_ALTAR, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.VAULT_ARTIFACT, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.MVP_CROWN, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.GOD_ALTAR, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.VAULT_GLASS, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.SKILL_ALTAR, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.MOB_BARRIER, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.FINAL_VAULT_FRAME, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.ELITE_SPAWNER, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.SUGAR_PLUM_FAIRY_FLOWER, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.CRYSTAL_CLUSTER, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.LARGE_CRYSTAL_BUD, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.MEDIUM_CRYSTAL_BUD, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.SMALL_CRYSTAL_BUD, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.MONOLITH, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.BLACK_MARKET, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.ANIMAL_JAR, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.ETERNAL_PEDESTAL, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.MODIFIER_DISCOVERY, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.TOTEM_PLAYER_HEALTH, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.TOTEM_MOB_DAMAGE, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.TOTEM_PLAYER_DAMAGE, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.VAULT_JEWEL_APPLICATION_STATION, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.GILDED_SCONCE, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.GILDED_SCONCE_WALL, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.SPARK, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.CONVERTED_SPARK, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.GILDED_CANDELABRA, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.ARTIFACT_PROJECTOR_BLOCK, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.ANCIENT_COPPER_TRAPDOOR, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.ANCIENT_COPPER_TRAPDOOR_EXPOSED, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.ANCIENT_COPPER_TRAPDOOR_WEATHERED, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.ANCIENT_COPPER_TRAPDOOR_OXIDIZED, (RenderType)RenderType.m_110463_());
        ModModels.setRenderLayers(ModBlocks.VAULT_SWEETS, RenderType.m_110451_(), RenderType.m_110466_());
        ModModels.setRenderLayers(ModBlocks.DIVINE_ALTAR, RenderType.m_110463_(), RenderType.m_110466_());
        ModModels.setRenderLayers(ModBlocks.VAULT_JEWEL_CUTTING_STATION, RenderType.m_110463_(), RenderType.m_110466_());
        ModModels.setRenderLayers(ModBlocks.ALCHEMY_ARCHIVE, RenderType.m_110451_(), RenderType.m_110466_());
        ModModels.setRenderLayers((Block)ModBlocks.ALCHEMY_TABLE, RenderType.m_110463_(), RenderType.m_110466_());
        ModModels.setRenderLayers(ModBlocks.CRYO_CHAMBER, RenderType.m_110451_(), RenderType.m_110466_());
        ModModels.setRenderLayers(ModBlocks.HOURGLASS, RenderType.m_110451_(), RenderType.m_110466_());
        ModModels.setRenderLayers(ModBlocks.STABILIZER, RenderType.m_110451_(), RenderType.m_110466_());
        ModModels.setRenderLayers(ModBlocks.VAULT_CHARM_CONTROLLER_BLOCK, RenderType.m_110451_(), RenderType.m_110466_());
        ModModels.setRenderLayers(ModBlocks.CRAKE_PEDESTAL, RenderType.m_110466_());
        ModModels.setRenderLayers(ModBlocks.WENDARR_JEWEL_GLASS, RenderType.m_110466_());
        ModModels.setRenderLayers(ModBlocks.WENDARR_JEWEL_GLASS_PANE, RenderType.m_110466_());
        ModModels.setRenderLayers(ModBlocks.VELARA_VINE, RenderType.m_110463_());
    }

    private static void setRenderLayers(Block block, RenderType ... renderTypes) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, (Predicate)Predicates.in(Arrays.asList(renderTypes)));
    }

    public static void registerItemColors(ItemColors colors) {
        colors.m_92689_((stack, tintLayer) -> {
            if (tintLayer > 0) {
                GearDataCache clientCache = GearDataCache.of(stack);
                if (clientCache.getState() == VaultGearState.UNIDENTIFIED) {
                    VaultGearTypeConfig.RollType type = Optional.ofNullable(clientCache.getGearRollType()).flatMap(ModConfigs.VAULT_GEAR_TYPE_CONFIG::getRollPool).orElse(null);
                    if (type != null) {
                        return ColorUtil.blendColors(type.getColor(), -1, 0.8f);
                    }
                }
                return -1;
            }
            return VaultGearHelper.getGearColor(stack);
        }, new ItemLike[]{ModItems.HELMET, ModItems.CHESTPLATE, ModItems.LEGGINGS, ModItems.BOOTS, ModItems.AXE, ModItems.SWORD, ModItems.SHIELD, ModItems.IDOL_BENEVOLENT, ModItems.IDOL_OMNISCIENT, ModItems.IDOL_TIMEKEEPER, ModItems.IDOL_MALEVOLENCE, ModItems.MAGNET, ModItems.WAND, ModItems.FOCUS});
        colors.m_92689_((stack, tintIndex) -> tintIndex == 0 ? JewelItem.getColor(stack) : -1, new ItemLike[]{ModItems.JEWEL});
        colors.m_92689_((stack, tintIndex) -> tintIndex == 1 ? AugmentItem.getColor(stack) : -1, new ItemLike[]{ModItems.AUGMENT});
        colors.m_92689_((stack, tintIndex) -> {
            if (tintIndex == 1) {
                return BottleItem.getColor(stack);
            }
            if (tintIndex == 2) {
                return BottleItem.getEffectColor(stack);
            }
            return -1;
        }, new ItemLike[]{ModItems.BOTTLE});
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(PylonCrystalModel.MODEL_LOCATION, PylonCrystalModel::createBodyLayer);
        event.registerLayerDefinition(ScrappyJavelinModel.MODEL_LOCATION, ScrappyJavelinModel::createBodyLayer);
        event.registerLayerDefinition(SightJavelinModel.MODEL_LOCATION, SightJavelinModel::createBodyLayer);
        event.registerLayerDefinition(ScatterJavelinModel.MODEL_LOCATION, ScatterJavelinModel::createBodyLayer);
        event.registerLayerDefinition(PiercingJavelinModel.MODEL_LOCATION, PiercingJavelinModel::createBodyLayer);
        event.registerLayerDefinition(FireballModel.MODEL_LOCATION, FireballModel::createBodyLayer);
        event.registerLayerDefinition(BossProtectionCatalystModel.MODEL_LOCATION, BossProtectionCatalystModel::createBodyLayer);
        event.registerLayerDefinition(HeraldControllerModel.MODEL_LOCATION, HeraldControllerModel::createBodyLayer);
        event.registerLayerDefinition(BloodOrbModel.LAYER_LOCATION, BloodOrbModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.ANGEL_BLOCK_EYE, AngelBlockRenderer::createEyeLayer);
        event.registerLayerDefinition(ModModelLayers.ANGEL_BLOCK_WIND, AngelBlockRenderer::createWindLayer);
        event.registerLayerDefinition(ModModelLayers.ANGEL_BLOCK_CAGE, AngelBlockRenderer::createCageLayer);
        event.registerLayerDefinition(ModModelLayers.ANCIENT_COPPER_CONDUIT_BLOCK_EYE, AncientCopperConduitRenderer::createEyeLayer);
        event.registerLayerDefinition(ModModelLayers.ANCIENT_COPPER_CONDUIT_BLOCK_WIND, AncientCopperConduitRenderer::createWindLayer);
        event.registerLayerDefinition(ModModelLayers.ANCIENT_COPPER_CONDUIT_BLOCK_CAGE, AncientCopperConduitRenderer::createCageLayer);
        event.registerLayerDefinition(BountyBlockExclamationModel.LAYER_LOCATION, BountyBlockExclamationModel::createBodyLayer);
        event.registerLayerDefinition(BountyBlockQuestionModel.LAYER_LOCATION, BountyBlockQuestionModel::createBodyLayer);
        event.registerLayerDefinition(VelvetBedRenderer.HEAD_LAYER_LOCATION, VelvetBedRenderer::createHeadLayer);
        event.registerLayerDefinition(VelvetBedRenderer.FOOT_LAYER_LOCATION, VelvetBedRenderer::createFootLayer);
        event.registerLayerDefinition(WendarrSparkSourceModel.LAYER_LOCATION, WendarrSparkSourceModel::createBodyLayer);
        event.registerLayerDefinition(WendarrChainModel.LAYER_LOCATION, WendarrChainModel::createBodyLayer);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void stitchTextures(TextureStitchEvent.Pre event) {
        if (!event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            return;
        }
        event.addSprite(PylonCrystalModel.TEXTURE_LOCATION);
        event.addSprite(HeraldControllerModel.TEXTURE_LOCATION);
        event.addSprite(HeraldControllerModel.FILLED_TEXTURE_LOCATION);
        event.addSprite(VaultEnchanterRenderer.BOOK_TEXTURE);
        event.addSprite(ArtifactProjectorRenderer.BOOK_TEXTURE);
        event.addSprite(IdentificationStandRenderer.BOOK_TEXTURE);
        event.addSprite(PotionModifierDiscoveryRenderer.BOOK_TEXTURE.m_119203_());
        event.addSprite(AngelBlockRenderer.ANGEL_OUTTER.m_119203_());
        event.addSprite(AngelBlockRenderer.ANGEL_OUTTER2.m_119203_());
        event.addSprite(AngelBlockRenderer.ANGEL_CENTER.m_119203_());
        event.addSprite(AngelBlockRenderer.ANGEL_WIND.m_119203_());
        event.addSprite(AngelBlockRenderer.ANGEL_WIND_VERTICAL.m_119203_());
        event.addSprite(AncientCopperConduitRenderer.CONDUIT_OUTTER.m_119203_());
        event.addSprite(AncientCopperConduitRenderer.CONDUIT_OUTTER2.m_119203_());
        event.addSprite(AncientCopperConduitRenderer.CONDUIT_CENTER.m_119203_());
        event.addSprite(AncientCopperConduitRenderer.CONDUIT_WIND.m_119203_());
        event.addSprite(AncientCopperConduitRenderer.CONDUIT_WIND_VERTICAL.m_119203_());
        event.addSprite(BountyBlockExclamationModel.TEXTURE_LOCATION);
        event.addSprite(BountyBlockQuestionModel.TEXTURE_LOCATION);
        event.addSprite(VelvetBedRenderer.TEXTURE_LOCATION);
        event.addSprite(SparkRenderer.TEXTURE_LOCATION);
        event.addSprite(WendarrSparkSourceModel.TEXTURE_LOCATION);
        event.addSprite(WendarrChainModel.TEXTURE_LOCATION);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void stitchParticleTextures(TextureStitchEvent.Pre event) {
        if (!event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118260_)) {
            return;
        }
        CharmConfig.LOC.forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
    }

    public static class ItemProperty {
        public static ItemPropertyFunction ETCHING = (stack, world, entity, seed) -> {
            EtchingSet<?> data = AttributeGearData.read(stack);
            EtchingSet etching = ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.ETCHING).orElse(null);
            if (etching == null) {
                return -1.0f;
            }
            return EtchingRegistry.getOrderedEntries().indexOf((Object)etching);
        };
        public static ItemPropertyFunction TRINKET = (stack, world, entity, seed) -> {
            TrinketEffect<?> data = AttributeGearData.read(stack);
            TrinketEffect trinket = ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.TRINKET_EFFECT).orElse(null);
            if (trinket == null) {
                return -1.0f;
            }
            return TrinketEffectRegistry.getOrderedEntries().indexOf((Object)trinket);
        };
        public static ItemPropertyFunction CHARM = (stack, world, entity, seed) -> {
            CharmEffect<?> data = AttributeGearData.read(stack);
            CharmEffect charm = ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.CHARM_EFFECT).orElse(null);
            if (!(charm instanceof AttributeCharm)) {
                return -1.0f;
            }
            AttributeCharm attributeCharm = (AttributeCharm)charm;
            return CharmEffectRegistry.getOrderedEntries().indexOf((Object)charm);
        };
        public static ItemPropertyFunction PLACEHOLDER_TYPE = (stack, world, entity, seed) -> {
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                return -1.0f;
            }
            PlaceholderBlock.Type type = PlaceholderBlock.Type.fromString(nbt.m_128461_("type"));
            if (type == null) {
                return -1.0f;
            }
            return type.ordinal();
        };
        public static ItemPropertyFunction VAULT_ORE_TYPE = (stack, world, entity, seed) -> {
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                return -1.0f;
            }
            VaultOreBlock.Type type = VaultOreBlock.Type.fromString(nbt.m_128461_("type"));
            if (type == null) {
                return -1.0f;
            }
            return type.ordinal();
        };
        public static ItemPropertyFunction EASTER_EGG_TYPE = (stack, world, entity, seed) -> {
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                return -1.0f;
            }
            EasterEggBlock.Color color = EasterEggBlock.Color.fromString(nbt.m_128461_("color"));
            if (color == null) {
                return -1.0f;
            }
            return color.ordinal();
        };
        public static ItemPropertyFunction TREASURE_DOOR_TYPE = (stack, world, entity, seed) -> {
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                return -1.0f;
            }
            TreasureDoorBlock.Type type = TreasureDoorBlock.Type.fromString(nbt.m_128461_("type"));
            if (type == null) {
                return -1.0f;
            }
            return type.ordinal();
        };
        public static ItemPropertyFunction DUNGEON_DOOR_TYPE = (stack, world, entity, seed) -> {
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                return -1.0f;
            }
            DungeonDoorBlock.Type type = DungeonDoorBlock.Type.fromString(nbt.m_128461_("type"));
            if (type == null) {
                return -1.0f;
            }
            return type.ordinal();
        };
        public static ItemPropertyFunction GOD_ITEM_TYPE = (stack, world, entity, seed) -> {
            VaultGod type;
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null || (type = VaultGod.fromName(nbt.m_128461_("type"))) == null) {
                return (ClientScheduler.INSTANCE.getTickCount() >> 4) % (long)VaultGod.values().length;
            }
            return type.ordinal();
        };
        public static ItemPropertyFunction GOD_ALTAR_TYPE = (stack, world, entity, seed) -> {
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                return -1.0f;
            }
            VaultGod god = VaultGod.fromName(nbt.m_128461_("god"));
            if (god == null) {
                return -1.0f;
            }
            return god.ordinal();
        };

        public static void register() {
            ItemProperty.registerItemProperty(ModItems.ETCHING, "etching", ETCHING);
            ItemProperty.registerItemProperty(ModItems.TRINKET, "trinket", TRINKET);
            ItemProperty.registerItemProperty(ModItems.SMALL_CHARM, "charm", CHARM);
            ItemProperty.registerItemProperty(ModItems.LARGE_CHARM, "charm", CHARM);
            ItemProperty.registerItemProperty(ModItems.GRAND_CHARM, "charm", CHARM);
            ItemProperty.registerItemProperty(ModItems.MAJESTIC_CHARM, "charm", CHARM);
            ItemProperty.registerItemProperty((Item)ModItems.SHIELD, "blocking", (stack, world, entity, seed) -> {
                Player player;
                if (entity instanceof Player && BlockChanceHelper.isPlayerBlocking(player = (Player)entity)) {
                    return 1.0f;
                }
                return entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f;
            });
            ItemProperties.register((Item)ModItems.DRILL_ARROW, (ResourceLocation)new ResourceLocation("tier"), (stack, world, entity, seed) -> (float)ItemDrillArrow.getArrowTier(stack).ordinal() / (float)ItemDrillArrow.ArrowTier.values().length);
            ItemProperties.register((Item)Item.m_41439_((Block)ModBlocks.CRYO_CHAMBER), (ResourceLocation)new ResourceLocation("type"), (stack, world, entity, seed) -> (float)stack.m_41773_() / (float)CryoChamberBlock.ChamberState.values().length);
            ItemProperties.register((Item)ModItems.VAULT_COMPASS, (ResourceLocation)new ResourceLocation("angle"), (ItemPropertyFunction)new CompassPropertyFunction());
            ItemProperties.register((Item)ModItems.BOTTLE, (ResourceLocation)new ResourceLocation("type"), (stack, level, entity, seed) -> BottleItem.getType(stack).orElse(BottleItem.Type.VIAL).ordinal());
            ItemProperties.register((Item)ModItems.BOTTLE, (ResourceLocation)new ResourceLocation("fill"), (stack, level, entity, seed) -> 1.0f - (float)stack.m_41773_() / (float)stack.m_41776_());
            ItemProperty.registerItemProperty(ModBlocks.PLACEHOLDER.m_5456_(), "placeholder_type", PLACEHOLDER_TYPE);
            ItemProperty.registerItemProperty(ModBlocks.TREASURE_DOOR.m_5456_(), "treasure_door_type", TREASURE_DOOR_TYPE);
            ItemProperty.registerItemProperty(ModBlocks.DUNGEON_DOOR.m_5456_(), "dungeon_door_type", DUNGEON_DOOR_TYPE);
            ItemProperty.registerItemProperty(ModItems.MAGNET, "magnet_perk", (stack, world, entity, seed) -> LegacyMagnetItem.getPerk(stack).ordinal());
            ItemProperties.registerGeneric((ResourceLocation)VaultMod.id("count"), (s, w, e, l) -> s.m_41613_());
            for (VaultOreBlock block : VaultOreBlock.ALL) {
                ItemProperty.registerItemProperty(block.m_5456_(), "vault_ore_type", VAULT_ORE_TYPE);
            }
            ItemProperty.registerItemProperty(ModBlocks.EASTER_EGG.m_5456_(), "easter_egg_type", EASTER_EGG_TYPE);
            ItemProperty.registerItemProperty(ModItems.GOD_BLESSING, "god_item_type", GOD_ITEM_TYPE);
            ItemProperty.registerItemProperty(ModItems.GOD_TOKEN, "god_item_type", GOD_ITEM_TYPE);
            ItemProperty.registerItemProperty(ModBlocks.GOD_ALTAR.m_5456_(), "god_altar_type", GOD_ALTAR_TYPE);
        }

        public static void registerOverrides() {
            ItemProperty.override(Items.f_42740_, new ResourceLocation("blocking"), (Function<ItemPropertyFunction, ItemPropertyFunction>)((Function)existing -> (stack, world, entity, seed) -> {
                Player player;
                if (entity instanceof Player && BlockChanceHelper.isPlayerBlocking(player = (Player)entity)) {
                    return 1.0f;
                }
                return existing.m_141951_(stack, world, entity, seed);
            }));
        }

        public static void registerItemProperty(Item item, String name, ItemPropertyFunction property) {
            ItemProperties.register((Item)item, (ResourceLocation)VaultMod.id(name), (ItemPropertyFunction)property);
        }

        public static void override(Item item, ResourceLocation key, Function<ItemPropertyFunction, ItemPropertyFunction> decorateFn) {
            ItemPropertyFunction existing = ItemProperties.m_117829_((Item)item, (ResourceLocation)key);
            if (existing != null) {
                ItemProperties.register((Item)item, (ResourceLocation)key, (ItemPropertyFunction)((ItemPropertyFunction)decorateFn.apply((Object)existing)));
            }
        }

        private static class CompassPropertyFunction
        implements ClampedItemPropertyFunction {
            private final ItemProperties.CompassWobble wobble = new ItemProperties.CompassWobble();
            private final ItemProperties.CompassWobble wobbleRandom = new ItemProperties.CompassWobble();

            private CompassPropertyFunction() {
            }

            public float m_142187_(ItemStack compass, @Nullable ClientLevel level, @Nullable LivingEntity livingEntity, int seed) {
                boolean researched;
                Level level2;
                if (!(livingEntity instanceof Player)) {
                    return 0.0f;
                }
                Player player = (Player)livingEntity;
                if (level == null && (level2 = livingEntity.f_19853_) instanceof ClientLevel) {
                    ClientLevel clientLevel;
                    level = clientLevel = (ClientLevel)level2;
                }
                BlockPos target = this.getCompassTarget(player, level, compass, seed);
                long gameTime = level.m_46467_();
                Research vaultCompass = ModConfigs.RESEARCHES.getByName("Vault Compass");
                boolean bl = researched = vaultCompass != null && StageManager.getResearchTree(player).isResearched(vaultCompass);
                if (target != null && player.m_20182_().m_82531_((double)target.m_123341_() + 0.5, player.m_20182_().m_7098_(), (double)target.m_123343_() + 0.5) > 1.0E-5 && researched) {
                    double yRotation = player.m_146908_();
                    yRotation = Mth.m_14109_((double)(yRotation / 360.0), (double)1.0);
                    double index = this.getAngleTo(Vec3.m_82512_((Vec3i)target), (Entity)player) / 6.2831854820251465;
                    if (this.wobble.m_117933_(gameTime)) {
                        this.wobble.m_117935_(gameTime, 0.5 - (yRotation - 0.25));
                    }
                    return Mth.m_14091_((float)((float)(index += this.wobble.f_117927_)), (float)1.0f);
                }
                if (this.wobbleRandom.m_117933_(gameTime)) {
                    this.wobbleRandom.m_117935_(gameTime, Math.random());
                }
                float randomRotation = (float)(this.wobbleRandom.f_117927_ + (double)((float)this.hash(seed) / 2.1474836E9f));
                return Mth.m_14091_((float)randomRotation, (float)1.0f);
            }

            @Nullable
            private BlockPos getCompassTarget(Player player, ClientLevel level, ItemStack compass, int seed) {
                return ClientVaults.getActive().flatMap(vault -> {
                    Listeners listeners = vault.get(Vault.LISTENERS);
                    if (listeners.contains(player.m_142081_())) {
                        return listeners.get(player.m_142081_()).getOptional(Listener.COMPASS_TARGET);
                    }
                    return Optional.empty();
                }).orElse(ClientEvents.COMPASS_PROPERTY.invoke(level, (LivingEntity)player, compass, seed, null).getTarget());
            }

            private int hash(int seed) {
                return seed * 1327217883;
            }

            private double getAngleTo(Vec3 portalPos, Entity player) {
                return Math.atan2(portalPos.m_7094_() - player.m_20189_(), portalPos.m_7096_() - player.m_20185_());
            }
        }
    }
}

