/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.init;

import iskallia.vault.VaultMod;
import iskallia.vault.init.ModDynamicModels;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;

public final class ModRelics {
    public static final Map<ResourceLocation, RelicRecipe> RECIPE_REGISTRY = new HashMap<ResourceLocation, RelicRecipe>();
    private static final Map<String, RelicRecipe> RECIPES_BY_NAME = new HashMap<String, RelicRecipe>();
    public static RelicRecipe EMPTY = new RelicRecipe("empty", VaultMod.id("empty"), new ResourceLocation[0]);
    public static RelicRecipe DRAGON = ModRelics.register("dragon", ModDynamicModels.Relics.DRAGON_RELIC.getId(), ModDynamicModels.Relics.DRAGON_BREATH.getId(), ModDynamicModels.Relics.DRAGON_CHEST.getId(), ModDynamicModels.Relics.DRAGON_FOOT.getId(), ModDynamicModels.Relics.DRAGON_HEAD.getId(), ModDynamicModels.Relics.DRAGON_TAIL.getId());
    public static RelicRecipe MINER = ModRelics.register("miner", ModDynamicModels.Relics.MINER_RELIC.getId(), ModDynamicModels.Relics.MINERS_LIGHT.getId(), ModDynamicModels.Relics.MINERS_DELIGHT.getId(), ModDynamicModels.Relics.PICKAXE_HANDLE.getId(), ModDynamicModels.Relics.PICKAXE_HEAD.getId(), ModDynamicModels.Relics.PICKAXE_TOOL.getId());
    public static RelicRecipe WARRIOR = ModRelics.register("warrior", ModDynamicModels.Relics.WARRIOR_RELIC.getId(), ModDynamicModels.Relics.WARRIORS_ARMOUR.getId(), ModDynamicModels.Relics.WARRIORS_CHARM.getId(), ModDynamicModels.Relics.SWORD_BLADE.getId(), ModDynamicModels.Relics.SWORD_HANDLE.getId(), ModDynamicModels.Relics.SWORD_STICK.getId());
    public static RelicRecipe RICHITY = ModRelics.register("richity", ModDynamicModels.Relics.RICHITY_RELIC.getId(), ModDynamicModels.Relics.DIAMOND_ESSENCE.getId(), ModDynamicModels.Relics.GOLD_ESSENCE.getId(), ModDynamicModels.Relics.MYSTIC_GEM_ESSENCE.getId(), ModDynamicModels.Relics.NETHERITE_ESSENCE.getId(), ModDynamicModels.Relics.PLATINUM_ESSENCE.getId());
    public static RelicRecipe TWITCH = ModRelics.register("twitch", ModDynamicModels.Relics.TWITCH_RELIC.getId(), ModDynamicModels.Relics.TWITCH_EMOTE_1.getId(), ModDynamicModels.Relics.TWITCH_EMOTE_2.getId(), ModDynamicModels.Relics.TWITCH_EMOTE_3.getId(), ModDynamicModels.Relics.TWITCH_EMOTE_4.getId(), ModDynamicModels.Relics.TWITCH_EMOTE_5.getId());
    public static RelicRecipe CUPCAKE = ModRelics.register("cupcake", ModDynamicModels.Relics.CUPCAKE_RELIC.getId(), ModDynamicModels.Relics.CUPCAKE_BLUE.getId(), ModDynamicModels.Relics.CUPCAKE_LIME.getId(), ModDynamicModels.Relics.CUPCAKE_PINK.getId(), ModDynamicModels.Relics.CUPCAKE_PURPLE.getId(), ModDynamicModels.Relics.CUPCAKE_RED.getId());
    public static RelicRecipe ELEMENTAL = ModRelics.register("elemental", ModDynamicModels.Relics.ELEMENTAL_RELIC.getId(), ModDynamicModels.Relics.ELEMENT_AIR.getId(), ModDynamicModels.Relics.ELEMENT_EARTH.getId(), ModDynamicModels.Relics.ELEMENT_FIRE.getId(), ModDynamicModels.Relics.ELEMENT_WATER.getId(), ModDynamicModels.Relics.ELEMENT_SPIRIT.getId());
    public static RelicRecipe NAZAR_BONCUGU = ModRelics.register("nazar", ModDynamicModels.Relics.NAZAR_BONCUGU.getId(), ModDynamicModels.Relics.SER.getId(), ModDynamicModels.Relics.KEM_GOZ.getId(), ModDynamicModels.Relics.KADER.getId(), ModDynamicModels.Relics.KISMET.getId(), ModDynamicModels.Relics.NAZARLIK.getId());

    public static Optional<RelicRecipe> getRelicOfFragment(ResourceLocation fragmentId) {
        for (RelicRecipe relicRecipe : RECIPE_REGISTRY.values()) {
            if (!relicRecipe.getFragments().contains(fragmentId)) continue;
            return Optional.of(relicRecipe);
        }
        return Optional.empty();
    }

    private static RelicRecipe register(String recipeName, ResourceLocation resultingRelic, ResourceLocation ... fragments) {
        RelicRecipe relicRecipe = new RelicRecipe(recipeName, resultingRelic, fragments);
        RECIPE_REGISTRY.put(resultingRelic, relicRecipe);
        RECIPES_BY_NAME.put(relicRecipe.getRecipeName(), relicRecipe);
        return relicRecipe;
    }

    public static class RelicRecipe
    implements Comparable<RelicRecipe> {
        private final String recipeName;
        private final ResourceLocation resultingRelic;
        private final Set<ResourceLocation> fragments;

        private RelicRecipe(String recipeName, ResourceLocation resultingRelic, ResourceLocation ... fragments) {
            this.recipeName = recipeName;
            this.resultingRelic = resultingRelic;
            this.fragments = new HashSet<ResourceLocation>(List.of(fragments));
        }

        public String getRecipeName() {
            return this.recipeName;
        }

        public ResourceLocation getResultingRelic() {
            return this.resultingRelic;
        }

        public Set<ResourceLocation> getFragments() {
            return this.fragments;
        }

        @Override
        public int compareTo(@Nonnull RelicRecipe that) {
            if (this == that) {
                return 0;
            }
            return this.resultingRelic.toString().compareTo(that.resultingRelic.toString());
        }

        public String toString() {
            return this.recipeName;
        }
    }

    public static class RelicProperty
    extends Property<RelicRecipe> {
        protected RelicProperty(String name) {
            super(name, RelicRecipe.class);
        }

        @Nonnull
        public Collection<RelicRecipe> m_6908_() {
            LinkedList<RelicRecipe> relicRecipes = new LinkedList<RelicRecipe>(RECIPE_REGISTRY.values());
            relicRecipes.add(EMPTY);
            return relicRecipes;
        }

        @Nonnull
        public String getName(@Nonnull RelicRecipe recipe) {
            return recipe.getRecipeName();
        }

        @Nonnull
        public Optional<RelicRecipe> m_6215_(@Nonnull String value) {
            RelicRecipe relicRecipe = RECIPES_BY_NAME.get(value);
            return Optional.ofNullable(relicRecipe);
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that instanceof RelicProperty) {
                RelicProperty thatProperty = (RelicProperty)((Object)that);
                if (super.equals(that)) {
                    return this.m_6908_().equals(thatProperty.m_6908_());
                }
            }
            return false;
        }

        public int m_6310_() {
            return 31 * super.m_6310_() + this.m_6908_().hashCode();
        }

        public static RelicProperty create(String name) {
            return new RelicProperty(name);
        }
    }
}

