/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.init;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.VaultMod;
import iskallia.vault.client.shader.ClipPositionTexShader;
import iskallia.vault.client.shader.ColorizePositionTexShader;
import iskallia.vault.client.shader.GrayscalePositionTexShader;
import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.client.event.RegisterShadersEvent;

public class ModShaders {
    private static ClipPositionTexShader clipPositionTexShader;
    private static GrayscalePositionTexShader grayscalePositionTexShader;
    private static ColorizePositionTexShader colorizePositionTexShader;

    public static ClipPositionTexShader getClipPositionTexShader() {
        return clipPositionTexShader;
    }

    public static GrayscalePositionTexShader getGrayscalePositionTexShader() {
        return grayscalePositionTexShader;
    }

    public static ColorizePositionTexShader getColorizePositionTexShader() {
        return colorizePositionTexShader;
    }

    public static void register(RegisterShadersEvent event) {
        ModShaders.registerShader(event, VaultMod.id("position_tex_clip"), DefaultVertexFormat.f_85817_, shaderInstance -> {
            clipPositionTexShader = new ClipPositionTexShader((ShaderInstance)shaderInstance);
        });
        ModShaders.registerShader(event, VaultMod.id("position_tex_grayscale"), DefaultVertexFormat.f_85817_, shaderInstance -> {
            grayscalePositionTexShader = new GrayscalePositionTexShader((ShaderInstance)shaderInstance);
        });
        ModShaders.registerShader(event, VaultMod.id("position_tex_colorize"), DefaultVertexFormat.f_85817_, shaderInstance -> {
            colorizePositionTexShader = new ColorizePositionTexShader((ShaderInstance)shaderInstance);
        });
    }

    private static void registerShader(RegisterShadersEvent event, ResourceLocation resourceLocation, VertexFormat vertexFormat, Consumer<ShaderInstance> onLoaded) {
        try {
            event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), resourceLocation, vertexFormat), onLoaded);
        }
        catch (IOException e) {
            VaultMod.LOGGER.error("Error loading shader %s".formatted(resourceLocation), (Throwable)e);
        }
    }
}

