/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.integration.jei;

import com.google.common.collect.Lists;
import iskallia.vault.VaultMod;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.gear.VaultGearModifierHelper;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.crafting.VaultGearCraftingHelper;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.LegacyMagnetItem;
import iskallia.vault.item.VaultCatalystInfusedItem;
import iskallia.vault.item.crystal.CrystalData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class AnvilRecipesJEI {
    private static final Random random = new Random(0L);

    public static List<IJeiAnvilRecipe> getAnvilRecipes(IVanillaRecipeFactory vanillaRecipeFactory) {
        ItemStack right;
        ItemStack result;
        ArrayList recipeList = Lists.newArrayList();
        ArrayList vaultArmorList = Lists.newArrayList();
        ArrayList vaultArmorListUnidentified = Lists.newArrayList();
        vaultArmorList.add(AnvilRecipesJEI.generateRandomArmorList((Item)ModItems.HELMET));
        vaultArmorList.add(AnvilRecipesJEI.generateRandomArmorList((Item)ModItems.CHESTPLATE));
        vaultArmorList.add(AnvilRecipesJEI.generateRandomArmorList((Item)ModItems.LEGGINGS));
        vaultArmorList.add(AnvilRecipesJEI.generateRandomArmorList((Item)ModItems.BOOTS));
        vaultArmorListUnidentified.add(new ItemStack((ItemLike)ModItems.HELMET));
        vaultArmorListUnidentified.add(new ItemStack((ItemLike)ModItems.CHESTPLATE));
        vaultArmorListUnidentified.add(new ItemStack((ItemLike)ModItems.LEGGINGS));
        vaultArmorListUnidentified.add(new ItemStack((ItemLike)ModItems.BOOTS));
        List<ItemStack> vaultWeapons = List.of(new ItemStack((ItemLike)ModItems.SWORD), new ItemStack((ItemLike)ModItems.AXE));
        List<ItemStack> vaultSeals = List.of(new ItemStack((ItemLike)ModItems.CRYSTAL_SEAL_CAKE), new ItemStack((ItemLike)ModItems.CRYSTAL_SEAL_HUNTER), new ItemStack((ItemLike)ModItems.CRYSTAL_SEAL_EXECUTIONER));
        List<ItemStack> vaultPicks = List.of(new ItemStack((ItemLike)ModItems.VAULTERITE_PICKAXE), new ItemStack((ItemLike)ModItems.VAULT_PICKAXE), new ItemStack((ItemLike)ModItems.BLACK_CHROMATIC_PICKAXE), new ItemStack((ItemLike)ModItems.ECHOING_PICKAXE), new ItemStack((ItemLike)ModItems.PRISMATIC_PICKAXE));
        List<ItemStack> omegaPog = List.of(new ItemStack((ItemLike)ModItems.OMEGA_POG));
        List<ItemStack> repairCore = List.of(new ItemStack((ItemLike)ModItems.REPAIR_CORE));
        for (List armorItemList : vaultArmorList) {
            ArrayList<ItemStack> inputList = new ArrayList<ItemStack>(armorItemList.size());
            ArrayList<ItemStack> resultList = new ArrayList<ItemStack>(armorItemList.size());
            for (ItemStack armorItem : armorItemList) {
                ItemStack input = armorItem.m_41777_();
                ItemStack result2 = armorItem.m_41777_();
                input.m_41721_(input.m_41776_() - 5);
                VaultGearData data = VaultGearData.read(result2);
                int repairs = data.getUsedRepairSlots() + 1;
                data.setUsedRepairSlots(repairs);
                data.write(result2);
                inputList.add(input);
                resultList.add(result2);
            }
            recipeList.add(vanillaRecipeFactory.createAnvilRecipe(inputList, repairCore, resultList));
        }
        for (ItemStack weapon : vaultWeapons) {
            List<ItemStack> list = AnvilRecipesJEI.generateRandomArmorList(weapon.m_41720_());
            vaultArmorList.add(AnvilRecipesJEI.generateRandomArmorList(weapon.m_41720_()));
            ArrayList<ItemStack> damaged = new ArrayList<ItemStack>(list);
            list.get(0).m_41721_(list.get(0).m_41776_() - 5);
            result = list.get(0).m_41777_();
            VaultGearData data = VaultGearData.read(result);
            int repairs = data.getUsedRepairSlots() + 1;
            data.setRepairSlots(repairs);
            data.write(result);
            recipeList.add(vanillaRecipeFactory.createAnvilRecipe(damaged, repairCore, List.of(result)));
        }
        for (ItemStack seal : vaultSeals) {
            ItemStack input = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
            ItemStack copy = input.m_41720_() == ModItems.VAULT_CRYSTAL ? input.m_41777_() : new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
            CrystalData crystal = CrystalData.read(copy);
            ModConfigs.VAULT_CRYSTAL.applySeal(input, seal, input, crystal);
            recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL)), List.of(seal), List.of(copy)));
        }
        Object left = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        ItemStack right2 = new ItemStack((ItemLike)ModItems.VAULT_CATALYST_INFUSED);
        ItemStack output = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        VaultCatalystInfusedItem.setJeiModifiers(right2, List.of(VaultMod.id("living"), VaultMod.id("wild")));
        CrystalData data = CrystalData.read(output);
        List<VaultModifierStack> modifierStackList = VaultCatalystInfusedItem.getModifiers(right2).stream().map(VaultModifierRegistry::getOpt).flatMap(Optional::stream).map(VaultModifierStack::of).toList();
        if (data.getModifiers().addByCrafting(data, modifierStackList, CrystalData.Simulate.FALSE)) {
            data.write(output);
        }
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(left), List.of(right2), List.of(output)));
        left = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        right2 = new ItemStack((ItemLike)Items.f_42679_);
        output = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        CrystalData dataOutput = CrystalData.read(output);
        AnvilRecipesJEI.addModifier(dataOutput, VaultMod.id("hunger"));
        dataOutput.write(output);
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(left), List.of(right2), List.of(output)));
        left = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        right2 = new ItemStack((ItemLike)ModItems.MOTE_CLARITY);
        output = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        CrystalData dataLeft = CrystalData.read((ItemStack)left);
        CrystalData dataOutput2 = CrystalData.read(output);
        dataLeft.setLevel(5);
        dataOutput2.setLevel(5);
        AnvilRecipesJEI.addModifier(dataOutput2, VaultMod.id("hunger"));
        AnvilRecipesJEI.addModifier(dataOutput2, VaultMod.id("tired"));
        AnvilRecipesJEI.addModifier(dataLeft, VaultMod.id("hunger"));
        AnvilRecipesJEI.addModifier(dataLeft, VaultMod.id("tired"));
        dataOutput2.getModifiers().setClarity(true);
        dataOutput2.write(output);
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(left), List.of(right2), List.of(output)));
        left = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        right2 = new ItemStack((ItemLike)ModItems.MOTE_PURITY);
        output = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        dataLeft = CrystalData.read((ItemStack)left);
        dataOutput2 = CrystalData.read(output);
        dataLeft.setLevel(5);
        dataOutput2.setLevel(5);
        AnvilRecipesJEI.addModifier(dataOutput2, VaultMod.id("hunger"));
        AnvilRecipesJEI.addModifier(dataOutput2, VaultMod.id("tired"));
        AnvilRecipesJEI.addModifier(dataLeft, VaultMod.id("hunger"));
        AnvilRecipesJEI.addModifier(dataLeft, VaultMod.id("tired"));
        dataOutput2.getModifiers().removeRandomCurse();
        dataOutput2.write(output);
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(left), List.of(right2), List.of(output)));
        left = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        right2 = new ItemStack((ItemLike)ModItems.MOTE_SANCTITY);
        output = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        dataLeft = CrystalData.read((ItemStack)left);
        dataOutput2 = CrystalData.read(output);
        dataLeft.setLevel(5);
        dataOutput2.setLevel(5);
        AnvilRecipesJEI.addModifier(dataOutput2, VaultMod.id("hunger"));
        AnvilRecipesJEI.addModifier(dataOutput2, VaultMod.id("tired"));
        AnvilRecipesJEI.addModifier(dataLeft, VaultMod.id("hunger"));
        AnvilRecipesJEI.addModifier(dataLeft, VaultMod.id("tired"));
        CrystalData crystal = CrystalData.read(output);
        crystal.getModifiers().removeAllCurses();
        crystal.write(output);
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(left), List.of(right2), List.of(output)));
        for (ItemStack armorItem : vaultArmorListUnidentified) {
            right = new ItemStack((ItemLike)ModItems.BANISHED_SOUL);
            ItemStack input = armorItem.m_41777_();
            result = armorItem.m_41777_();
            VaultGearData dataInput = VaultGearData.read(input);
            VaultGearData dataOutput3 = VaultGearData.read(result);
            dataInput.setItemLevel(5);
            dataOutput3.setItemLevel(4);
            dataInput.write(input);
            dataOutput3.write(result);
            recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(input), List.of(right), List.of(result)));
        }
        left = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        right2 = new ItemStack((ItemLike)Items.f_42415_);
        output = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        dataLeft = CrystalData.read((ItemStack)left);
        dataOutput2 = CrystalData.read(output);
        dataLeft.setLevel(5);
        dataOutput2.setLevel(4);
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(left), List.of(right2), List.of(output)));
        left = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        right2 = new ItemStack((ItemLike)ModItems.SOUL_FLAME);
        output = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        dataLeft = CrystalData.read((ItemStack)left);
        dataOutput2 = CrystalData.read(output);
        dataLeft.setLevel(10);
        dataOutput2.setLevel(10);
        VaultModifierRegistry.getOpt(VaultMod.id("afterlife")).ifPresent(vaultModifier -> {
            VaultModifierStack modifierStack = VaultModifierStack.of(vaultModifier);
            if (dataOutput2.addModifierByCrafting(modifierStack, false, CrystalData.Simulate.TRUE)) {
                dataOutput2.addModifierByCrafting(modifierStack, false, CrystalData.Simulate.FALSE);
                AnvilRecipesJEI.addModifier(dataOutput2, VaultMod.id("hunger"));
                AnvilRecipesJEI.addModifier(dataOutput2, VaultMod.id("tired"));
                dataOutput2.setUnmodifiable(true);
                dataOutput2.write(output);
            }
        });
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(left), List.of(right2), List.of(output)));
        left = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        right2 = new ItemStack((ItemLike)ModItems.PHOENIX_FEATHER);
        output = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        dataLeft = CrystalData.read((ItemStack)left);
        dataOutput2 = CrystalData.read(output);
        dataLeft.setLevel(10);
        dataOutput2.setLevel(10);
        VaultModifierRegistry.getOpt(VaultMod.id("phoenix")).ifPresent(modifier -> {
            VaultModifierStack modifierStack = VaultModifierStack.of(modifier);
            if (dataOutput2.addModifierByCrafting(modifierStack, false, CrystalData.Simulate.TRUE)) {
                dataOutput2.addModifierByCrafting(modifierStack, false, CrystalData.Simulate.FALSE);
                dataOutput2.setUnmodifiable(true);
                dataOutput2.write(output);
            }
        });
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(left), List.of(right2), List.of(output)));
        left = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        right2 = new ItemStack((ItemLike)ModItems.EYE_OF_AVARICE);
        output = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        dataLeft = CrystalData.read((ItemStack)left);
        dataOutput2 = CrystalData.read(output);
        dataLeft.setLevel(10);
        dataOutput2.setLevel(10);
        VaultModifierRegistry.getOpt(VaultMod.id("looters_dream")).ifPresent(modifier -> {
            VaultModifierStack modifierStack = VaultModifierStack.of(modifier);
            if (dataOutput2.addModifierByCrafting(modifierStack, false, CrystalData.Simulate.TRUE)) {
                dataOutput2.addModifierByCrafting(modifierStack, false, CrystalData.Simulate.FALSE);
                dataOutput2.setUnmodifiable(true);
                dataOutput2.write(output);
            }
        });
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(left), List.of(right2), List.of(output)));
        left = new ItemStack((ItemLike)ModItems.MAGNET);
        right2 = new ItemStack((ItemLike)ModItems.REPAIR_CORE);
        output = new ItemStack((ItemLike)ModItems.MAGNET);
        LegacyMagnetItem.useRepairSlot(output);
        left.m_41721_(left.m_41776_() - 5);
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(left), List.of(right2), List.of(output)));
        for (ItemStack left2 : vaultPicks) {
            right = new ItemStack((ItemLike)ModItems.REPAIR_CORE);
            ItemStack output2 = left2.m_41777_();
            LegacyMagnetItem.useRepairSlot(output2);
            left2.m_41721_(left2.m_41776_() - 5);
            recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(left2), List.of(right), List.of(output2)));
        }
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(new ItemStack((ItemLike)ModItems.BLANK_KEY)), List.of(new ItemStack((ItemLike)ModItems.BOMIGNITE_CLUSTER)), List.of(new ItemStack((ItemLike)ModItems.BOMIGNITE_KEY))));
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(new ItemStack((ItemLike)ModItems.BLANK_KEY)), List.of(new ItemStack((ItemLike)ModItems.ASHIUM_CLUSTER)), List.of(new ItemStack((ItemLike)ModItems.ASHIUM_KEY))));
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(new ItemStack((ItemLike)ModItems.BLANK_KEY)), List.of(new ItemStack((ItemLike)ModItems.ISKALLIUM_CLUSTER)), List.of(new ItemStack((ItemLike)ModItems.ISKALLIUM_KEY))));
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(new ItemStack((ItemLike)ModItems.BLANK_KEY)), List.of(new ItemStack((ItemLike)ModItems.GORGINITE_CLUSTER)), List.of(new ItemStack((ItemLike)ModItems.GORGINITE_KEY))));
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(new ItemStack((ItemLike)ModItems.BLANK_KEY)), List.of(new ItemStack((ItemLike)ModItems.PETZANITE_CLUSTER)), List.of(new ItemStack((ItemLike)ModItems.PETZANITE_KEY))));
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(new ItemStack((ItemLike)ModItems.BLANK_KEY)), List.of(new ItemStack((ItemLike)ModItems.TUBIUM_CLUSTER)), List.of(new ItemStack((ItemLike)ModItems.TUBIUM_KEY))));
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(new ItemStack((ItemLike)ModItems.BLANK_KEY)), List.of(new ItemStack((ItemLike)ModItems.SPARKLETINE_CLUSTER)), List.of(new ItemStack((ItemLike)ModItems.SPARKLETINE_KEY))));
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(new ItemStack((ItemLike)ModItems.BLANK_KEY)), List.of(new ItemStack((ItemLike)ModItems.UPALINE_CLUSTER)), List.of(new ItemStack((ItemLike)ModItems.UPALINE_KEY))));
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe(List.of(new ItemStack((ItemLike)ModItems.BLANK_KEY)), List.of(new ItemStack((ItemLike)ModItems.XENIUM_CLUSTER)), List.of(new ItemStack((ItemLike)ModItems.XENIUM_KEY))));
        ArrayList artifacts = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)ModBlocks.VAULT_ARTIFACT)});
        List<ItemStack> unidentifiedArtifact = List.of(new ItemStack((ItemLike)ModItems.UNIDENTIFIED_ARTIFACT));
        recipeList.add(vanillaRecipeFactory.createAnvilRecipe((List)artifacts, omegaPog, unidentifiedArtifact));
        return recipeList;
    }

    private static void addModifier(CrystalData data, ResourceLocation id) {
        VaultModifier<?> modifier = VaultModifierRegistry.getOrDefault(id, null);
        if (modifier != null) {
            data.getModifiers().add(VaultModifierStack.of(modifier));
        }
    }

    private static List<ItemStack> generateRandomArmorList(Item gear) {
        ArrayList<ItemStack> returnList = new ArrayList<ItemStack>();
        ItemStack itemStack = new ItemStack((ItemLike)gear);
        VaultGearData data = VaultGearData.read(itemStack);
        Object item = VaultGearItem.of(itemStack);
        data.setRarity(VaultGearRarity.EPIC);
        data.write(itemStack);
        ResourceLocation modelKey = item.getRandomModel(itemStack, random);
        if (modelKey != null) {
            data.updateAttribute(ModGearAttributes.GEAR_MODEL, modelKey);
        }
        data.write(itemStack);
        data.setState(VaultGearState.IDENTIFIED);
        data.write(itemStack);
        VaultGearModifierHelper.reRollRepairSlots(itemStack, random);
        VaultGearCraftingHelper.reRollCraftingPotential(itemStack);
        VaultGearModifierHelper.generateAffixSlots(itemStack, random);
        VaultGearModifierHelper.generateImplicits(itemStack, random);
        VaultGearModifierHelper.generateModifiers(itemStack, random);
        returnList.add(itemStack);
        return returnList;
    }
}

