/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.integration.jei;

import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.screen.block.SkillAltarScreen;
import iskallia.vault.client.gui.screen.player.AbstractSkillTabElementContainerScreen;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.integration.jei.AnvilRecipesJEI;
import iskallia.vault.integration.jei.CatalystInfusionTableRecipeCategory;
import iskallia.vault.integration.jei.RemoveJEIContainerHandler;
import iskallia.vault.integration.jei.VaultRecyclerRecipeJEI;
import iskallia.vault.integration.jei.VaultRecyclerRecipeJEICategory;
import iskallia.vault.integration.jei.lootinfo.LootInfoFactory;
import iskallia.vault.integration.jei.lootinfo.LootInfoGroupDefinition;
import iskallia.vault.integration.jei.lootinfo.LootInfoGroupDefinitionRegistry;
import iskallia.vault.integration.jei.lootinfo.LootInfoRecipeCategory;
import iskallia.vault.item.tool.Pulverizing;
import iskallia.vault.item.tool.Smelting;
import iskallia.vault.recipe.CatalystInfusionTableRecipe;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class IntegrationJEI
implements IModPlugin {
    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{ModItems.RESPEC_FLASK, ModItems.FACETED_FOCUS, ModItems.TRINKET, ModItems.ETCHING, ModItems.GOD_BLESSING, ModItems.TOOL, ModItems.JEWEL, ModItems.AUGMENT, ModBlocks.ASHIUM_ORE.m_5456_(), ModBlocks.ALEXANDRITE_ORE.m_5456_(), ModBlocks.BLACK_OPAL_ORE.m_5456_(), ModBlocks.BOMIGNITE_ORE.m_5456_(), ModBlocks.ECHO_ORE.m_5456_(), ModBlocks.GORGINITE_ORE.m_5456_(), ModBlocks.ISKALLIUM_ORE.m_5456_(), ModBlocks.LARIMAR_ORE.m_5456_(), ModBlocks.PAINITE_ORE.m_5456_(), ModBlocks.PETZANITE_ORE.m_5456_(), ModBlocks.PUFFIUM_ORE.m_5456_(), ModBlocks.SPARKLETINE_ORE.m_5456_(), ModBlocks.TUBIUM_ORE.m_5456_(), ModBlocks.UPALINE_ORE.m_5456_(), ModBlocks.WUTODIE_ORE.m_5456_(), ModBlocks.XENIUM_ORE.m_5456_(), ModBlocks.PLACEHOLDER.m_5456_(), ModBlocks.HERALD_TROPHY_BLOCK_ITEM, ModBlocks.SOUL_PLAQUE_BLOCK_ITEM, ModBlocks.GOD_ALTAR.m_5456_(), ModItems.TITLE_SCROLL});
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.BOTTLE, (stack, context) -> stack.m_41784_().m_128461_("type") + "_" + stack.m_41784_().m_128461_("recharge"));
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("ispawner", "spawn_egg"));
        if (item != null) {
            registration.useNbtForSubtypes(new Item[]{item});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CATALYST_INFUSION_TABLE), new RecipeType[]{CatalystInfusionTableRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.VAULT_RECYCLER), new RecipeType[]{VaultRecyclerRecipeJEICategory.RECIPE_TYPE});
        for (LootInfoGroupDefinition definition : LootInfoGroupDefinitionRegistry.get().values()) {
            registration.addRecipeCatalyst(definition.itemStack(), new RecipeType[]{definition.recipeType()});
        }
        Pulverizing.register(registration);
        Smelting.register(registration);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CatalystInfusionTableRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new VaultRecyclerRecipeJEICategory(guiHelper)});
        for (LootInfoGroupDefinition definition : LootInfoGroupDefinitionRegistry.get().values()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new LootInfoRecipeCategory(guiHelper, definition.recipeType(), definition.itemStack(), definition.titleComponent())});
        }
        Pulverizing.register(registration);
        Smelting.register(registration);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        registration.addRecipes(CatalystInfusionTableRecipeCategory.RECIPE_TYPE, List.of(new CatalystInfusionTableRecipe()));
        List<VaultRecyclerRecipeJEI> recipes = VaultRecyclerRecipeJEI.getRecipeList();
        registration.addRecipes(VaultRecyclerRecipeJEICategory.RECIPE_TYPE, recipes);
        LootInfoGroupDefinitionRegistry.get().forEach((resourceLocation, definition) -> registration.addRecipes(definition.recipeType(), LootInfoFactory.create(resourceLocation)));
        IVanillaRecipeFactory vanillaRecipeFactory = registration.getVanillaRecipeFactory();
        registration.addRecipes(RecipeTypes.ANVIL, AnvilRecipesJEI.getAnvilRecipes(vanillaRecipeFactory));
        Pulverizing.register(registration);
        Smelting.register(registration);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AbstractSkillTabElementContainerScreen.class, new RemoveJEIContainerHandler());
        registration.addGenericGuiContainerHandler(SkillAltarScreen.Default.class, new IGuiContainerHandler<AbstractContainerScreen<?>>(){

            public List<Rect2i> getGuiExtraAreas(AbstractContainerScreen<?> containerScreen) {
                return List.of(new Rect2i(containerScreen.getGuiLeft() + containerScreen.getXSize(), containerScreen.getGuiTop() + 7, 18, 62));
            }
        });
        registration.addGenericGuiContainerHandler(SkillAltarScreen.Import.class, new IGuiContainerHandler<AbstractContainerScreen<?>>(){

            public List<Rect2i> getGuiExtraAreas(AbstractContainerScreen<?> containerScreen) {
                return List.of(new Rect2i(containerScreen.getGuiLeft() + containerScreen.getXSize(), containerScreen.getGuiTop() + 44, 18, 18));
            }
        });
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return VaultMod.id("jei_integration");
    }
}

