/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.integration.jei;

import com.google.common.collect.Lists;
import iskallia.vault.config.VaultRecyclerConfig;
import iskallia.vault.config.entry.ChanceItemStackEntry;
import iskallia.vault.gear.GearRollHelper;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.trinket.TrinketEffectRegistry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.gear.DataTransferItem;
import iskallia.vault.item.gear.TrinketItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class VaultRecyclerRecipeJEI {
    private static final Random random = new Random(0L);
    private ItemStack INPUT = new ItemStack((ItemLike)ModItems.HELMET);
    private ItemStack OUTPUT1 = new ItemStack((ItemLike)ModItems.VAULT_SCRAP);
    private ItemStack OUTPUT2 = new ItemStack((ItemLike)ModItems.WILD_FOCUS);
    private ItemStack OUTPUT3 = new ItemStack((ItemLike)ModItems.FACETED_FOCUS);

    public VaultRecyclerRecipeJEI(ItemStack input, ItemStack output1, ItemStack output2, ItemStack output3) {
        this.INPUT = input;
        this.OUTPUT1 = output1;
        this.OUTPUT2 = output2;
        this.OUTPUT3 = output3;
    }

    public ItemStack getInput() {
        return this.INPUT;
    }

    public ItemStack getOutput1() {
        return this.OUTPUT1;
    }

    public ItemStack getOutput2() {
        return this.OUTPUT2;
    }

    public ItemStack getOutput3() {
        return this.OUTPUT3;
    }

    public static List<VaultRecyclerRecipeJEI> getRecipeList() {
        ArrayList recipeList = Lists.newArrayList();
        ArrayList vaultArmorList = Lists.newArrayList();
        ItemStack sword = VaultRecyclerRecipeJEI.generateRandomArmor((Item)ModItems.SWORD, VaultGearRarity.COMMON);
        vaultArmorList.add(sword);
        ItemStack axe = VaultRecyclerRecipeJEI.generateRandomArmor((Item)ModItems.AXE, VaultGearRarity.COMMON);
        axe.m_41721_(axe.m_41776_() / 6);
        vaultArmorList.add(axe);
        ItemStack helmet = VaultRecyclerRecipeJEI.generateRandomArmor((Item)ModItems.HELMET, VaultGearRarity.COMMON);
        helmet.m_41721_(helmet.m_41776_() / 6 * 2);
        vaultArmorList.add(helmet);
        ItemStack chestplate = VaultRecyclerRecipeJEI.generateRandomArmor((Item)ModItems.CHESTPLATE, VaultGearRarity.COMMON);
        chestplate.m_41721_(chestplate.m_41776_() / 6 * 3);
        vaultArmorList.add(chestplate);
        ItemStack leggings = VaultRecyclerRecipeJEI.generateRandomArmor((Item)ModItems.LEGGINGS, VaultGearRarity.COMMON);
        leggings.m_41721_(leggings.m_41776_() / 6 * 4);
        vaultArmorList.add(leggings);
        ItemStack boots = VaultRecyclerRecipeJEI.generateRandomArmor((Item)ModItems.BOOTS, VaultGearRarity.COMMON);
        boots.m_41721_(boots.m_41776_() / 6 * 5 - 1);
        vaultArmorList.add(boots);
        for (ItemStack armor : vaultArmorList) {
            ItemStack stack = VaultRecyclerRecipeJEI.getUseRelatedOutput(armor, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getGearRecyclingOutput().getMainOutputMatching()));
            ItemStack stack2 = VaultRecyclerRecipeJEI.getUseRelatedOutput(armor, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getGearRecyclingOutput().getExtraOutput1Matching()));
            ItemStack stack3 = VaultRecyclerRecipeJEI.getUseRelatedOutput(armor, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getGearRecyclingOutput().getExtraOutput2Matching()));
            recipeList.add(new VaultRecyclerRecipeJEI(armor, stack, stack2, stack3));
        }
        ItemStack trinket = TrinketItem.createRandomTrinket(TrinketEffectRegistry.getOrderedEntries().get(random.nextInt(TrinketEffectRegistry.getOrderedEntries().size())));
        ItemStack stack = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getMainOutputMatching()));
        ItemStack stack2 = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getExtraOutput1Matching()));
        ItemStack stack3 = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getExtraOutput2Matching()));
        recipeList.add(new VaultRecyclerRecipeJEI(trinket, stack, stack2, stack3));
        trinket = TrinketItem.createRandomTrinket(TrinketEffectRegistry.getOrderedEntries().get(Math.max(0, random.nextInt(TrinketEffectRegistry.getOrderedEntries().size() - 1))));
        for (int i = 0; i < Math.max(1, TrinketItem.getUses(trinket) / 5); ++i) {
            TrinketItem.addUsedVault(trinket, new UUID(i, i));
        }
        stack = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getMainOutputMatching()));
        stack2 = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getExtraOutput1Matching()));
        stack3 = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getExtraOutput2Matching()));
        recipeList.add(new VaultRecyclerRecipeJEI(trinket, stack, stack2, stack3));
        trinket = TrinketItem.createRandomTrinket(TrinketEffectRegistry.getOrderedEntries().get(Math.max(0, random.nextInt(TrinketEffectRegistry.getOrderedEntries().size() - 1))));
        for (int i = 0; i < Math.max(1, TrinketItem.getUses(trinket) / 5 * 2); ++i) {
            TrinketItem.addUsedVault(trinket, new UUID(i, i));
        }
        stack = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getMainOutputMatching()));
        stack2 = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getExtraOutput1Matching()));
        stack3 = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getExtraOutput2Matching()));
        recipeList.add(new VaultRecyclerRecipeJEI(trinket, stack, stack2, stack3));
        trinket = TrinketItem.createRandomTrinket(TrinketEffectRegistry.getOrderedEntries().get(Math.max(0, random.nextInt(TrinketEffectRegistry.getOrderedEntries().size() - 1))));
        for (int i = 0; i < Math.max(1, TrinketItem.getUses(trinket) / 5 * 3); ++i) {
            TrinketItem.addUsedVault(trinket, new UUID(i, i));
        }
        stack = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getMainOutputMatching()));
        stack2 = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getExtraOutput1Matching()));
        stack3 = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getExtraOutput2Matching()));
        recipeList.add(new VaultRecyclerRecipeJEI(trinket, stack, stack2, stack3));
        trinket = TrinketItem.createRandomTrinket(TrinketEffectRegistry.getOrderedEntries().get(Math.max(0, random.nextInt(TrinketEffectRegistry.getOrderedEntries().size() - 1))));
        for (int i = 0; i < Math.max(1, TrinketItem.getUses(trinket) / 5 * 4); ++i) {
            TrinketItem.addUsedVault(trinket, new UUID(i, i));
        }
        stack = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getMainOutputMatching()));
        stack2 = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getExtraOutput1Matching()));
        stack3 = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getExtraOutput2Matching()));
        recipeList.add(new VaultRecyclerRecipeJEI(trinket, stack, stack2, stack3));
        trinket = TrinketItem.createRandomTrinket(TrinketEffectRegistry.getOrderedEntries().get(Math.max(0, random.nextInt(TrinketEffectRegistry.getOrderedEntries().size() - 2))));
        for (int i = 0; i < Math.max(1, TrinketItem.getUses(trinket) - 1); ++i) {
            TrinketItem.addUsedVault(trinket, new UUID(i, i));
        }
        stack = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getMainOutputMatching()));
        stack2 = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getExtraOutput1Matching()));
        stack3 = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getExtraOutput2Matching()));
        recipeList.add(new VaultRecyclerRecipeJEI(trinket, stack, stack2, stack3));
        trinket = TrinketItem.createRandomTrinket(TrinketEffectRegistry.getOrderedEntries().get(Math.max(0, random.nextInt(TrinketEffectRegistry.getOrderedEntries().size() - 3))));
        for (int i = 0; i < TrinketItem.getUses(trinket); ++i) {
            TrinketItem.addUsedVault(trinket, new UUID(i, i));
        }
        stack = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getMainOutputMatching()));
        stack2 = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getExtraOutput1Matching()));
        stack3 = VaultRecyclerRecipeJEI.getUseRelatedOutput(trinket, DataTransferItem.doConvertStack(ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput().getExtraOutput2Matching()));
        recipeList.add(new VaultRecyclerRecipeJEI(trinket, stack, stack2, stack3));
        return recipeList;
    }

    public static List<Component> getRelatedTooltip(ItemStack input, VaultRecyclerConfig.RecyclerOutput recyclerOutput, int i) {
        ChanceItemStackEntry output = i == 0 ? recyclerOutput.getMainOutput() : (i == 1 ? recyclerOutput.getExtraOutput1() : recyclerOutput.getExtraOutput2());
        float chance = VaultRecyclerRecipeJEI.getResultPercentage(input);
        float out = (float)output.getMatchingStack().m_41613_() * chance;
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)new TextComponent("Base Count: " + output.getMinCount() + " - " + output.getMaxCount()));
        int resultCount = Mth.m_14143_((float)out);
        if (resultCount < 1 && out > 0.0f) {
            ++resultCount;
        }
        if (output.getChance() != 1.0f) {
            list.add((Component)new TextComponent(String.format("%.1f", Float.valueOf(output.getChance() * 100.0f)) + "% Chance"));
        }
        list.add((Component)new TextComponent("Quantity and chance scale off input item quality"));
        ItemStack copyOut = output.getMatchingStack().m_41777_();
        copyOut.m_41764_(resultCount);
        return list;
    }

    private static ItemStack getUseRelatedOutput(ItemStack input, ItemStack output) {
        float chance = VaultRecyclerRecipeJEI.getResultPercentage(input);
        float out = (float)output.m_41613_() * chance;
        int resultCount = Mth.m_14143_((float)out);
        if (resultCount < 1 && out > 0.0f) {
            ++resultCount;
        }
        ItemStack copyOut = output.m_41777_();
        copyOut.m_41764_(resultCount);
        return copyOut;
    }

    public static float getResultPercentage(ItemStack input) {
        if (input.m_41619_()) {
            return 0.0f;
        }
        if (input.m_41720_() instanceof VaultGearItem) {
            if (VaultGearData.read(input).getState() != VaultGearState.IDENTIFIED) {
                return 1.0f;
            }
            return 1.0f - (float)input.m_41773_() / (float)input.m_41776_();
        }
        if (input.m_41720_() instanceof TrinketItem) {
            if (!TrinketItem.isIdentified(input)) {
                return 1.0f;
            }
            return 1.0f - (float)TrinketItem.getUsedVaults(input).size() / (float)TrinketItem.getUses(input);
        }
        return 0.0f;
    }

    private static ItemStack generateRandomArmor(Item gear, VaultGearRarity rarity) {
        ItemStack itemStack = new ItemStack((ItemLike)gear);
        VaultGearData data = VaultGearData.read(itemStack);
        Object item = VaultGearItem.of(itemStack);
        data.setRarity(rarity);
        data.write(itemStack);
        ResourceLocation modelKey = item.getRandomModel(itemStack, random);
        if (modelKey != null) {
            data.updateAttribute(ModGearAttributes.GEAR_MODEL, modelKey);
        }
        data.write(itemStack);
        GearRollHelper.initializeGear(itemStack);
        return itemStack;
    }
}

