/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.client.render.AnimalJarISTER;
import iskallia.vault.init.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.registries.ForgeRegistries;

public class AnimalJarItem
extends Item {
    private final List<Component> tooltip = new ArrayList<Component>();

    public AnimalJarItem(ResourceLocation id) {
        this(id, new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP));
    }

    public AnimalJarItem(ResourceLocation id, Item.Properties properties) {
        super(properties);
        this.setRegistryName(id);
    }

    public AnimalJarItem withTooltip(Component tooltip) {
        this.tooltip.add(tooltip);
        return this;
    }

    public AnimalJarItem withTooltip(Component ... tooltip) {
        this.tooltip.addAll(Arrays.asList(tooltip));
        return this;
    }

    public AnimalJarItem withTooltip(List<Component> tooltip) {
        this.tooltip.addAll(tooltip);
        return this;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (!this.tooltip.isEmpty()) {
            tooltip.add(TextComponent.f_131282_);
            tooltip.addAll(this.tooltip);
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("entity")) {
            tooltip.add((Component)new TextComponent("Contains : ").m_7220_((Component)new TranslatableComponent(this.getTranslatedEntity(stack))).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("count")) {
            tooltip.add((Component)new TextComponent("Count : " + stack.m_41783_().m_128451_("count")).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)new TextComponent("Crouch right-click an Animal to catch").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)new TextComponent("For use in the Animal Pen").m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)new TextComponent("Animals can not be released when caught").m_130940_(ChatFormatting.GRAY));
    }

    public static ItemStack AddEntity(ItemStack stack, LivingEntity entity) {
        Level level;
        if (entity.f_19853_.m_5776_() || entity instanceof Player || !entity.m_6084_() || !AnimalJarItem.canAddEntity(stack, entity)) {
            return stack;
        }
        if (stack.m_41784_().m_128441_("count")) {
            stack.m_41784_().m_128405_("count", stack.m_41784_().m_128451_("count") + 1);
        }
        if (!stack.m_41784_().m_128441_("entity")) {
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128359_("entity", EntityType.m_20613_((EntityType)entity.m_6095_()).toString());
            entity.m_20223_(nbt);
            nbt.m_128405_("count", 1);
        }
        if ((level = entity.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_6263_(null, entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_, SoundEvents.f_12318_, SoundSource.PLAYERS, 0.75f, 1.5f);
            serverLevel.m_6263_(null, entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.75f, 1.5f);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, entity.m_20182_().m_7096_(), entity.m_20182_().m_7098_() + (double)(entity.m_20206_() / 2.0f), entity.m_20182_().m_7094_(), 20, 0.03333333507180214, serverLevel.f_46441_.nextDouble() * 0.1, 0.03333333507180214, (double)0.05f);
        }
        entity.m_142687_(Entity.RemovalReason.KILLED);
        return stack;
    }

    public static boolean containsEntity(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41782_() && stack.m_41783_().m_128441_("entity");
    }

    public static boolean canAddEntity(ItemStack stack, LivingEntity entity) {
        if (stack.m_41619_()) {
            return false;
        }
        if (!stack.m_41782_()) {
            return true;
        }
        if (!stack.m_41783_().m_128441_("entity")) {
            return true;
        }
        return stack.m_41783_().m_128461_("entity").equals(EntityType.m_20613_((EntityType)entity.m_6095_()).toString());
    }

    public String getEntityID(ItemStack stack) {
        return stack.m_41783_().m_128461_("entity");
    }

    public String getTranslatedEntity(ItemStack stack) {
        return ((EntityType)ForgeRegistries.ENTITIES.getValue(ResourceLocation.m_135822_((String)stack.m_41783_().m_128461_("entity"), (char)':'))).m_20675_();
    }

    @Nullable
    public static Animal getAnimalFromItemStack(ItemStack stack, Level world) {
        EntityType type = EntityType.m_20632_((String)stack.m_41783_().m_128461_("entity")).orElse(null);
        if (type != null) {
            Entity entity = type.m_20615_(world);
            entity.m_20258_(stack.m_41783_());
            return (Animal)entity;
        }
        return null;
    }

    public boolean m_5812_(ItemStack itemStack) {
        return AnimalJarItem.containsEntity(itemStack);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(AnimalJarISTER.INSTANCE);
    }
}

