/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.core.data.key.ThemeKey;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.gear.DataTransferItem;
import iskallia.vault.item.gear.VaultLevelItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AugmentItem
extends Item
implements VaultLevelItem,
DataTransferItem {
    public AugmentItem(CreativeModeTab group, ResourceLocation id) {
        super(new Item.Properties().m_41491_(group));
        this.setRegistryName(id);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag advanced) {
        super.m_7373_(stack, world, tooltip, advanced);
        AugmentItem.getTheme(stack).ifPresent(key -> tooltip.add((Component)new TextComponent("Theme: ").m_7220_((Component)new TextComponent(key.getName()).m_130948_(Style.f_131099_.m_178520_(key.getColor())))));
    }

    public void m_6787_(CreativeModeTab category, NonNullList<ItemStack> items) {
        if (!this.m_41389_(category)) {
            return;
        }
        for (ThemeKey key : VaultRegistry.THEME.getKeys()) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.AUGMENT);
            stack.m_41784_().m_128359_("theme", key.getId().toString());
            items.add((Object)stack);
        }
    }

    public static int getColor(ItemStack stack) {
        return AugmentItem.getTheme(stack).map(ThemeKey::getColor).orElse(0xFFFFFF);
    }

    public static Optional<ThemeKey> getTheme(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return Optional.empty();
        }
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128425_("theme", 8)) {
            return Optional.empty();
        }
        ResourceLocation theme = new ResourceLocation(nbt.m_128461_("theme"));
        return Optional.ofNullable(VaultRegistry.THEME.getKey(theme));
    }

    @Override
    public void initializeVaultLoot(Vault vault, ItemStack stack, @Nullable BlockPos pos) {
        vault.getOptional(Vault.WORLD).map(world -> world.get(WorldManager.THEME)).ifPresent(theme -> stack.m_41784_().m_128359_("pool", theme.toString()));
    }

    @Override
    public ItemStack convertStack(ItemStack stack, RandomSource random) {
        if (stack.m_41783_() == null) {
            return stack;
        }
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128425_("pool", 8)) {
            return stack;
        }
        ResourceLocation pool = new ResourceLocation(nbt.m_128461_("pool"));
        return ModConfigs.AUGMENT.generate(pool, random).orElse(stack);
    }
}

