/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.config.entry.vending.ProductEntry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.BasicItem;
import iskallia.vault.item.ItemRelicBoosterPack;
import iskallia.vault.research.ResearchTree;
import iskallia.vault.util.data.WeightedList;
import iskallia.vault.world.data.PlayerResearchesData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class GatedLootableItem
extends BasicItem {
    Component[] tooltip;

    public GatedLootableItem(ResourceLocation id, Item.Properties properties) {
        super(id, properties);
    }

    public GatedLootableItem(ResourceLocation id, Item.Properties properties, Component ... tooltip) {
        super(id, properties);
        this.tooltip = tooltip;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_) {
            ItemStack heldStack = player.m_21120_(hand);
            ServerLevel serverWorld = (ServerLevel)world;
            ResearchTree researches = PlayerResearchesData.get(serverWorld).getResearches(player);
            ArrayList<String> unlocked = new ArrayList<String>(researches.getResearchesDone());
            WeightedList<ProductEntry> list = null;
            while (list == null && !unlocked.isEmpty()) {
                String researchName = (String)unlocked.remove(world.f_46441_.nextInt(unlocked.size()));
                list = ModConfigs.MOD_BOX.POOL.get(researchName);
            }
            ItemStack stack = ItemStack.f_41583_;
            ProductEntry productEntry = list == null || list.isEmpty() ? ModConfigs.MOD_BOX.POOL.get("None").getRandom(world.f_46441_) : (ProductEntry)list.getRandom(world.f_46441_);
            if (productEntry != null) {
                stack = productEntry.generateItemStack();
            }
            if (!stack.m_41619_()) {
                while (stack.m_41613_() > 0) {
                    int amount = Math.min(stack.m_41613_(), stack.m_41741_());
                    ItemStack copy = stack.m_41777_();
                    copy.m_41764_(amount);
                    stack.m_41774_(amount);
                    player.m_7197_(copy, false, false);
                }
                heldStack.m_41774_(1);
                ItemRelicBoosterPack.successEffects(world, player.m_20182_());
            } else {
                ItemRelicBoosterPack.failureEffects(world, player.m_20182_());
            }
        }
        return super.m_7203_(world, player, hand);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (this.tooltip != null) {
            tooltip.addAll(Arrays.asList(this.tooltip));
        }
    }
}

