/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.client.util.ClientScheduler;
import iskallia.vault.config.VaultRecyclerConfig;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.generator.layout.ArchitectRoomEntry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.data.InscriptionData;
import iskallia.vault.item.gear.DataInitializationItem;
import iskallia.vault.item.gear.RecyclableItem;
import iskallia.vault.item.gear.VaultLevelItem;
import iskallia.vault.item.tool.ColorBlender;
import iskallia.vault.item.tool.IManualModelLoading;
import iskallia.vault.item.tool.InscriptionItemRenderer;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;

public class InscriptionItem
extends Item
implements VaultLevelItem,
IManualModelLoading,
DataInitializationItem,
RecyclableItem {
    public static final UUID ID = UUID.fromString("dd941c87-ea2f-42a4-951d-89fcbc433170");

    public InscriptionItem(CreativeModeTab group, ResourceLocation id) {
        super(new Item.Properties().m_41491_(group).m_41487_(1));
        this.setRegistryName(id);
    }

    public Component m_7626_(ItemStack stack) {
        return new TextComponent("").m_7220_(super.m_7626_(stack)).m_6270_(Style.f_131099_.m_178520_(InscriptionItem.getColor(stack)));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.m_41389_(group)) {
            return;
        }
        for (ArchitectRoomEntry.Type type : ArchitectRoomEntry.Type.values()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            InscriptionData data = InscriptionData.from(stack);
            data.add(type, 1, switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case ArchitectRoomEntry.Type.COMMON -> 0xFFFFFF;
                case ArchitectRoomEntry.Type.CHALLENGE -> 0xFF55FF;
                case ArchitectRoomEntry.Type.OMEGA -> 0x55FF55;
            });
            data.setCompletion(0.05f);
            data.setTime(400);
            data.setInstability(0.01f);
            data.setModel(0);
            data.write(stack);
            items.add((Object)stack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        InscriptionData data = InscriptionData.from(stack);
        data.appendHoverText(stack, world, tooltip, flag);
    }

    @Override
    public void initializeVaultLoot(Vault vault, ItemStack stack, @Nullable BlockPos pos) {
        stack.m_41784_().m_128405_("level", vault.get(Vault.LEVEL).get());
    }

    @Override
    public void initialize(ItemStack stack, RandomSource rand) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            return;
        }
        if (nbt.m_128425_("pool", 8)) {
            ResourceLocation pool = new ResourceLocation(nbt.m_128461_("pool"));
            int level = nbt.m_128451_("level");
            ModConfigs.INSCRIPTION.generate(pool, level, rand).ifPresent(data -> data.write(stack));
            nbt.m_128473_("pool");
            nbt.m_128473_("level");
        }
    }

    @Override
    public Optional<UUID> getUuid(ItemStack stack) {
        return Optional.of(ID);
    }

    @Override
    public boolean isValidInput(ItemStack input) {
        return !input.m_41619_();
    }

    @Override
    public VaultRecyclerConfig.RecyclerOutput getOutput(ItemStack input) {
        return ModConfigs.VAULT_RECYCLER.getInscriptionRecyclingOutput();
    }

    @Override
    public float getResultPercentage(ItemStack input) {
        return input.m_41619_() ? 0.0f : 1.0f;
    }

    @Override
    public void loadModels(Consumer<ModelResourceLocation> consumer) {
        consumer.accept(new ModelResourceLocation("the_vault:inscription/core#inventory"));
        for (int i = 0; i < 16; ++i) {
            consumer.accept(new ModelResourceLocation("the_vault:inscription/%d#inventory".formatted(i)));
        }
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return InscriptionItemRenderer.INSTANCE;
            }
        });
    }

    public static int getColor(ItemStack stack) {
        InscriptionData data = InscriptionData.from(stack);
        if (data.getColor() != null) {
            return data.getColor();
        }
        ColorBlender blender = new ColorBlender(1.0f);
        for (InscriptionData.Entry entry : data.getEntries()) {
            blender.add(entry.color, 60.0f);
        }
        float time = ClientScheduler.INSTANCE.getTickCount();
        return blender.getColor(time);
    }
}

