/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.container.inventory.ShardPouchContainer;
import iskallia.vault.init.ModItems;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class ItemShardPouch
extends Item {
    public ItemShardPouch(ResourceLocation id) {
        super(new Item.Properties().m_41487_(1).m_41491_(ModItems.VAULT_MOD_GROUP));
        this.setRegistryName(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        ItemStack contained = ItemShardPouch.getContainedStack(stack);
        if (!contained.m_41619_()) {
            int count;
            tooltip.add((Component)new TextComponent(count + " Shard" + ((count = contained.m_41613_()) > 1 ? "s" : "")).m_130940_(ChatFormatting.GOLD));
        } else {
            tooltip.add((Component)new TextComponent("Empty").m_130940_(ChatFormatting.GOLD));
        }
    }

    public static int getShardCount(Player player) {
        return ItemShardPouch.getShardCount(player.m_150109_());
    }

    public static int getShardCount(Inventory playerInventory) {
        int shards = 0;
        for (int slot = 0; slot < playerInventory.m_6643_(); ++slot) {
            ItemStack stack = playerInventory.m_8020_(slot);
            if (stack.m_41720_() instanceof ItemShardPouch) {
                shards += ItemShardPouch.getContainedStack(stack).m_41613_();
                continue;
            }
            if (stack.m_41720_() != ModItems.SOUL_SHARD) continue;
            shards += stack.m_41613_();
        }
        return shards;
    }

    public static boolean reduceShardAmount(Inventory playerInventory, int count, boolean simulate) {
        for (int slot = 0; slot < playerInventory.m_6643_(); ++slot) {
            ItemStack stack = playerInventory.m_8020_(slot);
            if (stack.m_41720_() instanceof ItemShardPouch) {
                ItemStack shardStack = ItemShardPouch.getContainedStack(stack);
                int toReduce = Math.min(count, shardStack.m_41613_());
                if (!simulate) {
                    shardStack.m_41764_(shardStack.m_41613_() - toReduce);
                    ItemShardPouch.setContainedStack(stack, shardStack);
                }
                count -= toReduce;
            } else if (stack.m_41720_() == ModItems.SOUL_SHARD) {
                int toReduce = Math.min(count, stack.m_41613_());
                if (!simulate) {
                    stack.m_41774_(toReduce);
                    playerInventory.m_6836_(slot, stack);
                }
                count -= toReduce;
            }
            if (count > 0) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getContainedStack(ItemStack pouch) {
        CompoundTag invTag = pouch.m_41698_("Inventory");
        int count = invTag.m_128451_("StackSize");
        if (count > 0) {
            return new ItemStack((ItemLike)ModItems.SOUL_SHARD, count);
        }
        return ItemStack.f_41583_;
    }

    public static void setContainedStack(ItemStack pouch, ItemStack contained) {
        CompoundTag invTag = pouch.m_41698_("Inventory");
        invTag.m_128405_("StackSize", contained.m_41613_());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.m_5776_() && player instanceof ServerPlayer) {
            final int pouchSlot = hand == InteractionHand.OFF_HAND ? 40 : player.m_150109_().f_35977_;
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return new TextComponent("Shard Pouch");
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                    return new ShardPouchContainer(windowId, inventory, pouchSlot);
                }
            }, buf -> buf.writeInt(pouchSlot));
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public static NonNullSupplier<IItemHandler> getInventorySupplier(final ItemStack stack) {
        return new NonNullSupplier<IItemHandler>(){

            @Nonnull
            public IItemHandler get() {
                return new Handler(stack);
            }
        };
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? LazyOptional.of(ItemShardPouch.getInventorySupplier(stack)).cast() : LazyOptional.empty();
            }
        };
    }

    public static class Handler
    extends ItemStackHandler {
        private final ItemStack delegate;

        public Handler(ItemStack delegate) {
            super(1);
            this.delegate = delegate;
            this.stacks.set(0, (Object)ItemShardPouch.getContainedStack(this.delegate));
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ItemShardPouch.setContainedStack(this.delegate, this.getStackInSlot(0));
        }

        public int getSlotLimit(int slot) {
            return 2147483582;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return this.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.m_41720_() == ModItems.SOUL_SHARD;
        }
    }
}

